<?php

namespace Ups\upsshipStruct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ShipmentChargeType upsshipStruct
 * @package Ups
 * @subpackage Structs
 */
class UpsShipmentChargeType extends AbstractStructBase
{
    /**
     * The Type
     * @var string
     */
    public $Type;
    /**
     * The BillShipper
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \Ups\upsshipStruct\UpsBillShipperType
     */
    public $BillShipper;
    /**
     * The BillReceiver
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \Ups\upsshipStruct\UpsBillReceiverType
     */
    public $BillReceiver;
    /**
     * The BillThirdParty
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \Ups\upsshipStruct\UpsBillThirdPartyChargeType
     */
    public $BillThirdParty;
    /**
     * The ConsigneeBilledIndicator
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ConsigneeBilledIndicator;
    /**
     * Constructor method for ShipmentChargeType
     * @uses UpsShipmentChargeType::setType()
     * @uses UpsShipmentChargeType::setBillShipper()
     * @uses UpsShipmentChargeType::setBillReceiver()
     * @uses UpsShipmentChargeType::setBillThirdParty()
     * @uses UpsShipmentChargeType::setConsigneeBilledIndicator()
     * @param string $type
     * @param \Ups\upsshipStruct\UpsBillShipperType $billShipper
     * @param \Ups\upsshipStruct\UpsBillReceiverType $billReceiver
     * @param \Ups\upsshipStruct\UpsBillThirdPartyChargeType $billThirdParty
     * @param string $consigneeBilledIndicator
     */
    public function __construct($type = null, \Ups\upsshipStruct\UpsBillShipperType $billShipper = null, \Ups\upsshipStruct\UpsBillReceiverType $billReceiver = null, \Ups\upsshipStruct\UpsBillThirdPartyChargeType $billThirdParty = null, $consigneeBilledIndicator = null)
    {
        $this
            ->setType($type)
            ->setBillShipper($billShipper)
            ->setBillReceiver($billReceiver)
            ->setBillThirdParty($billThirdParty)
            ->setConsigneeBilledIndicator($consigneeBilledIndicator);
    }
    /**
     * Get Type value
     * @return string|null
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @param string $type
     * @return \Ups\upsshipStruct\UpsShipmentChargeType
     */
    public function setType($type = null)
    {
        // validation for constraint: string
        if (!is_null($type) && !is_string($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($type, true), gettype($type)), __LINE__);
        }
        $this->Type = $type;
        return $this;
    }
    /**
     * Get BillShipper value
     * @return \Ups\upsshipStruct\UpsBillShipperType|null
     */
    public function getBillShipper()
    {
        return $this->BillShipper;
    }
    /**
     * Set BillShipper value
     * @param \Ups\upsshipStruct\UpsBillShipperType $billShipper
     * @return \Ups\upsshipStruct\UpsShipmentChargeType
     */
    public function setBillShipper(\Ups\upsshipStruct\UpsBillShipperType $billShipper = null)
    {
        $this->BillShipper = $billShipper;
        return $this;
    }
    /**
     * Get BillReceiver value
     * @return \Ups\upsshipStruct\UpsBillReceiverType|null
     */
    public function getBillReceiver()
    {
        return $this->BillReceiver;
    }
    /**
     * Set BillReceiver value
     * @param \Ups\upsshipStruct\UpsBillReceiverType $billReceiver
     * @return \Ups\upsshipStruct\UpsShipmentChargeType
     */
    public function setBillReceiver(\Ups\upsshipStruct\UpsBillReceiverType $billReceiver = null)
    {
        $this->BillReceiver = $billReceiver;
        return $this;
    }
    /**
     * Get BillThirdParty value
     * @return \Ups\upsshipStruct\UpsBillThirdPartyChargeType|null
     */
    public function getBillThirdParty()
    {
        return $this->BillThirdParty;
    }
    /**
     * Set BillThirdParty value
     * @param \Ups\upsshipStruct\UpsBillThirdPartyChargeType $billThirdParty
     * @return \Ups\upsshipStruct\UpsShipmentChargeType
     */
    public function setBillThirdParty(\Ups\upsshipStruct\UpsBillThirdPartyChargeType $billThirdParty = null)
    {
        $this->BillThirdParty = $billThirdParty;
        return $this;
    }
    /**
     * Get ConsigneeBilledIndicator value
     * @return string|null
     */
    public function getConsigneeBilledIndicator()
    {
        return $this->ConsigneeBilledIndicator;
    }
    /**
     * Set ConsigneeBilledIndicator value
     * @param string $consigneeBilledIndicator
     * @return \Ups\upsshipStruct\UpsShipmentChargeType
     */
    public function setConsigneeBilledIndicator($consigneeBilledIndicator = null)
    {
        // validation for constraint: string
        if (!is_null($consigneeBilledIndicator) && !is_string($consigneeBilledIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($consigneeBilledIndicator, true), gettype($consigneeBilledIndicator)), __LINE__);
        }
        $this->ConsigneeBilledIndicator = $consigneeBilledIndicator;
        return $this;
    }
}
