<?php

namespace Ups\upsshipStruct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PackageResultsType upsshipStruct
 * @package Ups
 * @subpackage Structs
 */
class UpsPackageResultsType extends AbstractStructBase
{
    /**
     * The TrackingNumber
     * @var string
     */
    public $TrackingNumber;
    /**
     * The BaseServiceCharge
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \Ups\upsshipStruct\UpsShipChargeType
     */
    public $BaseServiceCharge;
    /**
     * The ServiceOptionsCharges
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \Ups\upsshipStruct\UpsShipChargeType
     */
    public $ServiceOptionsCharges;
    /**
     * The ShippingLabel
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \Ups\upsshipStruct\UpsLabelType
     */
    public $ShippingLabel;
    /**
     * The ShippingReceipt
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \Ups\upsshipStruct\UpsReceiptType
     */
    public $ShippingReceipt;
    /**
     * The USPSPICNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $USPSPICNumber;
    /**
     * The CN22Number
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $CN22Number;
    /**
     * The Accessorial
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Ups\upsshipStruct\UpsAccessorialType[]
     */
    public $Accessorial;
    /**
     * The Form
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \Ups\upsshipStruct\UpsFormType
     */
    public $Form;
    /**
     * The ItemizedCharges
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Ups\upsshipStruct\UpsShipChargeType[]
     */
    public $ItemizedCharges;
    /**
     * The NegotiatedCharges
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \Ups\upsshipStruct\UpsNegotiatedChargesType
     */
    public $NegotiatedCharges;
    /**
     * The SimpleRate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \Ups\upsshipStruct\UpsSimpleRateType
     */
    public $SimpleRate;
    /**
     * The SensorID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $SensorID;
    /**
     * Constructor method for PackageResultsType
     * @uses UpsPackageResultsType::setTrackingNumber()
     * @uses UpsPackageResultsType::setBaseServiceCharge()
     * @uses UpsPackageResultsType::setServiceOptionsCharges()
     * @uses UpsPackageResultsType::setShippingLabel()
     * @uses UpsPackageResultsType::setShippingReceipt()
     * @uses UpsPackageResultsType::setUSPSPICNumber()
     * @uses UpsPackageResultsType::setCN22Number()
     * @uses UpsPackageResultsType::setAccessorial()
     * @uses UpsPackageResultsType::setForm()
     * @uses UpsPackageResultsType::setItemizedCharges()
     * @uses UpsPackageResultsType::setNegotiatedCharges()
     * @uses UpsPackageResultsType::setSimpleRate()
     * @uses UpsPackageResultsType::setSensorID()
     * @param string $trackingNumber
     * @param \Ups\upsshipStruct\UpsShipChargeType $baseServiceCharge
     * @param \Ups\upsshipStruct\UpsShipChargeType $serviceOptionsCharges
     * @param \Ups\upsshipStruct\UpsLabelType $shippingLabel
     * @param \Ups\upsshipStruct\UpsReceiptType $shippingReceipt
     * @param string $uSPSPICNumber
     * @param string $cN22Number
     * @param \Ups\upsshipStruct\UpsAccessorialType[] $accessorial
     * @param \Ups\upsshipStruct\UpsFormType $form
     * @param \Ups\upsshipStruct\UpsShipChargeType[] $itemizedCharges
     * @param \Ups\upsshipStruct\UpsNegotiatedChargesType $negotiatedCharges
     * @param \Ups\upsshipStruct\UpsSimpleRateType $simpleRate
     * @param string $sensorID
     */
    public function __construct($trackingNumber = null, \Ups\upsshipStruct\UpsShipChargeType $baseServiceCharge = null, \Ups\upsshipStruct\UpsShipChargeType $serviceOptionsCharges = null, \Ups\upsshipStruct\UpsLabelType $shippingLabel = null, \Ups\upsshipStruct\UpsReceiptType $shippingReceipt = null, $uSPSPICNumber = null, $cN22Number = null, array $accessorial = array(), \Ups\upsshipStruct\UpsFormType $form = null, array $itemizedCharges = array(), \Ups\upsshipStruct\UpsNegotiatedChargesType $negotiatedCharges = null, \Ups\upsshipStruct\UpsSimpleRateType $simpleRate = null, $sensorID = null)
    {
        $this
            ->setTrackingNumber($trackingNumber)
            ->setBaseServiceCharge($baseServiceCharge)
            ->setServiceOptionsCharges($serviceOptionsCharges)
            ->setShippingLabel($shippingLabel)
            ->setShippingReceipt($shippingReceipt)
            ->setUSPSPICNumber($uSPSPICNumber)
            ->setCN22Number($cN22Number)
            ->setAccessorial($accessorial)
            ->setForm($form)
            ->setItemizedCharges($itemizedCharges)
            ->setNegotiatedCharges($negotiatedCharges)
            ->setSimpleRate($simpleRate)
            ->setSensorID($sensorID);
    }
    /**
     * Get TrackingNumber value
     * @return string|null
     */
    public function getTrackingNumber()
    {
        return $this->TrackingNumber;
    }
    /**
     * Set TrackingNumber value
     * @param string $trackingNumber
     * @return \Ups\upsshipStruct\UpsPackageResultsType
     */
    public function setTrackingNumber($trackingNumber = null)
    {
        // validation for constraint: string
        if (!is_null($trackingNumber) && !is_string($trackingNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($trackingNumber, true), gettype($trackingNumber)), __LINE__);
        }
        $this->TrackingNumber = $trackingNumber;
        return $this;
    }
    /**
     * Get BaseServiceCharge value
     * @return \Ups\upsshipStruct\UpsShipChargeType|null
     */
    public function getBaseServiceCharge()
    {
        return $this->BaseServiceCharge;
    }
    /**
     * Set BaseServiceCharge value
     * @param \Ups\upsshipStruct\UpsShipChargeType $baseServiceCharge
     * @return \Ups\upsshipStruct\UpsPackageResultsType
     */
    public function setBaseServiceCharge(\Ups\upsshipStruct\UpsShipChargeType $baseServiceCharge = null)
    {
        $this->BaseServiceCharge = $baseServiceCharge;
        return $this;
    }
    /**
     * Get ServiceOptionsCharges value
     * @return \Ups\upsshipStruct\UpsShipChargeType|null
     */
    public function getServiceOptionsCharges()
    {
        return $this->ServiceOptionsCharges;
    }
    /**
     * Set ServiceOptionsCharges value
     * @param \Ups\upsshipStruct\UpsShipChargeType $serviceOptionsCharges
     * @return \Ups\upsshipStruct\UpsPackageResultsType
     */
    public function setServiceOptionsCharges(\Ups\upsshipStruct\UpsShipChargeType $serviceOptionsCharges = null)
    {
        $this->ServiceOptionsCharges = $serviceOptionsCharges;
        return $this;
    }
    /**
     * Get ShippingLabel value
     * @return \Ups\upsshipStruct\UpsLabelType|null
     */
    public function getShippingLabel()
    {
        return $this->ShippingLabel;
    }
    /**
     * Set ShippingLabel value
     * @param \Ups\upsshipStruct\UpsLabelType $shippingLabel
     * @return \Ups\upsshipStruct\UpsPackageResultsType
     */
    public function setShippingLabel(\Ups\upsshipStruct\UpsLabelType $shippingLabel = null)
    {
        $this->ShippingLabel = $shippingLabel;
        return $this;
    }
    /**
     * Get ShippingReceipt value
     * @return \Ups\upsshipStruct\UpsReceiptType|null
     */
    public function getShippingReceipt()
    {
        return $this->ShippingReceipt;
    }
    /**
     * Set ShippingReceipt value
     * @param \Ups\upsshipStruct\UpsReceiptType $shippingReceipt
     * @return \Ups\upsshipStruct\UpsPackageResultsType
     */
    public function setShippingReceipt(\Ups\upsshipStruct\UpsReceiptType $shippingReceipt = null)
    {
        $this->ShippingReceipt = $shippingReceipt;
        return $this;
    }
    /**
     * Get USPSPICNumber value
     * @return string|null
     */
    public function getUSPSPICNumber()
    {
        return $this->USPSPICNumber;
    }
    /**
     * Set USPSPICNumber value
     * @param string $uSPSPICNumber
     * @return \Ups\upsshipStruct\UpsPackageResultsType
     */
    public function setUSPSPICNumber($uSPSPICNumber = null)
    {
        // validation for constraint: string
        if (!is_null($uSPSPICNumber) && !is_string($uSPSPICNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uSPSPICNumber, true), gettype($uSPSPICNumber)), __LINE__);
        }
        $this->USPSPICNumber = $uSPSPICNumber;
        return $this;
    }
    /**
     * Get CN22Number value
     * @return string|null
     */
    public function getCN22Number()
    {
        return $this->CN22Number;
    }
    /**
     * Set CN22Number value
     * @param string $cN22Number
     * @return \Ups\upsshipStruct\UpsPackageResultsType
     */
    public function setCN22Number($cN22Number = null)
    {
        // validation for constraint: string
        if (!is_null($cN22Number) && !is_string($cN22Number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cN22Number, true), gettype($cN22Number)), __LINE__);
        }
        $this->CN22Number = $cN22Number;
        return $this;
    }
    /**
     * Get Accessorial value
     * @return \Ups\upsshipStruct\UpsAccessorialType[]|null
     */
    public function getAccessorial()
    {
        return $this->Accessorial;
    }
    /**
     * This method is responsible for validating the values passed to the setAccessorial method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAccessorial method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAccessorialForArrayConstraintsFromSetAccessorial(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $packageResultsTypeAccessorialItem) {
            // validation for constraint: itemType
            if (!$packageResultsTypeAccessorialItem instanceof \Ups\upsshipStruct\UpsAccessorialType) {
                $invalidValues[] = is_object($packageResultsTypeAccessorialItem) ? get_class($packageResultsTypeAccessorialItem) : sprintf('%s(%s)', gettype($packageResultsTypeAccessorialItem), var_export($packageResultsTypeAccessorialItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Accessorial property can only contain items of type \Ups\upsshipStruct\UpsAccessorialType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Accessorial value
     * @throws \InvalidArgumentException
     * @param \Ups\upsshipStruct\UpsAccessorialType[] $accessorial
     * @return \Ups\upsshipStruct\UpsPackageResultsType
     */
    public function setAccessorial(array $accessorial = array())
    {
        // validation for constraint: array
        if ('' !== ($accessorialArrayErrorMessage = self::validateAccessorialForArrayConstraintsFromSetAccessorial($accessorial))) {
            throw new \InvalidArgumentException($accessorialArrayErrorMessage, __LINE__);
        }
        $this->Accessorial = $accessorial;
        return $this;
    }
    /**
     * Add item to Accessorial value
     * @throws \InvalidArgumentException
     * @param \Ups\upsshipStruct\UpsAccessorialType $item
     * @return \Ups\upsshipStruct\UpsPackageResultsType
     */
    public function addToAccessorial(\Ups\upsshipStruct\UpsAccessorialType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Ups\upsshipStruct\UpsAccessorialType) {
            throw new \InvalidArgumentException(sprintf('The Accessorial property can only contain items of type \Ups\upsshipStruct\UpsAccessorialType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Accessorial[] = $item;
        return $this;
    }
    /**
     * Get Form value
     * @return \Ups\upsshipStruct\UpsFormType|null
     */
    public function getForm()
    {
        return $this->Form;
    }
    /**
     * Set Form value
     * @param \Ups\upsshipStruct\UpsFormType $form
     * @return \Ups\upsshipStruct\UpsPackageResultsType
     */
    public function setForm(\Ups\upsshipStruct\UpsFormType $form = null)
    {
        $this->Form = $form;
        return $this;
    }
    /**
     * Get ItemizedCharges value
     * @return \Ups\upsshipStruct\UpsShipChargeType[]|null
     */
    public function getItemizedCharges()
    {
        return $this->ItemizedCharges;
    }
    /**
     * This method is responsible for validating the values passed to the setItemizedCharges method
     * This method is willingly generated in order to preserve the one-line inline validation within the setItemizedCharges method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateItemizedChargesForArrayConstraintsFromSetItemizedCharges(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $packageResultsTypeItemizedChargesItem) {
            // validation for constraint: itemType
            if (!$packageResultsTypeItemizedChargesItem instanceof \Ups\upsshipStruct\UpsShipChargeType) {
                $invalidValues[] = is_object($packageResultsTypeItemizedChargesItem) ? get_class($packageResultsTypeItemizedChargesItem) : sprintf('%s(%s)', gettype($packageResultsTypeItemizedChargesItem), var_export($packageResultsTypeItemizedChargesItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ItemizedCharges property can only contain items of type \Ups\upsshipStruct\UpsShipChargeType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ItemizedCharges value
     * @throws \InvalidArgumentException
     * @param \Ups\upsshipStruct\UpsShipChargeType[] $itemizedCharges
     * @return \Ups\upsshipStruct\UpsPackageResultsType
     */
    public function setItemizedCharges(array $itemizedCharges = array())
    {
        // validation for constraint: array
        if ('' !== ($itemizedChargesArrayErrorMessage = self::validateItemizedChargesForArrayConstraintsFromSetItemizedCharges($itemizedCharges))) {
            throw new \InvalidArgumentException($itemizedChargesArrayErrorMessage, __LINE__);
        }
        $this->ItemizedCharges = $itemizedCharges;
        return $this;
    }
    /**
     * Add item to ItemizedCharges value
     * @throws \InvalidArgumentException
     * @param \Ups\upsshipStruct\UpsShipChargeType $item
     * @return \Ups\upsshipStruct\UpsPackageResultsType
     */
    public function addToItemizedCharges(\Ups\upsshipStruct\UpsShipChargeType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Ups\upsshipStruct\UpsShipChargeType) {
            throw new \InvalidArgumentException(sprintf('The ItemizedCharges property can only contain items of type \Ups\upsshipStruct\UpsShipChargeType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ItemizedCharges[] = $item;
        return $this;
    }
    /**
     * Get NegotiatedCharges value
     * @return \Ups\upsshipStruct\UpsNegotiatedChargesType|null
     */
    public function getNegotiatedCharges()
    {
        return $this->NegotiatedCharges;
    }
    /**
     * Set NegotiatedCharges value
     * @param \Ups\upsshipStruct\UpsNegotiatedChargesType $negotiatedCharges
     * @return \Ups\upsshipStruct\UpsPackageResultsType
     */
    public function setNegotiatedCharges(\Ups\upsshipStruct\UpsNegotiatedChargesType $negotiatedCharges = null)
    {
        $this->NegotiatedCharges = $negotiatedCharges;
        return $this;
    }
    /**
     * Get SimpleRate value
     * @return \Ups\upsshipStruct\UpsSimpleRateType|null
     */
    public function getSimpleRate()
    {
        return $this->SimpleRate;
    }
    /**
     * Set SimpleRate value
     * @param \Ups\upsshipStruct\UpsSimpleRateType $simpleRate
     * @return \Ups\upsshipStruct\UpsPackageResultsType
     */
    public function setSimpleRate(\Ups\upsshipStruct\UpsSimpleRateType $simpleRate = null)
    {
        $this->SimpleRate = $simpleRate;
        return $this;
    }
    /**
     * Get SensorID value
     * @return string|null
     */
    public function getSensorID()
    {
        return $this->SensorID;
    }
    /**
     * Set SensorID value
     * @param string $sensorID
     * @return \Ups\upsshipStruct\UpsPackageResultsType
     */
    public function setSensorID($sensorID = null)
    {
        // validation for constraint: string
        if (!is_null($sensorID) && !is_string($sensorID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sensorID, true), gettype($sensorID)), __LINE__);
        }
        $this->SensorID = $sensorID;
        return $this;
    }
}
