<?php

namespace Ups\upsshipStruct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PSOCODType upsshipStruct
 * @package Ups
 * @subpackage Structs
 */
class UpsPSOCODType extends AbstractStructBase
{
    /**
     * The CODFundsCode
     * @var string
     */
    public $CODFundsCode;
    /**
     * The CODAmount
     * @var \Ups\upsshipStruct\UpsCurrencyMonetaryType
     */
    public $CODAmount;
    /**
     * Constructor method for PSOCODType
     * @uses UpsPSOCODType::setCODFundsCode()
     * @uses UpsPSOCODType::setCODAmount()
     * @param string $cODFundsCode
     * @param \Ups\upsshipStruct\UpsCurrencyMonetaryType $cODAmount
     */
    public function __construct($cODFundsCode = null, \Ups\upsshipStruct\UpsCurrencyMonetaryType $cODAmount = null)
    {
        $this
            ->setCODFundsCode($cODFundsCode)
            ->setCODAmount($cODAmount);
    }
    /**
     * Get CODFundsCode value
     * @return string|null
     */
    public function getCODFundsCode()
    {
        return $this->CODFundsCode;
    }
    /**
     * Set CODFundsCode value
     * @param string $cODFundsCode
     * @return \Ups\upsshipStruct\UpsPSOCODType
     */
    public function setCODFundsCode($cODFundsCode = null)
    {
        // validation for constraint: string
        if (!is_null($cODFundsCode) && !is_string($cODFundsCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cODFundsCode, true), gettype($cODFundsCode)), __LINE__);
        }
        $this->CODFundsCode = $cODFundsCode;
        return $this;
    }
    /**
     * Get CODAmount value
     * @return \Ups\upsshipStruct\UpsCurrencyMonetaryType|null
     */
    public function getCODAmount()
    {
        return $this->CODAmount;
    }
    /**
     * Set CODAmount value
     * @param \Ups\upsshipStruct\UpsCurrencyMonetaryType $cODAmount
     * @return \Ups\upsshipStruct\UpsPSOCODType
     */
    public function setCODAmount(\Ups\upsshipStruct\UpsCurrencyMonetaryType $cODAmount = null)
    {
        $this->CODAmount = $cODAmount;
        return $this;
    }
}
