<?php

namespace Ups\upsshipStruct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ImageType upsshipStruct
 * @package Ups
 * @subpackage Structs
 */
class UpsImageType extends AbstractStructBase
{
    /**
     * The ImageFormat
     * @var \Ups\upsshipStruct\UpsImageFormatType
     */
    public $ImageFormat;
    /**
     * The GraphicImage
     * @var string
     */
    public $GraphicImage;
    /**
     * Constructor method for ImageType
     * @uses UpsImageType::setImageFormat()
     * @uses UpsImageType::setGraphicImage()
     * @param \Ups\upsshipStruct\UpsImageFormatType $imageFormat
     * @param string $graphicImage
     */
    public function __construct(\Ups\upsshipStruct\UpsImageFormatType $imageFormat = null, $graphicImage = null)
    {
        $this
            ->setImageFormat($imageFormat)
            ->setGraphicImage($graphicImage);
    }
    /**
     * Get ImageFormat value
     * @return \Ups\upsshipStruct\UpsImageFormatType|null
     */
    public function getImageFormat()
    {
        return $this->ImageFormat;
    }
    /**
     * Set ImageFormat value
     * @param \Ups\upsshipStruct\UpsImageFormatType $imageFormat
     * @return \Ups\upsshipStruct\UpsImageType
     */
    public function setImageFormat(\Ups\upsshipStruct\UpsImageFormatType $imageFormat = null)
    {
        $this->ImageFormat = $imageFormat;
        return $this;
    }
    /**
     * Get GraphicImage value
     * @return string|null
     */
    public function getGraphicImage()
    {
        return $this->GraphicImage;
    }
    /**
     * Set GraphicImage value
     * @param string $graphicImage
     * @return \Ups\upsshipStruct\UpsImageType
     */
    public function setGraphicImage($graphicImage = null)
    {
        // validation for constraint: string
        if (!is_null($graphicImage) && !is_string($graphicImage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($graphicImage, true), gettype($graphicImage)), __LINE__);
        }
        $this->GraphicImage = $graphicImage;
        return $this;
    }
}
