<?php

namespace Ups\upsshipStruct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FreightDensityInfoType upsshipStruct
 * @package Ups
 * @subpackage Structs
 */
class UpsFreightDensityInfoType extends AbstractStructBase
{
    /**
     * The AdjustedHeightIndicator
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $AdjustedHeightIndicator;
    /**
     * The AdjustedHeight
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \Ups\upsshipStruct\UpsAdjustedHeightType
     */
    public $AdjustedHeight;
    /**
     * The HandlingUnits
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Ups\upsshipStruct\UpsHandlingUnitsType[]
     */
    public $HandlingUnits;
    /**
     * Constructor method for FreightDensityInfoType
     * @uses UpsFreightDensityInfoType::setAdjustedHeightIndicator()
     * @uses UpsFreightDensityInfoType::setAdjustedHeight()
     * @uses UpsFreightDensityInfoType::setHandlingUnits()
     * @param string $adjustedHeightIndicator
     * @param \Ups\upsshipStruct\UpsAdjustedHeightType $adjustedHeight
     * @param \Ups\upsshipStruct\UpsHandlingUnitsType[] $handlingUnits
     */
    public function __construct($adjustedHeightIndicator = null, \Ups\upsshipStruct\UpsAdjustedHeightType $adjustedHeight = null, array $handlingUnits = array())
    {
        $this
            ->setAdjustedHeightIndicator($adjustedHeightIndicator)
            ->setAdjustedHeight($adjustedHeight)
            ->setHandlingUnits($handlingUnits);
    }
    /**
     * Get AdjustedHeightIndicator value
     * @return string|null
     */
    public function getAdjustedHeightIndicator()
    {
        return $this->AdjustedHeightIndicator;
    }
    /**
     * Set AdjustedHeightIndicator value
     * @param string $adjustedHeightIndicator
     * @return \Ups\upsshipStruct\UpsFreightDensityInfoType
     */
    public function setAdjustedHeightIndicator($adjustedHeightIndicator = null)
    {
        // validation for constraint: string
        if (!is_null($adjustedHeightIndicator) && !is_string($adjustedHeightIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($adjustedHeightIndicator, true), gettype($adjustedHeightIndicator)), __LINE__);
        }
        $this->AdjustedHeightIndicator = $adjustedHeightIndicator;
        return $this;
    }
    /**
     * Get AdjustedHeight value
     * @return \Ups\upsshipStruct\UpsAdjustedHeightType|null
     */
    public function getAdjustedHeight()
    {
        return $this->AdjustedHeight;
    }
    /**
     * Set AdjustedHeight value
     * @param \Ups\upsshipStruct\UpsAdjustedHeightType $adjustedHeight
     * @return \Ups\upsshipStruct\UpsFreightDensityInfoType
     */
    public function setAdjustedHeight(\Ups\upsshipStruct\UpsAdjustedHeightType $adjustedHeight = null)
    {
        $this->AdjustedHeight = $adjustedHeight;
        return $this;
    }
    /**
     * Get HandlingUnits value
     * @return \Ups\upsshipStruct\UpsHandlingUnitsType[]|null
     */
    public function getHandlingUnits()
    {
        return $this->HandlingUnits;
    }
    /**
     * This method is responsible for validating the values passed to the setHandlingUnits method
     * This method is willingly generated in order to preserve the one-line inline validation within the setHandlingUnits method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateHandlingUnitsForArrayConstraintsFromSetHandlingUnits(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $freightDensityInfoTypeHandlingUnitsItem) {
            // validation for constraint: itemType
            if (!$freightDensityInfoTypeHandlingUnitsItem instanceof \Ups\upsshipStruct\UpsHandlingUnitsType) {
                $invalidValues[] = is_object($freightDensityInfoTypeHandlingUnitsItem) ? get_class($freightDensityInfoTypeHandlingUnitsItem) : sprintf('%s(%s)', gettype($freightDensityInfoTypeHandlingUnitsItem), var_export($freightDensityInfoTypeHandlingUnitsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The HandlingUnits property can only contain items of type \Ups\upsshipStruct\UpsHandlingUnitsType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set HandlingUnits value
     * @throws \InvalidArgumentException
     * @param \Ups\upsshipStruct\UpsHandlingUnitsType[] $handlingUnits
     * @return \Ups\upsshipStruct\UpsFreightDensityInfoType
     */
    public function setHandlingUnits(array $handlingUnits = array())
    {
        // validation for constraint: array
        if ('' !== ($handlingUnitsArrayErrorMessage = self::validateHandlingUnitsForArrayConstraintsFromSetHandlingUnits($handlingUnits))) {
            throw new \InvalidArgumentException($handlingUnitsArrayErrorMessage, __LINE__);
        }
        $this->HandlingUnits = $handlingUnits;
        return $this;
    }
    /**
     * Add item to HandlingUnits value
     * @throws \InvalidArgumentException
     * @param \Ups\upsshipStruct\UpsHandlingUnitsType $item
     * @return \Ups\upsshipStruct\UpsFreightDensityInfoType
     */
    public function addToHandlingUnits(\Ups\upsshipStruct\UpsHandlingUnitsType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Ups\upsshipStruct\UpsHandlingUnitsType) {
            throw new \InvalidArgumentException(sprintf('The HandlingUnits property can only contain items of type \Ups\upsshipStruct\UpsHandlingUnitsType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->HandlingUnits[] = $item;
        return $this;
    }
}
