<?php

namespace Ups\upsshipStruct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DetailType upsshipStruct
 * @package Ups
 * @subpackage Structs
 */
class UpsDetailType extends AbstractStructBase
{
    /**
     * The Code
     * @var string
     */
    public $Code;
    /**
     * The Description
     * @var string
     */
    public $Description;
    /**
     * The ElementLevelInformation
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \Ups\upsshipStruct\UpsElementLevelInformationType
     */
    public $ElementLevelInformation;
    /**
     * Constructor method for DetailType
     * @uses UpsDetailType::setCode()
     * @uses UpsDetailType::setDescription()
     * @uses UpsDetailType::setElementLevelInformation()
     * @param string $code
     * @param string $description
     * @param \Ups\upsshipStruct\UpsElementLevelInformationType $elementLevelInformation
     */
    public function __construct($code = null, $description = null, \Ups\upsshipStruct\UpsElementLevelInformationType $elementLevelInformation = null)
    {
        $this
            ->setCode($code)
            ->setDescription($description)
            ->setElementLevelInformation($elementLevelInformation);
    }
    /**
     * Get Code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @param string $code
     * @return \Ups\upsshipStruct\UpsDetailType
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($code, true), gettype($code)), __LINE__);
        }
        $this->Code = $code;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \Ups\upsshipStruct\UpsDetailType
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Get ElementLevelInformation value
     * @return \Ups\upsshipStruct\UpsElementLevelInformationType|null
     */
    public function getElementLevelInformation()
    {
        return $this->ElementLevelInformation;
    }
    /**
     * Set ElementLevelInformation value
     * @param \Ups\upsshipStruct\UpsElementLevelInformationType $elementLevelInformation
     * @return \Ups\upsshipStruct\UpsDetailType
     */
    public function setElementLevelInformation(\Ups\upsshipStruct\UpsElementLevelInformationType $elementLevelInformation = null)
    {
        $this->ElementLevelInformation = $elementLevelInformation;
        return $this;
    }
}
