<?php

namespace Ups\upsshipStruct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BillShipperType upsshipStruct
 * @package Ups
 * @subpackage Structs
 */
class UpsBillShipperType extends AbstractStructBase
{
    /**
     * The AccountNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $AccountNumber;
    /**
     * The CreditCard
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \Ups\upsshipStruct\UpsCreditCardType
     */
    public $CreditCard;
    /**
     * The AlternatePaymentMethod
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $AlternatePaymentMethod;
    /**
     * Constructor method for BillShipperType
     * @uses UpsBillShipperType::setAccountNumber()
     * @uses UpsBillShipperType::setCreditCard()
     * @uses UpsBillShipperType::setAlternatePaymentMethod()
     * @param string $accountNumber
     * @param \Ups\upsshipStruct\UpsCreditCardType $creditCard
     * @param string $alternatePaymentMethod
     */
    public function __construct($accountNumber = null, \Ups\upsshipStruct\UpsCreditCardType $creditCard = null, $alternatePaymentMethod = null)
    {
        $this
            ->setAccountNumber($accountNumber)
            ->setCreditCard($creditCard)
            ->setAlternatePaymentMethod($alternatePaymentMethod);
    }
    /**
     * Get AccountNumber value
     * @return string|null
     */
    public function getAccountNumber()
    {
        return $this->AccountNumber;
    }
    /**
     * Set AccountNumber value
     * @param string $accountNumber
     * @return \Ups\upsshipStruct\UpsBillShipperType
     */
    public function setAccountNumber($accountNumber = null)
    {
        // validation for constraint: string
        if (!is_null($accountNumber) && !is_string($accountNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accountNumber, true), gettype($accountNumber)), __LINE__);
        }
        $this->AccountNumber = $accountNumber;
        return $this;
    }
    /**
     * Get CreditCard value
     * @return \Ups\upsshipStruct\UpsCreditCardType|null
     */
    public function getCreditCard()
    {
        return $this->CreditCard;
    }
    /**
     * Set CreditCard value
     * @param \Ups\upsshipStruct\UpsCreditCardType $creditCard
     * @return \Ups\upsshipStruct\UpsBillShipperType
     */
    public function setCreditCard(\Ups\upsshipStruct\UpsCreditCardType $creditCard = null)
    {
        $this->CreditCard = $creditCard;
        return $this;
    }
    /**
     * Get AlternatePaymentMethod value
     * @return string|null
     */
    public function getAlternatePaymentMethod()
    {
        return $this->AlternatePaymentMethod;
    }
    /**
     * Set AlternatePaymentMethod value
     * @param string $alternatePaymentMethod
     * @return \Ups\upsshipStruct\UpsBillShipperType
     */
    public function setAlternatePaymentMethod($alternatePaymentMethod = null)
    {
        // validation for constraint: string
        if (!is_null($alternatePaymentMethod) && !is_string($alternatePaymentMethod)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($alternatePaymentMethod, true), gettype($alternatePaymentMethod)), __LINE__);
        }
        $this->AlternatePaymentMethod = $alternatePaymentMethod;
        return $this;
    }
}
