<?php

namespace Ups\upsshipStruct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UnitType upsshipStruct
 * @package Ups
 * @subpackage Structs
 */
class UpsUnitType extends AbstractStructBase
{
    /**
     * The Number
     * @var string
     */
    public $Number;
    /**
     * The UnitOfMeasurement
     * @var \Ups\upsshipStruct\UpsUnitOfMeasurementType
     */
    public $UnitOfMeasurement;
    /**
     * The Value
     * @var string
     */
    public $Value;
    /**
     * Constructor method for UnitType
     * @uses UpsUnitType::setNumber()
     * @uses UpsUnitType::setUnitOfMeasurement()
     * @uses UpsUnitType::setValue()
     * @param string $number
     * @param \Ups\upsshipStruct\UpsUnitOfMeasurementType $unitOfMeasurement
     * @param string $value
     */
    public function __construct($number = null, \Ups\upsshipStruct\UpsUnitOfMeasurementType $unitOfMeasurement = null, $value = null)
    {
        $this
            ->setNumber($number)
            ->setUnitOfMeasurement($unitOfMeasurement)
            ->setValue($value);
    }
    /**
     * Get Number value
     * @return string|null
     */
    public function getNumber()
    {
        return $this->Number;
    }
    /**
     * Set Number value
     * @param string $number
     * @return \Ups\upsshipStruct\UpsUnitType
     */
    public function setNumber($number = null)
    {
        // validation for constraint: string
        if (!is_null($number) && !is_string($number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($number, true), gettype($number)), __LINE__);
        }
        $this->Number = $number;
        return $this;
    }
    /**
     * Get UnitOfMeasurement value
     * @return \Ups\upsshipStruct\UpsUnitOfMeasurementType|null
     */
    public function getUnitOfMeasurement()
    {
        return $this->UnitOfMeasurement;
    }
    /**
     * Set UnitOfMeasurement value
     * @param \Ups\upsshipStruct\UpsUnitOfMeasurementType $unitOfMeasurement
     * @return \Ups\upsshipStruct\UpsUnitType
     */
    public function setUnitOfMeasurement(\Ups\upsshipStruct\UpsUnitOfMeasurementType $unitOfMeasurement = null)
    {
        $this->UnitOfMeasurement = $unitOfMeasurement;
        return $this;
    }
    /**
     * Get Value value
     * @return string|null
     */
    public function getValue()
    {
        return $this->Value;
    }
    /**
     * Set Value value
     * @param string $value
     * @return \Ups\upsshipStruct\UpsUnitType
     */
    public function setValue($value = null)
    {
        // validation for constraint: string
        if (!is_null($value) && !is_string($value)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($value, true), gettype($value)), __LINE__);
        }
        $this->Value = $value;
        return $this;
    }
}
