<?php

namespace Ups\upsshipStruct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UPSSecurity upsshipStruct
 * @package Ups
 * @subpackage Structs
 */
class UpsUPSSecurity extends AbstractStructBase
{
    /**
     * The UsernameToken
     * @var \Ups\upsshipStruct\UpsUsernameToken
     */
    public $UsernameToken;
    /**
     * The ServiceAccessToken
     * @var \Ups\upsshipStruct\UpsServiceAccessToken
     */
    public $ServiceAccessToken;
    /**
     * Constructor method for UPSSecurity
     * @uses UpsUPSSecurity::setUsernameToken()
     * @uses UpsUPSSecurity::setServiceAccessToken()
     * @param \Ups\upsshipStruct\UpsUsernameToken $usernameToken
     * @param \Ups\upsshipStruct\UpsServiceAccessToken $serviceAccessToken
     */
    public function __construct(\Ups\upsshipStruct\UpsUsernameToken $usernameToken = null, \Ups\upsshipStruct\UpsServiceAccessToken $serviceAccessToken = null)
    {
        $this
            ->setUsernameToken($usernameToken)
            ->setServiceAccessToken($serviceAccessToken);
    }
    /**
     * Get UsernameToken value
     * @return \Ups\upsshipStruct\UpsUsernameToken|null
     */
    public function getUsernameToken()
    {
        return $this->UsernameToken;
    }
    /**
     * Set UsernameToken value
     * @param \Ups\upsshipStruct\UpsUsernameToken $usernameToken
     * @return \Ups\upsshipStruct\UpsUPSSecurity
     */
    public function setUsernameToken(\Ups\upsshipStruct\UpsUsernameToken $usernameToken = null)
    {
        $this->UsernameToken = $usernameToken;
        return $this;
    }
    /**
     * Get ServiceAccessToken value
     * @return \Ups\upsshipStruct\UpsServiceAccessToken|null
     */
    public function getServiceAccessToken()
    {
        return $this->ServiceAccessToken;
    }
    /**
     * Set ServiceAccessToken value
     * @param \Ups\upsshipStruct\UpsServiceAccessToken $serviceAccessToken
     * @return \Ups\upsshipStruct\UpsUPSSecurity
     */
    public function setServiceAccessToken(\Ups\upsshipStruct\UpsServiceAccessToken $serviceAccessToken = null)
    {
        $this->ServiceAccessToken = $serviceAccessToken;
        return $this;
    }
}
