<?php

namespace Ups\upsshipStruct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ShipmentType upsshipStruct
 * @package Ups
 * @subpackage Structs
 */
class UpsShipmentType extends AbstractStructBase
{
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Description;
    /**
     * The ReturnService
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \Ups\upsshipStruct\UpsReturnServiceType
     */
    public $ReturnService;
    /**
     * The DocumentsOnlyIndicator
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $DocumentsOnlyIndicator;
    /**
     * The Shipper
     * @var \Ups\upsshipStruct\UpsShipperType
     */
    public $Shipper;
    /**
     * The ShipTo
     * @var \Ups\upsshipStruct\UpsShipToType
     */
    public $ShipTo;
    /**
     * The AlternateDeliveryAddress
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \Ups\upsshipStruct\UpsAlternateDeliveryAddressType
     */
    public $AlternateDeliveryAddress;
    /**
     * The ShipFrom
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \Ups\upsshipStruct\UpsShipFromType
     */
    public $ShipFrom;
    /**
     * The PaymentInformation
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \Ups\upsshipStruct\UpsPaymentInfoType
     */
    public $PaymentInformation;
    /**
     * The FRSPaymentInformation
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \Ups\upsshipStruct\UpsFRSPaymentInfoType
     */
    public $FRSPaymentInformation;
    /**
     * The FreightShipmentInformation
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \Ups\upsshipStruct\UpsFreightShipmentInformationType
     */
    public $FreightShipmentInformation;
    /**
     * The GoodsNotInFreeCirculationIndicator
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $GoodsNotInFreeCirculationIndicator;
    /**
     * The ShipmentRatingOptions
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \Ups\upsshipStruct\UpsRateInfoType
     */
    public $ShipmentRatingOptions;
    /**
     * The MovementReferenceNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $MovementReferenceNumber;
    /**
     * The ReferenceNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 2
     * - minOccurs: 0
     * @var \Ups\upsshipStruct\UpsReferenceNumberType[]
     */
    public $ReferenceNumber;
    /**
     * The Service
     * @var \Ups\upsshipStruct\UpsServiceType
     */
    public $Service;
    /**
     * The InvoiceLineTotal
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \Ups\upsshipStruct\UpsCurrencyMonetaryType
     */
    public $InvoiceLineTotal;
    /**
     * The NumOfPiecesInShipment
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $NumOfPiecesInShipment;
    /**
     * The USPSEndorsement
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $USPSEndorsement;
    /**
     * The MILabelCN22Indicator
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $MILabelCN22Indicator;
    /**
     * The SubClassification
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $SubClassification;
    /**
     * The CostCenter
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $CostCenter;
    /**
     * The CostCenterBarcodeIndicator
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $CostCenterBarcodeIndicator;
    /**
     * The PackageID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $PackageID;
    /**
     * The PackageIDBarcodeIndicator
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $PackageIDBarcodeIndicator;
    /**
     * The IrregularIndicator
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $IrregularIndicator;
    /**
     * The ShipmentIndicationType
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Ups\upsshipStruct\UpsIndicationType[]
     */
    public $ShipmentIndicationType;
    /**
     * The MIDualReturnShipmentKey
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $MIDualReturnShipmentKey;
    /**
     * The MIDualReturnShipmentIndicator
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $MIDualReturnShipmentIndicator;
    /**
     * The RatingMethodRequestedIndicator
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $RatingMethodRequestedIndicator;
    /**
     * The TaxInformationIndicator
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $TaxInformationIndicator;
    /**
     * The PromotionalDiscountInformation
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \Ups\upsshipStruct\UpsPromotionalDiscountInformationType
     */
    public $PromotionalDiscountInformation;
    /**
     * The DGSignatoryInfo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \Ups\upsshipStruct\UpsDGSignatoryInfoType
     */
    public $DGSignatoryInfo;
    /**
     * The MasterCartonID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $MasterCartonID;
    /**
     * The MasterCartonIndicator
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $MasterCartonIndicator;
    /**
     * The Locale
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Locale;
    /**
     * The ShipmentValueThresholdCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ShipmentValueThresholdCode;
    /**
     * The ShipmentServiceOptions
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \Ups\upsshipStruct\UpsShipmentServiceOptions
     */
    public $ShipmentServiceOptions;
    /**
     * The Package
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \Ups\upsshipStruct\UpsPackageType[]
     */
    public $Package;
    /**
     * Constructor method for ShipmentType
     * @uses UpsShipmentType::setDescription()
     * @uses UpsShipmentType::setReturnService()
     * @uses UpsShipmentType::setDocumentsOnlyIndicator()
     * @uses UpsShipmentType::setShipper()
     * @uses UpsShipmentType::setShipTo()
     * @uses UpsShipmentType::setAlternateDeliveryAddress()
     * @uses UpsShipmentType::setShipFrom()
     * @uses UpsShipmentType::setPaymentInformation()
     * @uses UpsShipmentType::setFRSPaymentInformation()
     * @uses UpsShipmentType::setFreightShipmentInformation()
     * @uses UpsShipmentType::setGoodsNotInFreeCirculationIndicator()
     * @uses UpsShipmentType::setShipmentRatingOptions()
     * @uses UpsShipmentType::setMovementReferenceNumber()
     * @uses UpsShipmentType::setReferenceNumber()
     * @uses UpsShipmentType::setService()
     * @uses UpsShipmentType::setInvoiceLineTotal()
     * @uses UpsShipmentType::setNumOfPiecesInShipment()
     * @uses UpsShipmentType::setUSPSEndorsement()
     * @uses UpsShipmentType::setMILabelCN22Indicator()
     * @uses UpsShipmentType::setSubClassification()
     * @uses UpsShipmentType::setCostCenter()
     * @uses UpsShipmentType::setCostCenterBarcodeIndicator()
     * @uses UpsShipmentType::setPackageID()
     * @uses UpsShipmentType::setPackageIDBarcodeIndicator()
     * @uses UpsShipmentType::setIrregularIndicator()
     * @uses UpsShipmentType::setShipmentIndicationType()
     * @uses UpsShipmentType::setMIDualReturnShipmentKey()
     * @uses UpsShipmentType::setMIDualReturnShipmentIndicator()
     * @uses UpsShipmentType::setRatingMethodRequestedIndicator()
     * @uses UpsShipmentType::setTaxInformationIndicator()
     * @uses UpsShipmentType::setPromotionalDiscountInformation()
     * @uses UpsShipmentType::setDGSignatoryInfo()
     * @uses UpsShipmentType::setMasterCartonID()
     * @uses UpsShipmentType::setMasterCartonIndicator()
     * @uses UpsShipmentType::setLocale()
     * @uses UpsShipmentType::setShipmentValueThresholdCode()
     * @uses UpsShipmentType::setShipmentServiceOptions()
     * @uses UpsShipmentType::setPackage()
     * @param string $description
     * @param \Ups\upsshipStruct\UpsReturnServiceType $returnService
     * @param string $documentsOnlyIndicator
     * @param \Ups\upsshipStruct\UpsShipperType $shipper
     * @param \Ups\upsshipStruct\UpsShipToType $shipTo
     * @param \Ups\upsshipStruct\UpsAlternateDeliveryAddressType $alternateDeliveryAddress
     * @param \Ups\upsshipStruct\UpsShipFromType $shipFrom
     * @param \Ups\upsshipStruct\UpsPaymentInfoType $paymentInformation
     * @param \Ups\upsshipStruct\UpsFRSPaymentInfoType $fRSPaymentInformation
     * @param \Ups\upsshipStruct\UpsFreightShipmentInformationType $freightShipmentInformation
     * @param string $goodsNotInFreeCirculationIndicator
     * @param \Ups\upsshipStruct\UpsRateInfoType $shipmentRatingOptions
     * @param string $movementReferenceNumber
     * @param \Ups\upsshipStruct\UpsReferenceNumberType[] $referenceNumber
     * @param \Ups\upsshipStruct\UpsServiceType $service
     * @param \Ups\upsshipStruct\UpsCurrencyMonetaryType $invoiceLineTotal
     * @param string $numOfPiecesInShipment
     * @param string $uSPSEndorsement
     * @param string $mILabelCN22Indicator
     * @param string $subClassification
     * @param string $costCenter
     * @param string $costCenterBarcodeIndicator
     * @param string $packageID
     * @param string $packageIDBarcodeIndicator
     * @param string $irregularIndicator
     * @param \Ups\upsshipStruct\UpsIndicationType[] $shipmentIndicationType
     * @param string $mIDualReturnShipmentKey
     * @param string $mIDualReturnShipmentIndicator
     * @param string $ratingMethodRequestedIndicator
     * @param string $taxInformationIndicator
     * @param \Ups\upsshipStruct\UpsPromotionalDiscountInformationType $promotionalDiscountInformation
     * @param \Ups\upsshipStruct\UpsDGSignatoryInfoType $dGSignatoryInfo
     * @param string $masterCartonID
     * @param string $masterCartonIndicator
     * @param string $locale
     * @param string $shipmentValueThresholdCode
     * @param \Ups\upsshipStruct\UpsShipmentServiceOptions $shipmentServiceOptions
     * @param \Ups\upsshipStruct\UpsPackageType[] $package
     */
    public function __construct($description = null, \Ups\upsshipStruct\UpsReturnServiceType $returnService = null, $documentsOnlyIndicator = null, \Ups\upsshipStruct\UpsShipperType $shipper = null, \Ups\upsshipStruct\UpsShipToType $shipTo = null, \Ups\upsshipStruct\UpsAlternateDeliveryAddressType $alternateDeliveryAddress = null, \Ups\upsshipStruct\UpsShipFromType $shipFrom = null, \Ups\upsshipStruct\UpsPaymentInfoType $paymentInformation = null, \Ups\upsshipStruct\UpsFRSPaymentInfoType $fRSPaymentInformation = null, \Ups\upsshipStruct\UpsFreightShipmentInformationType $freightShipmentInformation = null, $goodsNotInFreeCirculationIndicator = null, \Ups\upsshipStruct\UpsRateInfoType $shipmentRatingOptions = null, $movementReferenceNumber = null, array $referenceNumber = array(), \Ups\upsshipStruct\UpsServiceType $service = null, \Ups\upsshipStruct\UpsCurrencyMonetaryType $invoiceLineTotal = null, $numOfPiecesInShipment = null, $uSPSEndorsement = null, $mILabelCN22Indicator = null, $subClassification = null, $costCenter = null, $costCenterBarcodeIndicator = null, $packageID = null, $packageIDBarcodeIndicator = null, $irregularIndicator = null, array $shipmentIndicationType = array(), $mIDualReturnShipmentKey = null, $mIDualReturnShipmentIndicator = null, $ratingMethodRequestedIndicator = null, $taxInformationIndicator = null, \Ups\upsshipStruct\UpsPromotionalDiscountInformationType $promotionalDiscountInformation = null, \Ups\upsshipStruct\UpsDGSignatoryInfoType $dGSignatoryInfo = null, $masterCartonID = null, $masterCartonIndicator = null, $locale = null, $shipmentValueThresholdCode = null, \Ups\upsshipStruct\UpsShipmentServiceOptions $shipmentServiceOptions = null, array $package = array())
    {
        $this
            ->setDescription($description)
            ->setReturnService($returnService)
            ->setDocumentsOnlyIndicator($documentsOnlyIndicator)
            ->setShipper($shipper)
            ->setShipTo($shipTo)
            ->setAlternateDeliveryAddress($alternateDeliveryAddress)
            ->setShipFrom($shipFrom)
            ->setPaymentInformation($paymentInformation)
            ->setFRSPaymentInformation($fRSPaymentInformation)
            ->setFreightShipmentInformation($freightShipmentInformation)
            ->setGoodsNotInFreeCirculationIndicator($goodsNotInFreeCirculationIndicator)
            ->setShipmentRatingOptions($shipmentRatingOptions)
            ->setMovementReferenceNumber($movementReferenceNumber)
            ->setReferenceNumber($referenceNumber)
            ->setService($service)
            ->setInvoiceLineTotal($invoiceLineTotal)
            ->setNumOfPiecesInShipment($numOfPiecesInShipment)
            ->setUSPSEndorsement($uSPSEndorsement)
            ->setMILabelCN22Indicator($mILabelCN22Indicator)
            ->setSubClassification($subClassification)
            ->setCostCenter($costCenter)
            ->setCostCenterBarcodeIndicator($costCenterBarcodeIndicator)
            ->setPackageID($packageID)
            ->setPackageIDBarcodeIndicator($packageIDBarcodeIndicator)
            ->setIrregularIndicator($irregularIndicator)
            ->setShipmentIndicationType($shipmentIndicationType)
            ->setMIDualReturnShipmentKey($mIDualReturnShipmentKey)
            ->setMIDualReturnShipmentIndicator($mIDualReturnShipmentIndicator)
            ->setRatingMethodRequestedIndicator($ratingMethodRequestedIndicator)
            ->setTaxInformationIndicator($taxInformationIndicator)
            ->setPromotionalDiscountInformation($promotionalDiscountInformation)
            ->setDGSignatoryInfo($dGSignatoryInfo)
            ->setMasterCartonID($masterCartonID)
            ->setMasterCartonIndicator($masterCartonIndicator)
            ->setLocale($locale)
            ->setShipmentValueThresholdCode($shipmentValueThresholdCode)
            ->setShipmentServiceOptions($shipmentServiceOptions)
            ->setPackage($package);
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \Ups\upsshipStruct\UpsShipmentType
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Get ReturnService value
     * @return \Ups\upsshipStruct\UpsReturnServiceType|null
     */
    public function getReturnService()
    {
        return $this->ReturnService;
    }
    /**
     * Set ReturnService value
     * @param \Ups\upsshipStruct\UpsReturnServiceType $returnService
     * @return \Ups\upsshipStruct\UpsShipmentType
     */
    public function setReturnService(\Ups\upsshipStruct\UpsReturnServiceType $returnService = null)
    {
        $this->ReturnService = $returnService;
        return $this;
    }
    /**
     * Get DocumentsOnlyIndicator value
     * @return string|null
     */
    public function getDocumentsOnlyIndicator()
    {
        return $this->DocumentsOnlyIndicator;
    }
    /**
     * Set DocumentsOnlyIndicator value
     * @param string $documentsOnlyIndicator
     * @return \Ups\upsshipStruct\UpsShipmentType
     */
    public function setDocumentsOnlyIndicator($documentsOnlyIndicator = null)
    {
        // validation for constraint: string
        if (!is_null($documentsOnlyIndicator) && !is_string($documentsOnlyIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($documentsOnlyIndicator, true), gettype($documentsOnlyIndicator)), __LINE__);
        }
        $this->DocumentsOnlyIndicator = $documentsOnlyIndicator;
        return $this;
    }
    /**
     * Get Shipper value
     * @return \Ups\upsshipStruct\UpsShipperType|null
     */
    public function getShipper()
    {
        return $this->Shipper;
    }
    /**
     * Set Shipper value
     * @param \Ups\upsshipStruct\UpsShipperType $shipper
     * @return \Ups\upsshipStruct\UpsShipmentType
     */
    public function setShipper(\Ups\upsshipStruct\UpsShipperType $shipper = null)
    {
        $this->Shipper = $shipper;
        return $this;
    }
    /**
     * Get ShipTo value
     * @return \Ups\upsshipStruct\UpsShipToType|null
     */
    public function getShipTo()
    {
        return $this->ShipTo;
    }
    /**
     * Set ShipTo value
     * @param \Ups\upsshipStruct\UpsShipToType $shipTo
     * @return \Ups\upsshipStruct\UpsShipmentType
     */
    public function setShipTo(\Ups\upsshipStruct\UpsShipToType $shipTo = null)
    {
        $this->ShipTo = $shipTo;
        return $this;
    }
    /**
     * Get AlternateDeliveryAddress value
     * @return \Ups\upsshipStruct\UpsAlternateDeliveryAddressType|null
     */
    public function getAlternateDeliveryAddress()
    {
        return $this->AlternateDeliveryAddress;
    }
    /**
     * Set AlternateDeliveryAddress value
     * @param \Ups\upsshipStruct\UpsAlternateDeliveryAddressType $alternateDeliveryAddress
     * @return \Ups\upsshipStruct\UpsShipmentType
     */
    public function setAlternateDeliveryAddress(\Ups\upsshipStruct\UpsAlternateDeliveryAddressType $alternateDeliveryAddress = null)
    {
        $this->AlternateDeliveryAddress = $alternateDeliveryAddress;
        return $this;
    }
    /**
     * Get ShipFrom value
     * @return \Ups\upsshipStruct\UpsShipFromType|null
     */
    public function getShipFrom()
    {
        return $this->ShipFrom;
    }
    /**
     * Set ShipFrom value
     * @param \Ups\upsshipStruct\UpsShipFromType $shipFrom
     * @return \Ups\upsshipStruct\UpsShipmentType
     */
    public function setShipFrom(\Ups\upsshipStruct\UpsShipFromType $shipFrom = null)
    {
        $this->ShipFrom = $shipFrom;
        return $this;
    }
    /**
     * Get PaymentInformation value
     * @return \Ups\upsshipStruct\UpsPaymentInfoType|null
     */
    public function getPaymentInformation()
    {
        return $this->PaymentInformation;
    }
    /**
     * Set PaymentInformation value
     * @param \Ups\upsshipStruct\UpsPaymentInfoType $paymentInformation
     * @return \Ups\upsshipStruct\UpsShipmentType
     */
    public function setPaymentInformation(\Ups\upsshipStruct\UpsPaymentInfoType $paymentInformation = null)
    {
        $this->PaymentInformation = $paymentInformation;
        return $this;
    }
    /**
     * Get FRSPaymentInformation value
     * @return \Ups\upsshipStruct\UpsFRSPaymentInfoType|null
     */
    public function getFRSPaymentInformation()
    {
        return $this->FRSPaymentInformation;
    }
    /**
     * Set FRSPaymentInformation value
     * @param \Ups\upsshipStruct\UpsFRSPaymentInfoType $fRSPaymentInformation
     * @return \Ups\upsshipStruct\UpsShipmentType
     */
    public function setFRSPaymentInformation(\Ups\upsshipStruct\UpsFRSPaymentInfoType $fRSPaymentInformation = null)
    {
        $this->FRSPaymentInformation = $fRSPaymentInformation;
        return $this;
    }
    /**
     * Get FreightShipmentInformation value
     * @return \Ups\upsshipStruct\UpsFreightShipmentInformationType|null
     */
    public function getFreightShipmentInformation()
    {
        return $this->FreightShipmentInformation;
    }
    /**
     * Set FreightShipmentInformation value
     * @param \Ups\upsshipStruct\UpsFreightShipmentInformationType $freightShipmentInformation
     * @return \Ups\upsshipStruct\UpsShipmentType
     */
    public function setFreightShipmentInformation(\Ups\upsshipStruct\UpsFreightShipmentInformationType $freightShipmentInformation = null)
    {
        $this->FreightShipmentInformation = $freightShipmentInformation;
        return $this;
    }
    /**
     * Get GoodsNotInFreeCirculationIndicator value
     * @return string|null
     */
    public function getGoodsNotInFreeCirculationIndicator()
    {
        return $this->GoodsNotInFreeCirculationIndicator;
    }
    /**
     * Set GoodsNotInFreeCirculationIndicator value
     * @param string $goodsNotInFreeCirculationIndicator
     * @return \Ups\upsshipStruct\UpsShipmentType
     */
    public function setGoodsNotInFreeCirculationIndicator($goodsNotInFreeCirculationIndicator = null)
    {
        // validation for constraint: string
        if (!is_null($goodsNotInFreeCirculationIndicator) && !is_string($goodsNotInFreeCirculationIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($goodsNotInFreeCirculationIndicator, true), gettype($goodsNotInFreeCirculationIndicator)), __LINE__);
        }
        $this->GoodsNotInFreeCirculationIndicator = $goodsNotInFreeCirculationIndicator;
        return $this;
    }
    /**
     * Get ShipmentRatingOptions value
     * @return \Ups\upsshipStruct\UpsRateInfoType|null
     */
    public function getShipmentRatingOptions()
    {
        return $this->ShipmentRatingOptions;
    }
    /**
     * Set ShipmentRatingOptions value
     * @param \Ups\upsshipStruct\UpsRateInfoType $shipmentRatingOptions
     * @return \Ups\upsshipStruct\UpsShipmentType
     */
    public function setShipmentRatingOptions(\Ups\upsshipStruct\UpsRateInfoType $shipmentRatingOptions = null)
    {
        $this->ShipmentRatingOptions = $shipmentRatingOptions;
        return $this;
    }
    /**
     * Get MovementReferenceNumber value
     * @return string|null
     */
    public function getMovementReferenceNumber()
    {
        return $this->MovementReferenceNumber;
    }
    /**
     * Set MovementReferenceNumber value
     * @param string $movementReferenceNumber
     * @return \Ups\upsshipStruct\UpsShipmentType
     */
    public function setMovementReferenceNumber($movementReferenceNumber = null)
    {
        // validation for constraint: string
        if (!is_null($movementReferenceNumber) && !is_string($movementReferenceNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($movementReferenceNumber, true), gettype($movementReferenceNumber)), __LINE__);
        }
        $this->MovementReferenceNumber = $movementReferenceNumber;
        return $this;
    }
    /**
     * Get ReferenceNumber value
     * @return \Ups\upsshipStruct\UpsReferenceNumberType[]|null
     */
    public function getReferenceNumber()
    {
        return $this->ReferenceNumber;
    }
    /**
     * This method is responsible for validating the values passed to the setReferenceNumber method
     * This method is willingly generated in order to preserve the one-line inline validation within the setReferenceNumber method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateReferenceNumberForArrayConstraintsFromSetReferenceNumber(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $shipmentTypeReferenceNumberItem) {
            // validation for constraint: itemType
            if (!$shipmentTypeReferenceNumberItem instanceof \Ups\upsshipStruct\UpsReferenceNumberType) {
                $invalidValues[] = is_object($shipmentTypeReferenceNumberItem) ? get_class($shipmentTypeReferenceNumberItem) : sprintf('%s(%s)', gettype($shipmentTypeReferenceNumberItem), var_export($shipmentTypeReferenceNumberItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ReferenceNumber property can only contain items of type \Ups\upsshipStruct\UpsReferenceNumberType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ReferenceNumber value
     * @throws \InvalidArgumentException
     * @param \Ups\upsshipStruct\UpsReferenceNumberType[] $referenceNumber
     * @return \Ups\upsshipStruct\UpsShipmentType
     */
    public function setReferenceNumber(array $referenceNumber = array())
    {
        // validation for constraint: array
        if ('' !== ($referenceNumberArrayErrorMessage = self::validateReferenceNumberForArrayConstraintsFromSetReferenceNumber($referenceNumber))) {
            throw new \InvalidArgumentException($referenceNumberArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(2)
        if (is_array($referenceNumber) && count($referenceNumber) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 2', count($referenceNumber)), __LINE__);
        }
        $this->ReferenceNumber = $referenceNumber;
        return $this;
    }
    /**
     * Add item to ReferenceNumber value
     * @throws \InvalidArgumentException
     * @param \Ups\upsshipStruct\UpsReferenceNumberType $item
     * @return \Ups\upsshipStruct\UpsShipmentType
     */
    public function addToReferenceNumber(\Ups\upsshipStruct\UpsReferenceNumberType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Ups\upsshipStruct\UpsReferenceNumberType) {
            throw new \InvalidArgumentException(sprintf('The ReferenceNumber property can only contain items of type \Ups\upsshipStruct\UpsReferenceNumberType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(2)
        if (is_array($this->ReferenceNumber) && count($this->ReferenceNumber) >= 2) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 2', count($this->ReferenceNumber)), __LINE__);
        }
        $this->ReferenceNumber[] = $item;
        return $this;
    }
    /**
     * Get Service value
     * @return \Ups\upsshipStruct\UpsServiceType|null
     */
    public function getService()
    {
        return $this->Service;
    }
    /**
     * Set Service value
     * @param \Ups\upsshipStruct\UpsServiceType $service
     * @return \Ups\upsshipStruct\UpsShipmentType
     */
    public function setService(\Ups\upsshipStruct\UpsServiceType $service = null)
    {
        $this->Service = $service;
        return $this;
    }
    /**
     * Get InvoiceLineTotal value
     * @return \Ups\upsshipStruct\UpsCurrencyMonetaryType|null
     */
    public function getInvoiceLineTotal()
    {
        return $this->InvoiceLineTotal;
    }
    /**
     * Set InvoiceLineTotal value
     * @param \Ups\upsshipStruct\UpsCurrencyMonetaryType $invoiceLineTotal
     * @return \Ups\upsshipStruct\UpsShipmentType
     */
    public function setInvoiceLineTotal(\Ups\upsshipStruct\UpsCurrencyMonetaryType $invoiceLineTotal = null)
    {
        $this->InvoiceLineTotal = $invoiceLineTotal;
        return $this;
    }
    /**
     * Get NumOfPiecesInShipment value
     * @return string|null
     */
    public function getNumOfPiecesInShipment()
    {
        return $this->NumOfPiecesInShipment;
    }
    /**
     * Set NumOfPiecesInShipment value
     * @param string $numOfPiecesInShipment
     * @return \Ups\upsshipStruct\UpsShipmentType
     */
    public function setNumOfPiecesInShipment($numOfPiecesInShipment = null)
    {
        // validation for constraint: string
        if (!is_null($numOfPiecesInShipment) && !is_string($numOfPiecesInShipment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($numOfPiecesInShipment, true), gettype($numOfPiecesInShipment)), __LINE__);
        }
        $this->NumOfPiecesInShipment = $numOfPiecesInShipment;
        return $this;
    }
    /**
     * Get USPSEndorsement value
     * @return string|null
     */
    public function getUSPSEndorsement()
    {
        return $this->USPSEndorsement;
    }
    /**
     * Set USPSEndorsement value
     * @param string $uSPSEndorsement
     * @return \Ups\upsshipStruct\UpsShipmentType
     */
    public function setUSPSEndorsement($uSPSEndorsement = null)
    {
        // validation for constraint: string
        if (!is_null($uSPSEndorsement) && !is_string($uSPSEndorsement)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uSPSEndorsement, true), gettype($uSPSEndorsement)), __LINE__);
        }
        $this->USPSEndorsement = $uSPSEndorsement;
        return $this;
    }
    /**
     * Get MILabelCN22Indicator value
     * @return string|null
     */
    public function getMILabelCN22Indicator()
    {
        return $this->MILabelCN22Indicator;
    }
    /**
     * Set MILabelCN22Indicator value
     * @param string $mILabelCN22Indicator
     * @return \Ups\upsshipStruct\UpsShipmentType
     */
    public function setMILabelCN22Indicator($mILabelCN22Indicator = null)
    {
        // validation for constraint: string
        if (!is_null($mILabelCN22Indicator) && !is_string($mILabelCN22Indicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mILabelCN22Indicator, true), gettype($mILabelCN22Indicator)), __LINE__);
        }
        $this->MILabelCN22Indicator = $mILabelCN22Indicator;
        return $this;
    }
    /**
     * Get SubClassification value
     * @return string|null
     */
    public function getSubClassification()
    {
        return $this->SubClassification;
    }
    /**
     * Set SubClassification value
     * @param string $subClassification
     * @return \Ups\upsshipStruct\UpsShipmentType
     */
    public function setSubClassification($subClassification = null)
    {
        // validation for constraint: string
        if (!is_null($subClassification) && !is_string($subClassification)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($subClassification, true), gettype($subClassification)), __LINE__);
        }
        $this->SubClassification = $subClassification;
        return $this;
    }
    /**
     * Get CostCenter value
     * @return string|null
     */
    public function getCostCenter()
    {
        return $this->CostCenter;
    }
    /**
     * Set CostCenter value
     * @param string $costCenter
     * @return \Ups\upsshipStruct\UpsShipmentType
     */
    public function setCostCenter($costCenter = null)
    {
        // validation for constraint: string
        if (!is_null($costCenter) && !is_string($costCenter)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($costCenter, true), gettype($costCenter)), __LINE__);
        }
        $this->CostCenter = $costCenter;
        return $this;
    }
    /**
     * Get CostCenterBarcodeIndicator value
     * @return string|null
     */
    public function getCostCenterBarcodeIndicator()
    {
        return $this->CostCenterBarcodeIndicator;
    }
    /**
     * Set CostCenterBarcodeIndicator value
     * @param string $costCenterBarcodeIndicator
     * @return \Ups\upsshipStruct\UpsShipmentType
     */
    public function setCostCenterBarcodeIndicator($costCenterBarcodeIndicator = null)
    {
        // validation for constraint: string
        if (!is_null($costCenterBarcodeIndicator) && !is_string($costCenterBarcodeIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($costCenterBarcodeIndicator, true), gettype($costCenterBarcodeIndicator)), __LINE__);
        }
        $this->CostCenterBarcodeIndicator = $costCenterBarcodeIndicator;
        return $this;
    }
    /**
     * Get PackageID value
     * @return string|null
     */
    public function getPackageID()
    {
        return $this->PackageID;
    }
    /**
     * Set PackageID value
     * @param string $packageID
     * @return \Ups\upsshipStruct\UpsShipmentType
     */
    public function setPackageID($packageID = null)
    {
        // validation for constraint: string
        if (!is_null($packageID) && !is_string($packageID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($packageID, true), gettype($packageID)), __LINE__);
        }
        $this->PackageID = $packageID;
        return $this;
    }
    /**
     * Get PackageIDBarcodeIndicator value
     * @return string|null
     */
    public function getPackageIDBarcodeIndicator()
    {
        return $this->PackageIDBarcodeIndicator;
    }
    /**
     * Set PackageIDBarcodeIndicator value
     * @param string $packageIDBarcodeIndicator
     * @return \Ups\upsshipStruct\UpsShipmentType
     */
    public function setPackageIDBarcodeIndicator($packageIDBarcodeIndicator = null)
    {
        // validation for constraint: string
        if (!is_null($packageIDBarcodeIndicator) && !is_string($packageIDBarcodeIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($packageIDBarcodeIndicator, true), gettype($packageIDBarcodeIndicator)), __LINE__);
        }
        $this->PackageIDBarcodeIndicator = $packageIDBarcodeIndicator;
        return $this;
    }
    /**
     * Get IrregularIndicator value
     * @return string|null
     */
    public function getIrregularIndicator()
    {
        return $this->IrregularIndicator;
    }
    /**
     * Set IrregularIndicator value
     * @param string $irregularIndicator
     * @return \Ups\upsshipStruct\UpsShipmentType
     */
    public function setIrregularIndicator($irregularIndicator = null)
    {
        // validation for constraint: string
        if (!is_null($irregularIndicator) && !is_string($irregularIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($irregularIndicator, true), gettype($irregularIndicator)), __LINE__);
        }
        $this->IrregularIndicator = $irregularIndicator;
        return $this;
    }
    /**
     * Get ShipmentIndicationType value
     * @return \Ups\upsshipStruct\UpsIndicationType[]|null
     */
    public function getShipmentIndicationType()
    {
        return $this->ShipmentIndicationType;
    }
    /**
     * This method is responsible for validating the values passed to the setShipmentIndicationType method
     * This method is willingly generated in order to preserve the one-line inline validation within the setShipmentIndicationType method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateShipmentIndicationTypeForArrayConstraintsFromSetShipmentIndicationType(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $shipmentTypeShipmentIndicationTypeItem) {
            // validation for constraint: itemType
            if (!$shipmentTypeShipmentIndicationTypeItem instanceof \Ups\upsshipStruct\UpsIndicationType) {
                $invalidValues[] = is_object($shipmentTypeShipmentIndicationTypeItem) ? get_class($shipmentTypeShipmentIndicationTypeItem) : sprintf('%s(%s)', gettype($shipmentTypeShipmentIndicationTypeItem), var_export($shipmentTypeShipmentIndicationTypeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ShipmentIndicationType property can only contain items of type \Ups\upsshipStruct\UpsIndicationType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ShipmentIndicationType value
     * @throws \InvalidArgumentException
     * @param \Ups\upsshipStruct\UpsIndicationType[] $shipmentIndicationType
     * @return \Ups\upsshipStruct\UpsShipmentType
     */
    public function setShipmentIndicationType(array $shipmentIndicationType = array())
    {
        // validation for constraint: array
        if ('' !== ($shipmentIndicationTypeArrayErrorMessage = self::validateShipmentIndicationTypeForArrayConstraintsFromSetShipmentIndicationType($shipmentIndicationType))) {
            throw new \InvalidArgumentException($shipmentIndicationTypeArrayErrorMessage, __LINE__);
        }
        $this->ShipmentIndicationType = $shipmentIndicationType;
        return $this;
    }
    /**
     * Add item to ShipmentIndicationType value
     * @throws \InvalidArgumentException
     * @param \Ups\upsshipStruct\UpsIndicationType $item
     * @return \Ups\upsshipStruct\UpsShipmentType
     */
    public function addToShipmentIndicationType(\Ups\upsshipStruct\UpsIndicationType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Ups\upsshipStruct\UpsIndicationType) {
            throw new \InvalidArgumentException(sprintf('The ShipmentIndicationType property can only contain items of type \Ups\upsshipStruct\UpsIndicationType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ShipmentIndicationType[] = $item;
        return $this;
    }
    /**
     * Get MIDualReturnShipmentKey value
     * @return string|null
     */
    public function getMIDualReturnShipmentKey()
    {
        return $this->MIDualReturnShipmentKey;
    }
    /**
     * Set MIDualReturnShipmentKey value
     * @param string $mIDualReturnShipmentKey
     * @return \Ups\upsshipStruct\UpsShipmentType
     */
    public function setMIDualReturnShipmentKey($mIDualReturnShipmentKey = null)
    {
        // validation for constraint: string
        if (!is_null($mIDualReturnShipmentKey) && !is_string($mIDualReturnShipmentKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mIDualReturnShipmentKey, true), gettype($mIDualReturnShipmentKey)), __LINE__);
        }
        $this->MIDualReturnShipmentKey = $mIDualReturnShipmentKey;
        return $this;
    }
    /**
     * Get MIDualReturnShipmentIndicator value
     * @return string|null
     */
    public function getMIDualReturnShipmentIndicator()
    {
        return $this->MIDualReturnShipmentIndicator;
    }
    /**
     * Set MIDualReturnShipmentIndicator value
     * @param string $mIDualReturnShipmentIndicator
     * @return \Ups\upsshipStruct\UpsShipmentType
     */
    public function setMIDualReturnShipmentIndicator($mIDualReturnShipmentIndicator = null)
    {
        // validation for constraint: string
        if (!is_null($mIDualReturnShipmentIndicator) && !is_string($mIDualReturnShipmentIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mIDualReturnShipmentIndicator, true), gettype($mIDualReturnShipmentIndicator)), __LINE__);
        }
        $this->MIDualReturnShipmentIndicator = $mIDualReturnShipmentIndicator;
        return $this;
    }
    /**
     * Get RatingMethodRequestedIndicator value
     * @return string|null
     */
    public function getRatingMethodRequestedIndicator()
    {
        return $this->RatingMethodRequestedIndicator;
    }
    /**
     * Set RatingMethodRequestedIndicator value
     * @param string $ratingMethodRequestedIndicator
     * @return \Ups\upsshipStruct\UpsShipmentType
     */
    public function setRatingMethodRequestedIndicator($ratingMethodRequestedIndicator = null)
    {
        // validation for constraint: string
        if (!is_null($ratingMethodRequestedIndicator) && !is_string($ratingMethodRequestedIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ratingMethodRequestedIndicator, true), gettype($ratingMethodRequestedIndicator)), __LINE__);
        }
        $this->RatingMethodRequestedIndicator = $ratingMethodRequestedIndicator;
        return $this;
    }
    /**
     * Get TaxInformationIndicator value
     * @return string|null
     */
    public function getTaxInformationIndicator()
    {
        return $this->TaxInformationIndicator;
    }
    /**
     * Set TaxInformationIndicator value
     * @param string $taxInformationIndicator
     * @return \Ups\upsshipStruct\UpsShipmentType
     */
    public function setTaxInformationIndicator($taxInformationIndicator = null)
    {
        // validation for constraint: string
        if (!is_null($taxInformationIndicator) && !is_string($taxInformationIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($taxInformationIndicator, true), gettype($taxInformationIndicator)), __LINE__);
        }
        $this->TaxInformationIndicator = $taxInformationIndicator;
        return $this;
    }
    /**
     * Get PromotionalDiscountInformation value
     * @return \Ups\upsshipStruct\UpsPromotionalDiscountInformationType|null
     */
    public function getPromotionalDiscountInformation()
    {
        return $this->PromotionalDiscountInformation;
    }
    /**
     * Set PromotionalDiscountInformation value
     * @param \Ups\upsshipStruct\UpsPromotionalDiscountInformationType $promotionalDiscountInformation
     * @return \Ups\upsshipStruct\UpsShipmentType
     */
    public function setPromotionalDiscountInformation(\Ups\upsshipStruct\UpsPromotionalDiscountInformationType $promotionalDiscountInformation = null)
    {
        $this->PromotionalDiscountInformation = $promotionalDiscountInformation;
        return $this;
    }
    /**
     * Get DGSignatoryInfo value
     * @return \Ups\upsshipStruct\UpsDGSignatoryInfoType|null
     */
    public function getDGSignatoryInfo()
    {
        return $this->DGSignatoryInfo;
    }
    /**
     * Set DGSignatoryInfo value
     * @param \Ups\upsshipStruct\UpsDGSignatoryInfoType $dGSignatoryInfo
     * @return \Ups\upsshipStruct\UpsShipmentType
     */
    public function setDGSignatoryInfo(\Ups\upsshipStruct\UpsDGSignatoryInfoType $dGSignatoryInfo = null)
    {
        $this->DGSignatoryInfo = $dGSignatoryInfo;
        return $this;
    }
    /**
     * Get MasterCartonID value
     * @return string|null
     */
    public function getMasterCartonID()
    {
        return $this->MasterCartonID;
    }
    /**
     * Set MasterCartonID value
     * @param string $masterCartonID
     * @return \Ups\upsshipStruct\UpsShipmentType
     */
    public function setMasterCartonID($masterCartonID = null)
    {
        // validation for constraint: string
        if (!is_null($masterCartonID) && !is_string($masterCartonID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($masterCartonID, true), gettype($masterCartonID)), __LINE__);
        }
        $this->MasterCartonID = $masterCartonID;
        return $this;
    }
    /**
     * Get MasterCartonIndicator value
     * @return string|null
     */
    public function getMasterCartonIndicator()
    {
        return $this->MasterCartonIndicator;
    }
    /**
     * Set MasterCartonIndicator value
     * @param string $masterCartonIndicator
     * @return \Ups\upsshipStruct\UpsShipmentType
     */
    public function setMasterCartonIndicator($masterCartonIndicator = null)
    {
        // validation for constraint: string
        if (!is_null($masterCartonIndicator) && !is_string($masterCartonIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($masterCartonIndicator, true), gettype($masterCartonIndicator)), __LINE__);
        }
        $this->MasterCartonIndicator = $masterCartonIndicator;
        return $this;
    }
    /**
     * Get Locale value
     * @return string|null
     */
    public function getLocale()
    {
        return $this->Locale;
    }
    /**
     * Set Locale value
     * @param string $locale
     * @return \Ups\upsshipStruct\UpsShipmentType
     */
    public function setLocale($locale = null)
    {
        // validation for constraint: string
        if (!is_null($locale) && !is_string($locale)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($locale, true), gettype($locale)), __LINE__);
        }
        $this->Locale = $locale;
        return $this;
    }
    /**
     * Get ShipmentValueThresholdCode value
     * @return string|null
     */
    public function getShipmentValueThresholdCode()
    {
        return $this->ShipmentValueThresholdCode;
    }
    /**
     * Set ShipmentValueThresholdCode value
     * @param string $shipmentValueThresholdCode
     * @return \Ups\upsshipStruct\UpsShipmentType
     */
    public function setShipmentValueThresholdCode($shipmentValueThresholdCode = null)
    {
        // validation for constraint: string
        if (!is_null($shipmentValueThresholdCode) && !is_string($shipmentValueThresholdCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shipmentValueThresholdCode, true), gettype($shipmentValueThresholdCode)), __LINE__);
        }
        $this->ShipmentValueThresholdCode = $shipmentValueThresholdCode;
        return $this;
    }
    /**
     * Get ShipmentServiceOptions value
     * @return \Ups\upsshipStruct\UpsShipmentServiceOptions|null
     */
    public function getShipmentServiceOptions()
    {
        return $this->ShipmentServiceOptions;
    }
    /**
     * Set ShipmentServiceOptions value
     * @param \Ups\upsshipStruct\UpsShipmentServiceOptions $shipmentServiceOptions
     * @return \Ups\upsshipStruct\UpsShipmentType
     */
    public function setShipmentServiceOptions(\Ups\upsshipStruct\UpsShipmentServiceOptions $shipmentServiceOptions = null)
    {
        $this->ShipmentServiceOptions = $shipmentServiceOptions;
        return $this;
    }
    /**
     * Get Package value
     * @return \Ups\upsshipStruct\UpsPackageType[]|null
     */
    public function getPackage()
    {
        return $this->Package;
    }
    /**
     * This method is responsible for validating the values passed to the setPackage method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPackage method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePackageForArrayConstraintsFromSetPackage(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $shipmentTypePackageItem) {
            // validation for constraint: itemType
            if (!$shipmentTypePackageItem instanceof \Ups\upsshipStruct\UpsPackageType) {
                $invalidValues[] = is_object($shipmentTypePackageItem) ? get_class($shipmentTypePackageItem) : sprintf('%s(%s)', gettype($shipmentTypePackageItem), var_export($shipmentTypePackageItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Package property can only contain items of type \Ups\upsshipStruct\UpsPackageType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Package value
     * @throws \InvalidArgumentException
     * @param \Ups\upsshipStruct\UpsPackageType[] $package
     * @return \Ups\upsshipStruct\UpsShipmentType
     */
    public function setPackage(array $package = array())
    {
        // validation for constraint: array
        if ('' !== ($packageArrayErrorMessage = self::validatePackageForArrayConstraintsFromSetPackage($package))) {
            throw new \InvalidArgumentException($packageArrayErrorMessage, __LINE__);
        }
        $this->Package = $package;
        return $this;
    }
    /**
     * Add item to Package value
     * @throws \InvalidArgumentException
     * @param \Ups\upsshipStruct\UpsPackageType $item
     * @return \Ups\upsshipStruct\UpsShipmentType
     */
    public function addToPackage(\Ups\upsshipStruct\UpsPackageType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Ups\upsshipStruct\UpsPackageType) {
            throw new \InvalidArgumentException(sprintf('The Package property can only contain items of type \Ups\upsshipStruct\UpsPackageType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Package[] = $item;
        return $this;
    }
}
