<?php

namespace Ups\upsshipStruct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ShipToType upsshipStruct
 * @package Ups
 * @subpackage Structs
 */
class UpsShipToType extends UpsCompanyInfoType
{
    /**
     * The FaxNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $FaxNumber;
    /**
     * The EMailAddress
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $EMailAddress;
    /**
     * The Address
     * @var \Ups\upsshipStruct\UpsShipToAddressType
     */
    public $Address;
    /**
     * The LocationID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $LocationID;
    /**
     * Constructor method for ShipToType
     * @uses UpsShipToType::setFaxNumber()
     * @uses UpsShipToType::setEMailAddress()
     * @uses UpsShipToType::setAddress()
     * @uses UpsShipToType::setLocationID()
     * @param string $faxNumber
     * @param string $eMailAddress
     * @param \Ups\upsshipStruct\UpsShipToAddressType $address
     * @param string $locationID
     */
    public function __construct($faxNumber = null, $eMailAddress = null, \Ups\upsshipStruct\UpsShipToAddressType $address = null, $locationID = null)
    {
        $this
            ->setFaxNumber($faxNumber)
            ->setEMailAddress($eMailAddress)
            ->setAddress($address)
            ->setLocationID($locationID);
    }
    /**
     * Get FaxNumber value
     * @return string|null
     */
    public function getFaxNumber()
    {
        return $this->FaxNumber;
    }
    /**
     * Set FaxNumber value
     * @param string $faxNumber
     * @return \Ups\upsshipStruct\UpsShipToType
     */
    public function setFaxNumber($faxNumber = null)
    {
        // validation for constraint: string
        if (!is_null($faxNumber) && !is_string($faxNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($faxNumber, true), gettype($faxNumber)), __LINE__);
        }
        $this->FaxNumber = $faxNumber;
        return $this;
    }
    /**
     * Get EMailAddress value
     * @return string|null
     */
    public function getEMailAddress()
    {
        return $this->EMailAddress;
    }
    /**
     * Set EMailAddress value
     * @param string $eMailAddress
     * @return \Ups\upsshipStruct\UpsShipToType
     */
    public function setEMailAddress($eMailAddress = null)
    {
        // validation for constraint: string
        if (!is_null($eMailAddress) && !is_string($eMailAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eMailAddress, true), gettype($eMailAddress)), __LINE__);
        }
        $this->EMailAddress = $eMailAddress;
        return $this;
    }
    /**
     * Get Address value
     * @return \Ups\upsshipStruct\UpsShipToAddressType|null
     */
    public function getAddress()
    {
        return $this->Address;
    }
    /**
     * Set Address value
     * @param \Ups\upsshipStruct\UpsShipToAddressType $address
     * @return \Ups\upsshipStruct\UpsShipToType
     */
    public function setAddress(\Ups\upsshipStruct\UpsShipToAddressType $address = null)
    {
        $this->Address = $address;
        return $this;
    }
    /**
     * Get LocationID value
     * @return string|null
     */
    public function getLocationID()
    {
        return $this->LocationID;
    }
    /**
     * Set LocationID value
     * @param string $locationID
     * @return \Ups\upsshipStruct\UpsShipToType
     */
    public function setLocationID($locationID = null)
    {
        // validation for constraint: string
        if (!is_null($locationID) && !is_string($locationID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($locationID, true), gettype($locationID)), __LINE__);
        }
        $this->LocationID = $locationID;
        return $this;
    }
}
