<?php

namespace Ups\upsshipStruct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PackageAssociatedType upsshipStruct
 * @package Ups
 * @subpackage Structs
 */
class UpsPackageAssociatedType extends AbstractStructBase
{
    /**
     * The PackageNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $PackageNumber;
    /**
     * The ProductAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ProductAmount;
    /**
     * Constructor method for PackageAssociatedType
     * @uses UpsPackageAssociatedType::setPackageNumber()
     * @uses UpsPackageAssociatedType::setProductAmount()
     * @param string $packageNumber
     * @param string $productAmount
     */
    public function __construct($packageNumber = null, $productAmount = null)
    {
        $this
            ->setPackageNumber($packageNumber)
            ->setProductAmount($productAmount);
    }
    /**
     * Get PackageNumber value
     * @return string|null
     */
    public function getPackageNumber()
    {
        return $this->PackageNumber;
    }
    /**
     * Set PackageNumber value
     * @param string $packageNumber
     * @return \Ups\upsshipStruct\UpsPackageAssociatedType
     */
    public function setPackageNumber($packageNumber = null)
    {
        // validation for constraint: string
        if (!is_null($packageNumber) && !is_string($packageNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($packageNumber, true), gettype($packageNumber)), __LINE__);
        }
        $this->PackageNumber = $packageNumber;
        return $this;
    }
    /**
     * Get ProductAmount value
     * @return string|null
     */
    public function getProductAmount()
    {
        return $this->ProductAmount;
    }
    /**
     * Set ProductAmount value
     * @param string $productAmount
     * @return \Ups\upsshipStruct\UpsPackageAssociatedType
     */
    public function setProductAmount($productAmount = null)
    {
        // validation for constraint: string
        if (!is_null($productAmount) && !is_string($productAmount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($productAmount, true), gettype($productAmount)), __LINE__);
        }
        $this->ProductAmount = $productAmount;
        return $this;
    }
}
