<?php

namespace Ups\upsshipStruct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LicenseType upsshipStruct
 * @package Ups
 * @subpackage Structs
 */
class UpsLicenseType extends AbstractStructBase
{
    /**
     * The Number
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Number;
    /**
     * The Date
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Date;
    /**
     * The ExceptionCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ExceptionCode;
    /**
     * Constructor method for LicenseType
     * @uses UpsLicenseType::setNumber()
     * @uses UpsLicenseType::setDate()
     * @uses UpsLicenseType::setExceptionCode()
     * @param string $number
     * @param string $date
     * @param string $exceptionCode
     */
    public function __construct($number = null, $date = null, $exceptionCode = null)
    {
        $this
            ->setNumber($number)
            ->setDate($date)
            ->setExceptionCode($exceptionCode);
    }
    /**
     * Get Number value
     * @return string|null
     */
    public function getNumber()
    {
        return $this->Number;
    }
    /**
     * Set Number value
     * @param string $number
     * @return \Ups\upsshipStruct\UpsLicenseType
     */
    public function setNumber($number = null)
    {
        // validation for constraint: string
        if (!is_null($number) && !is_string($number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($number, true), gettype($number)), __LINE__);
        }
        $this->Number = $number;
        return $this;
    }
    /**
     * Get Date value
     * @return string|null
     */
    public function getDate()
    {
        return $this->Date;
    }
    /**
     * Set Date value
     * @param string $date
     * @return \Ups\upsshipStruct\UpsLicenseType
     */
    public function setDate($date = null)
    {
        // validation for constraint: string
        if (!is_null($date) && !is_string($date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($date, true), gettype($date)), __LINE__);
        }
        $this->Date = $date;
        return $this;
    }
    /**
     * Get ExceptionCode value
     * @return string|null
     */
    public function getExceptionCode()
    {
        return $this->ExceptionCode;
    }
    /**
     * Set ExceptionCode value
     * @param string $exceptionCode
     * @return \Ups\upsshipStruct\UpsLicenseType
     */
    public function setExceptionCode($exceptionCode = null)
    {
        // validation for constraint: string
        if (!is_null($exceptionCode) && !is_string($exceptionCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($exceptionCode, true), gettype($exceptionCode)), __LINE__);
        }
        $this->ExceptionCode = $exceptionCode;
        return $this;
    }
}
