<?php

namespace Ups\upsshipStruct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ErrorDetailType upsshipStruct
 * @package Ups
 * @subpackage Structs
 */
class UpsErrorDetailType extends AbstractStructBase
{
    /**
     * The Severity
     * @var string
     */
    public $Severity;
    /**
     * The PrimaryErrorCode
     * @var \Ups\upsshipStruct\UpsCodeType
     */
    public $PrimaryErrorCode;
    /**
     * The MinimumRetrySeconds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $MinimumRetrySeconds;
    /**
     * The Location
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \Ups\upsshipStruct\UpsLocationType
     */
    public $Location;
    /**
     * The SubErrorCode
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Ups\upsshipStruct\UpsCodeType[]
     */
    public $SubErrorCode;
    /**
     * The AdditionalInformation
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Ups\upsshipStruct\UpsAdditionalInfoType[]
     */
    public $AdditionalInformation;
    /**
     * The ElementLevelInformation
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \Ups\upsshipStruct\UpsElementLevelInformationType
     */
    public $ElementLevelInformation;
    /**
     * Constructor method for ErrorDetailType
     * @uses UpsErrorDetailType::setSeverity()
     * @uses UpsErrorDetailType::setPrimaryErrorCode()
     * @uses UpsErrorDetailType::setMinimumRetrySeconds()
     * @uses UpsErrorDetailType::setLocation()
     * @uses UpsErrorDetailType::setSubErrorCode()
     * @uses UpsErrorDetailType::setAdditionalInformation()
     * @uses UpsErrorDetailType::setElementLevelInformation()
     * @param string $severity
     * @param \Ups\upsshipStruct\UpsCodeType $primaryErrorCode
     * @param string $minimumRetrySeconds
     * @param \Ups\upsshipStruct\UpsLocationType $location
     * @param \Ups\upsshipStruct\UpsCodeType[] $subErrorCode
     * @param \Ups\upsshipStruct\UpsAdditionalInfoType[] $additionalInformation
     * @param \Ups\upsshipStruct\UpsElementLevelInformationType $elementLevelInformation
     */
    public function __construct($severity = null, \Ups\upsshipStruct\UpsCodeType $primaryErrorCode = null, $minimumRetrySeconds = null, \Ups\upsshipStruct\UpsLocationType $location = null, array $subErrorCode = array(), array $additionalInformation = array(), \Ups\upsshipStruct\UpsElementLevelInformationType $elementLevelInformation = null)
    {
        $this
            ->setSeverity($severity)
            ->setPrimaryErrorCode($primaryErrorCode)
            ->setMinimumRetrySeconds($minimumRetrySeconds)
            ->setLocation($location)
            ->setSubErrorCode($subErrorCode)
            ->setAdditionalInformation($additionalInformation)
            ->setElementLevelInformation($elementLevelInformation);
    }
    /**
     * Get Severity value
     * @return string|null
     */
    public function getSeverity()
    {
        return $this->Severity;
    }
    /**
     * Set Severity value
     * @param string $severity
     * @return \Ups\upsshipStruct\UpsErrorDetailType
     */
    public function setSeverity($severity = null)
    {
        // validation for constraint: string
        if (!is_null($severity) && !is_string($severity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($severity, true), gettype($severity)), __LINE__);
        }
        $this->Severity = $severity;
        return $this;
    }
    /**
     * Get PrimaryErrorCode value
     * @return \Ups\upsshipStruct\UpsCodeType|null
     */
    public function getPrimaryErrorCode()
    {
        return $this->PrimaryErrorCode;
    }
    /**
     * Set PrimaryErrorCode value
     * @param \Ups\upsshipStruct\UpsCodeType $primaryErrorCode
     * @return \Ups\upsshipStruct\UpsErrorDetailType
     */
    public function setPrimaryErrorCode(\Ups\upsshipStruct\UpsCodeType $primaryErrorCode = null)
    {
        $this->PrimaryErrorCode = $primaryErrorCode;
        return $this;
    }
    /**
     * Get MinimumRetrySeconds value
     * @return string|null
     */
    public function getMinimumRetrySeconds()
    {
        return $this->MinimumRetrySeconds;
    }
    /**
     * Set MinimumRetrySeconds value
     * @param string $minimumRetrySeconds
     * @return \Ups\upsshipStruct\UpsErrorDetailType
     */
    public function setMinimumRetrySeconds($minimumRetrySeconds = null)
    {
        // validation for constraint: string
        if (!is_null($minimumRetrySeconds) && !is_string($minimumRetrySeconds)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($minimumRetrySeconds, true), gettype($minimumRetrySeconds)), __LINE__);
        }
        $this->MinimumRetrySeconds = $minimumRetrySeconds;
        return $this;
    }
    /**
     * Get Location value
     * @return \Ups\upsshipStruct\UpsLocationType|null
     */
    public function getLocation()
    {
        return $this->Location;
    }
    /**
     * Set Location value
     * @param \Ups\upsshipStruct\UpsLocationType $location
     * @return \Ups\upsshipStruct\UpsErrorDetailType
     */
    public function setLocation(\Ups\upsshipStruct\UpsLocationType $location = null)
    {
        $this->Location = $location;
        return $this;
    }
    /**
     * Get SubErrorCode value
     * @return \Ups\upsshipStruct\UpsCodeType[]|null
     */
    public function getSubErrorCode()
    {
        return $this->SubErrorCode;
    }
    /**
     * This method is responsible for validating the values passed to the setSubErrorCode method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSubErrorCode method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSubErrorCodeForArrayConstraintsFromSetSubErrorCode(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $errorDetailTypeSubErrorCodeItem) {
            // validation for constraint: itemType
            if (!$errorDetailTypeSubErrorCodeItem instanceof \Ups\upsshipStruct\UpsCodeType) {
                $invalidValues[] = is_object($errorDetailTypeSubErrorCodeItem) ? get_class($errorDetailTypeSubErrorCodeItem) : sprintf('%s(%s)', gettype($errorDetailTypeSubErrorCodeItem), var_export($errorDetailTypeSubErrorCodeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The SubErrorCode property can only contain items of type \Ups\upsshipStruct\UpsCodeType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set SubErrorCode value
     * @throws \InvalidArgumentException
     * @param \Ups\upsshipStruct\UpsCodeType[] $subErrorCode
     * @return \Ups\upsshipStruct\UpsErrorDetailType
     */
    public function setSubErrorCode(array $subErrorCode = array())
    {
        // validation for constraint: array
        if ('' !== ($subErrorCodeArrayErrorMessage = self::validateSubErrorCodeForArrayConstraintsFromSetSubErrorCode($subErrorCode))) {
            throw new \InvalidArgumentException($subErrorCodeArrayErrorMessage, __LINE__);
        }
        $this->SubErrorCode = $subErrorCode;
        return $this;
    }
    /**
     * Add item to SubErrorCode value
     * @throws \InvalidArgumentException
     * @param \Ups\upsshipStruct\UpsCodeType $item
     * @return \Ups\upsshipStruct\UpsErrorDetailType
     */
    public function addToSubErrorCode(\Ups\upsshipStruct\UpsCodeType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Ups\upsshipStruct\UpsCodeType) {
            throw new \InvalidArgumentException(sprintf('The SubErrorCode property can only contain items of type \Ups\upsshipStruct\UpsCodeType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->SubErrorCode[] = $item;
        return $this;
    }
    /**
     * Get AdditionalInformation value
     * @return \Ups\upsshipStruct\UpsAdditionalInfoType[]|null
     */
    public function getAdditionalInformation()
    {
        return $this->AdditionalInformation;
    }
    /**
     * This method is responsible for validating the values passed to the setAdditionalInformation method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAdditionalInformation method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAdditionalInformationForArrayConstraintsFromSetAdditionalInformation(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $errorDetailTypeAdditionalInformationItem) {
            // validation for constraint: itemType
            if (!$errorDetailTypeAdditionalInformationItem instanceof \Ups\upsshipStruct\UpsAdditionalInfoType) {
                $invalidValues[] = is_object($errorDetailTypeAdditionalInformationItem) ? get_class($errorDetailTypeAdditionalInformationItem) : sprintf('%s(%s)', gettype($errorDetailTypeAdditionalInformationItem), var_export($errorDetailTypeAdditionalInformationItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The AdditionalInformation property can only contain items of type \Ups\upsshipStruct\UpsAdditionalInfoType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set AdditionalInformation value
     * @throws \InvalidArgumentException
     * @param \Ups\upsshipStruct\UpsAdditionalInfoType[] $additionalInformation
     * @return \Ups\upsshipStruct\UpsErrorDetailType
     */
    public function setAdditionalInformation(array $additionalInformation = array())
    {
        // validation for constraint: array
        if ('' !== ($additionalInformationArrayErrorMessage = self::validateAdditionalInformationForArrayConstraintsFromSetAdditionalInformation($additionalInformation))) {
            throw new \InvalidArgumentException($additionalInformationArrayErrorMessage, __LINE__);
        }
        $this->AdditionalInformation = $additionalInformation;
        return $this;
    }
    /**
     * Add item to AdditionalInformation value
     * @throws \InvalidArgumentException
     * @param \Ups\upsshipStruct\UpsAdditionalInfoType $item
     * @return \Ups\upsshipStruct\UpsErrorDetailType
     */
    public function addToAdditionalInformation(\Ups\upsshipStruct\UpsAdditionalInfoType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Ups\upsshipStruct\UpsAdditionalInfoType) {
            throw new \InvalidArgumentException(sprintf('The AdditionalInformation property can only contain items of type \Ups\upsshipStruct\UpsAdditionalInfoType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->AdditionalInformation[] = $item;
        return $this;
    }
    /**
     * Get ElementLevelInformation value
     * @return \Ups\upsshipStruct\UpsElementLevelInformationType|null
     */
    public function getElementLevelInformation()
    {
        return $this->ElementLevelInformation;
    }
    /**
     * Set ElementLevelInformation value
     * @param \Ups\upsshipStruct\UpsElementLevelInformationType $elementLevelInformation
     * @return \Ups\upsshipStruct\UpsErrorDetailType
     */
    public function setElementLevelInformation(\Ups\upsshipStruct\UpsElementLevelInformationType $elementLevelInformation = null)
    {
        $this->ElementLevelInformation = $elementLevelInformation;
        return $this;
    }
}
