<?php

namespace Ups\upsshipStruct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DimensionsType upsshipStruct
 * @package Ups
 * @subpackage Structs
 */
class UpsDimensionsType extends AbstractStructBase
{
    /**
     * The UnitOfMeasurement
     * @var \Ups\upsshipStruct\UpsShipUnitOfMeasurementType
     */
    public $UnitOfMeasurement;
    /**
     * The Length
     * @var string
     */
    public $Length;
    /**
     * The Width
     * @var string
     */
    public $Width;
    /**
     * The Height
     * @var string
     */
    public $Height;
    /**
     * Constructor method for DimensionsType
     * @uses UpsDimensionsType::setUnitOfMeasurement()
     * @uses UpsDimensionsType::setLength()
     * @uses UpsDimensionsType::setWidth()
     * @uses UpsDimensionsType::setHeight()
     * @param \Ups\upsshipStruct\UpsShipUnitOfMeasurementType $unitOfMeasurement
     * @param string $length
     * @param string $width
     * @param string $height
     */
    public function __construct(\Ups\upsshipStruct\UpsShipUnitOfMeasurementType $unitOfMeasurement = null, $length = null, $width = null, $height = null)
    {
        $this
            ->setUnitOfMeasurement($unitOfMeasurement)
            ->setLength($length)
            ->setWidth($width)
            ->setHeight($height);
    }
    /**
     * Get UnitOfMeasurement value
     * @return \Ups\upsshipStruct\UpsShipUnitOfMeasurementType|null
     */
    public function getUnitOfMeasurement()
    {
        return $this->UnitOfMeasurement;
    }
    /**
     * Set UnitOfMeasurement value
     * @param \Ups\upsshipStruct\UpsShipUnitOfMeasurementType $unitOfMeasurement
     * @return \Ups\upsshipStruct\UpsDimensionsType
     */
    public function setUnitOfMeasurement(\Ups\upsshipStruct\UpsShipUnitOfMeasurementType $unitOfMeasurement = null)
    {
        $this->UnitOfMeasurement = $unitOfMeasurement;
        return $this;
    }
    /**
     * Get Length value
     * @return string|null
     */
    public function getLength()
    {
        return $this->Length;
    }
    /**
     * Set Length value
     * @param string $length
     * @return \Ups\upsshipStruct\UpsDimensionsType
     */
    public function setLength($length = null)
    {
        // validation for constraint: string
        if (!is_null($length) && !is_string($length)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($length, true), gettype($length)), __LINE__);
        }
        $this->Length = $length;
        return $this;
    }
    /**
     * Get Width value
     * @return string|null
     */
    public function getWidth()
    {
        return $this->Width;
    }
    /**
     * Set Width value
     * @param string $width
     * @return \Ups\upsshipStruct\UpsDimensionsType
     */
    public function setWidth($width = null)
    {
        // validation for constraint: string
        if (!is_null($width) && !is_string($width)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($width, true), gettype($width)), __LINE__);
        }
        $this->Width = $width;
        return $this;
    }
    /**
     * Get Height value
     * @return string|null
     */
    public function getHeight()
    {
        return $this->Height;
    }
    /**
     * Set Height value
     * @param string $height
     * @return \Ups\upsshipStruct\UpsDimensionsType
     */
    public function setHeight($height = null)
    {
        // validation for constraint: string
        if (!is_null($height) && !is_string($height)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($height, true), gettype($height)), __LINE__);
        }
        $this->Height = $height;
        return $this;
    }
}
