<?php

namespace Ups\upsshipStruct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CreditCardType upsshipStruct
 * @package Ups
 * @subpackage Structs
 */
class UpsCreditCardType extends AbstractStructBase
{
    /**
     * The Type
     * @var string
     */
    public $Type;
    /**
     * The Number
     * @var string
     */
    public $Number;
    /**
     * The ExpirationDate
     * @var string
     */
    public $ExpirationDate;
    /**
     * The SecurityCode
     * @var string
     */
    public $SecurityCode;
    /**
     * The Address
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \Ups\upsshipStruct\UpsCreditCardAddressType
     */
    public $Address;
    /**
     * Constructor method for CreditCardType
     * @uses UpsCreditCardType::setType()
     * @uses UpsCreditCardType::setNumber()
     * @uses UpsCreditCardType::setExpirationDate()
     * @uses UpsCreditCardType::setSecurityCode()
     * @uses UpsCreditCardType::setAddress()
     * @param string $type
     * @param string $number
     * @param string $expirationDate
     * @param string $securityCode
     * @param \Ups\upsshipStruct\UpsCreditCardAddressType $address
     */
    public function __construct($type = null, $number = null, $expirationDate = null, $securityCode = null, \Ups\upsshipStruct\UpsCreditCardAddressType $address = null)
    {
        $this
            ->setType($type)
            ->setNumber($number)
            ->setExpirationDate($expirationDate)
            ->setSecurityCode($securityCode)
            ->setAddress($address);
    }
    /**
     * Get Type value
     * @return string|null
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @param string $type
     * @return \Ups\upsshipStruct\UpsCreditCardType
     */
    public function setType($type = null)
    {
        // validation for constraint: string
        if (!is_null($type) && !is_string($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($type, true), gettype($type)), __LINE__);
        }
        $this->Type = $type;
        return $this;
    }
    /**
     * Get Number value
     * @return string|null
     */
    public function getNumber()
    {
        return $this->Number;
    }
    /**
     * Set Number value
     * @param string $number
     * @return \Ups\upsshipStruct\UpsCreditCardType
     */
    public function setNumber($number = null)
    {
        // validation for constraint: string
        if (!is_null($number) && !is_string($number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($number, true), gettype($number)), __LINE__);
        }
        $this->Number = $number;
        return $this;
    }
    /**
     * Get ExpirationDate value
     * @return string|null
     */
    public function getExpirationDate()
    {
        return $this->ExpirationDate;
    }
    /**
     * Set ExpirationDate value
     * @param string $expirationDate
     * @return \Ups\upsshipStruct\UpsCreditCardType
     */
    public function setExpirationDate($expirationDate = null)
    {
        // validation for constraint: string
        if (!is_null($expirationDate) && !is_string($expirationDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($expirationDate, true), gettype($expirationDate)), __LINE__);
        }
        $this->ExpirationDate = $expirationDate;
        return $this;
    }
    /**
     * Get SecurityCode value
     * @return string|null
     */
    public function getSecurityCode()
    {
        return $this->SecurityCode;
    }
    /**
     * Set SecurityCode value
     * @param string $securityCode
     * @return \Ups\upsshipStruct\UpsCreditCardType
     */
    public function setSecurityCode($securityCode = null)
    {
        // validation for constraint: string
        if (!is_null($securityCode) && !is_string($securityCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($securityCode, true), gettype($securityCode)), __LINE__);
        }
        $this->SecurityCode = $securityCode;
        return $this;
    }
    /**
     * Get Address value
     * @return \Ups\upsshipStruct\UpsCreditCardAddressType|null
     */
    public function getAddress()
    {
        return $this->Address;
    }
    /**
     * Set Address value
     * @param \Ups\upsshipStruct\UpsCreditCardAddressType $address
     * @return \Ups\upsshipStruct\UpsCreditCardType
     */
    public function setAddress(\Ups\upsshipStruct\UpsCreditCardAddressType $address = null)
    {
        $this->Address = $address;
        return $this;
    }
}
