<?php

namespace Ups\upsshipStruct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AlternateDeliveryAddressType upsshipStruct
 * @package Ups
 * @subpackage Structs
 */
class UpsAlternateDeliveryAddressType extends AbstractStructBase
{
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Name;
    /**
     * The AttentionName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $AttentionName;
    /**
     * The UPSAccessPointID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $UPSAccessPointID;
    /**
     * The Address
     * @var \Ups\upsshipStruct\UpsADLAddressType
     */
    public $Address;
    /**
     * Constructor method for AlternateDeliveryAddressType
     * @uses UpsAlternateDeliveryAddressType::setName()
     * @uses UpsAlternateDeliveryAddressType::setAttentionName()
     * @uses UpsAlternateDeliveryAddressType::setUPSAccessPointID()
     * @uses UpsAlternateDeliveryAddressType::setAddress()
     * @param string $name
     * @param string $attentionName
     * @param string $uPSAccessPointID
     * @param \Ups\upsshipStruct\UpsADLAddressType $address
     */
    public function __construct($name = null, $attentionName = null, $uPSAccessPointID = null, \Ups\upsshipStruct\UpsADLAddressType $address = null)
    {
        $this
            ->setName($name)
            ->setAttentionName($attentionName)
            ->setUPSAccessPointID($uPSAccessPointID)
            ->setAddress($address);
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \Ups\upsshipStruct\UpsAlternateDeliveryAddressType
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get AttentionName value
     * @return string|null
     */
    public function getAttentionName()
    {
        return $this->AttentionName;
    }
    /**
     * Set AttentionName value
     * @param string $attentionName
     * @return \Ups\upsshipStruct\UpsAlternateDeliveryAddressType
     */
    public function setAttentionName($attentionName = null)
    {
        // validation for constraint: string
        if (!is_null($attentionName) && !is_string($attentionName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($attentionName, true), gettype($attentionName)), __LINE__);
        }
        $this->AttentionName = $attentionName;
        return $this;
    }
    /**
     * Get UPSAccessPointID value
     * @return string|null
     */
    public function getUPSAccessPointID()
    {
        return $this->UPSAccessPointID;
    }
    /**
     * Set UPSAccessPointID value
     * @param string $uPSAccessPointID
     * @return \Ups\upsshipStruct\UpsAlternateDeliveryAddressType
     */
    public function setUPSAccessPointID($uPSAccessPointID = null)
    {
        // validation for constraint: string
        if (!is_null($uPSAccessPointID) && !is_string($uPSAccessPointID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uPSAccessPointID, true), gettype($uPSAccessPointID)), __LINE__);
        }
        $this->UPSAccessPointID = $uPSAccessPointID;
        return $this;
    }
    /**
     * Get Address value
     * @return \Ups\upsshipStruct\UpsADLAddressType|null
     */
    public function getAddress()
    {
        return $this->Address;
    }
    /**
     * Set Address value
     * @param \Ups\upsshipStruct\UpsADLAddressType $address
     * @return \Ups\upsshipStruct\UpsAlternateDeliveryAddressType
     */
    public function setAddress(\Ups\upsshipStruct\UpsADLAddressType $address = null)
    {
        $this->Address = $address;
        return $this;
    }
}
