<?php

namespace Ups\upsshipService;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Process upsshipService
 * @package Ups
 * @subpackage Services
 */
class UpsProcess extends AbstractSoapClientBase
{
    /**
     * Sets the UPSSecurity SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \Ups\upsshipStruct\UpsUPSSecurity $uPSSecurity
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderUPSSecurity(\Ups\upsshipStruct\UpsUPSSecurity $uPSSecurity, $nameSpace = 'http://www.ups.com/XMLSchema/XOLTWS/UPSS/v1.0', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'UPSSecurity', $uPSSecurity, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named ProcessShipment
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: UPSSecurity
     * - SOAPHeaderNamespaces: http://www.ups.com/XMLSchema/XOLTWS/UPSS/v1.0
     * - SOAPHeaderTypes: \Ups\upsshipStruct\UpsUPSSecurity
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Ups\upsshipStruct\UpsShipmentRequest $body
     * @return \Ups\upsshipStruct\UpsShipmentResponse|bool
     */
    public function ProcessShipment(\Ups\upsshipStruct\UpsShipmentRequest $body)
    {
        try {
            $this->setResult($this->getSoapClient()->ProcessShipment($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ProcessShipConfirm
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: UPSSecurity
     * - SOAPHeaderNamespaces: http://www.ups.com/XMLSchema/XOLTWS/UPSS/v1.0
     * - SOAPHeaderTypes: \Ups\upsshipStruct\UpsUPSSecurity
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Ups\upsshipStruct\UpsShipConfirmRequest $body
     * @return \Ups\upsshipStruct\UpsShipConfirmResponse|bool
     */
    public function ProcessShipConfirm(\Ups\upsshipStruct\UpsShipConfirmRequest $body)
    {
        try {
            $this->setResult($this->getSoapClient()->ProcessShipConfirm($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ProcessShipAccept
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: UPSSecurity
     * - SOAPHeaderNamespaces: http://www.ups.com/XMLSchema/XOLTWS/UPSS/v1.0
     * - SOAPHeaderTypes: \Ups\upsshipStruct\UpsUPSSecurity
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Ups\upsshipStruct\UpsShipAcceptRequest $body
     * @return \Ups\upsshipStruct\UpsShipAcceptResponse|bool
     */
    public function ProcessShipAccept(\Ups\upsshipStruct\UpsShipAcceptRequest $body)
    {
        try {
            $this->setResult($this->getSoapClient()->ProcessShipAccept($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \Ups\upsshipStruct\UpsShipAcceptResponse|\Ups\upsshipStruct\UpsShipConfirmResponse|\Ups\upsshipStruct\UpsShipmentResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
