<?php

namespace Ups\upsshipStruct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ShipmentChargesType upsshipStruct
 * @package Ups
 * @subpackage Structs
 */
class UpsShipmentChargesType extends AbstractStructBase
{
    /**
     * The RateChart
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $RateChart;
    /**
     * The BaseServiceCharge
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \Ups\upsshipStruct\UpsShipChargeType
     */
    public $BaseServiceCharge;
    /**
     * The TransportationCharges
     * @var \Ups\upsshipStruct\UpsShipChargeType
     */
    public $TransportationCharges;
    /**
     * The ItemizedCharges
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Ups\upsshipStruct\UpsShipChargeType[]
     */
    public $ItemizedCharges;
    /**
     * The ServiceOptionsCharges
     * @var \Ups\upsshipStruct\UpsShipChargeType
     */
    public $ServiceOptionsCharges;
    /**
     * The TaxCharges
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Ups\upsshipStruct\UpsTaxChargeType[]
     */
    public $TaxCharges;
    /**
     * The TotalCharges
     * @var \Ups\upsshipStruct\UpsShipChargeType
     */
    public $TotalCharges;
    /**
     * The TotalChargesWithTaxes
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \Ups\upsshipStruct\UpsShipChargeType
     */
    public $TotalChargesWithTaxes;
    /**
     * Constructor method for ShipmentChargesType
     * @uses UpsShipmentChargesType::setRateChart()
     * @uses UpsShipmentChargesType::setBaseServiceCharge()
     * @uses UpsShipmentChargesType::setTransportationCharges()
     * @uses UpsShipmentChargesType::setItemizedCharges()
     * @uses UpsShipmentChargesType::setServiceOptionsCharges()
     * @uses UpsShipmentChargesType::setTaxCharges()
     * @uses UpsShipmentChargesType::setTotalCharges()
     * @uses UpsShipmentChargesType::setTotalChargesWithTaxes()
     * @param string $rateChart
     * @param \Ups\upsshipStruct\UpsShipChargeType $baseServiceCharge
     * @param \Ups\upsshipStruct\UpsShipChargeType $transportationCharges
     * @param \Ups\upsshipStruct\UpsShipChargeType[] $itemizedCharges
     * @param \Ups\upsshipStruct\UpsShipChargeType $serviceOptionsCharges
     * @param \Ups\upsshipStruct\UpsTaxChargeType[] $taxCharges
     * @param \Ups\upsshipStruct\UpsShipChargeType $totalCharges
     * @param \Ups\upsshipStruct\UpsShipChargeType $totalChargesWithTaxes
     */
    public function __construct($rateChart = null, \Ups\upsshipStruct\UpsShipChargeType $baseServiceCharge = null, \Ups\upsshipStruct\UpsShipChargeType $transportationCharges = null, array $itemizedCharges = array(), \Ups\upsshipStruct\UpsShipChargeType $serviceOptionsCharges = null, array $taxCharges = array(), \Ups\upsshipStruct\UpsShipChargeType $totalCharges = null, \Ups\upsshipStruct\UpsShipChargeType $totalChargesWithTaxes = null)
    {
        $this
            ->setRateChart($rateChart)
            ->setBaseServiceCharge($baseServiceCharge)
            ->setTransportationCharges($transportationCharges)
            ->setItemizedCharges($itemizedCharges)
            ->setServiceOptionsCharges($serviceOptionsCharges)
            ->setTaxCharges($taxCharges)
            ->setTotalCharges($totalCharges)
            ->setTotalChargesWithTaxes($totalChargesWithTaxes);
    }
    /**
     * Get RateChart value
     * @return string|null
     */
    public function getRateChart()
    {
        return $this->RateChart;
    }
    /**
     * Set RateChart value
     * @param string $rateChart
     * @return \Ups\upsshipStruct\UpsShipmentChargesType
     */
    public function setRateChart($rateChart = null)
    {
        // validation for constraint: string
        if (!is_null($rateChart) && !is_string($rateChart)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rateChart, true), gettype($rateChart)), __LINE__);
        }
        $this->RateChart = $rateChart;
        return $this;
    }
    /**
     * Get BaseServiceCharge value
     * @return \Ups\upsshipStruct\UpsShipChargeType|null
     */
    public function getBaseServiceCharge()
    {
        return $this->BaseServiceCharge;
    }
    /**
     * Set BaseServiceCharge value
     * @param \Ups\upsshipStruct\UpsShipChargeType $baseServiceCharge
     * @return \Ups\upsshipStruct\UpsShipmentChargesType
     */
    public function setBaseServiceCharge(\Ups\upsshipStruct\UpsShipChargeType $baseServiceCharge = null)
    {
        $this->BaseServiceCharge = $baseServiceCharge;
        return $this;
    }
    /**
     * Get TransportationCharges value
     * @return \Ups\upsshipStruct\UpsShipChargeType|null
     */
    public function getTransportationCharges()
    {
        return $this->TransportationCharges;
    }
    /**
     * Set TransportationCharges value
     * @param \Ups\upsshipStruct\UpsShipChargeType $transportationCharges
     * @return \Ups\upsshipStruct\UpsShipmentChargesType
     */
    public function setTransportationCharges(\Ups\upsshipStruct\UpsShipChargeType $transportationCharges = null)
    {
        $this->TransportationCharges = $transportationCharges;
        return $this;
    }
    /**
     * Get ItemizedCharges value
     * @return \Ups\upsshipStruct\UpsShipChargeType[]|null
     */
    public function getItemizedCharges()
    {
        return $this->ItemizedCharges;
    }
    /**
     * This method is responsible for validating the values passed to the setItemizedCharges method
     * This method is willingly generated in order to preserve the one-line inline validation within the setItemizedCharges method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateItemizedChargesForArrayConstraintsFromSetItemizedCharges(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $shipmentChargesTypeItemizedChargesItem) {
            // validation for constraint: itemType
            if (!$shipmentChargesTypeItemizedChargesItem instanceof \Ups\upsshipStruct\UpsShipChargeType) {
                $invalidValues[] = is_object($shipmentChargesTypeItemizedChargesItem) ? get_class($shipmentChargesTypeItemizedChargesItem) : sprintf('%s(%s)', gettype($shipmentChargesTypeItemizedChargesItem), var_export($shipmentChargesTypeItemizedChargesItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ItemizedCharges property can only contain items of type \Ups\upsshipStruct\UpsShipChargeType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ItemizedCharges value
     * @throws \InvalidArgumentException
     * @param \Ups\upsshipStruct\UpsShipChargeType[] $itemizedCharges
     * @return \Ups\upsshipStruct\UpsShipmentChargesType
     */
    public function setItemizedCharges(array $itemizedCharges = array())
    {
        // validation for constraint: array
        if ('' !== ($itemizedChargesArrayErrorMessage = self::validateItemizedChargesForArrayConstraintsFromSetItemizedCharges($itemizedCharges))) {
            throw new \InvalidArgumentException($itemizedChargesArrayErrorMessage, __LINE__);
        }
        $this->ItemizedCharges = $itemizedCharges;
        return $this;
    }
    /**
     * Add item to ItemizedCharges value
     * @throws \InvalidArgumentException
     * @param \Ups\upsshipStruct\UpsShipChargeType $item
     * @return \Ups\upsshipStruct\UpsShipmentChargesType
     */
    public function addToItemizedCharges(\Ups\upsshipStruct\UpsShipChargeType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Ups\upsshipStruct\UpsShipChargeType) {
            throw new \InvalidArgumentException(sprintf('The ItemizedCharges property can only contain items of type \Ups\upsshipStruct\UpsShipChargeType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ItemizedCharges[] = $item;
        return $this;
    }
    /**
     * Get ServiceOptionsCharges value
     * @return \Ups\upsshipStruct\UpsShipChargeType|null
     */
    public function getServiceOptionsCharges()
    {
        return $this->ServiceOptionsCharges;
    }
    /**
     * Set ServiceOptionsCharges value
     * @param \Ups\upsshipStruct\UpsShipChargeType $serviceOptionsCharges
     * @return \Ups\upsshipStruct\UpsShipmentChargesType
     */
    public function setServiceOptionsCharges(\Ups\upsshipStruct\UpsShipChargeType $serviceOptionsCharges = null)
    {
        $this->ServiceOptionsCharges = $serviceOptionsCharges;
        return $this;
    }
    /**
     * Get TaxCharges value
     * @return \Ups\upsshipStruct\UpsTaxChargeType[]|null
     */
    public function getTaxCharges()
    {
        return $this->TaxCharges;
    }
    /**
     * This method is responsible for validating the values passed to the setTaxCharges method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTaxCharges method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTaxChargesForArrayConstraintsFromSetTaxCharges(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $shipmentChargesTypeTaxChargesItem) {
            // validation for constraint: itemType
            if (!$shipmentChargesTypeTaxChargesItem instanceof \Ups\upsshipStruct\UpsTaxChargeType) {
                $invalidValues[] = is_object($shipmentChargesTypeTaxChargesItem) ? get_class($shipmentChargesTypeTaxChargesItem) : sprintf('%s(%s)', gettype($shipmentChargesTypeTaxChargesItem), var_export($shipmentChargesTypeTaxChargesItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The TaxCharges property can only contain items of type \Ups\upsshipStruct\UpsTaxChargeType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set TaxCharges value
     * @throws \InvalidArgumentException
     * @param \Ups\upsshipStruct\UpsTaxChargeType[] $taxCharges
     * @return \Ups\upsshipStruct\UpsShipmentChargesType
     */
    public function setTaxCharges(array $taxCharges = array())
    {
        // validation for constraint: array
        if ('' !== ($taxChargesArrayErrorMessage = self::validateTaxChargesForArrayConstraintsFromSetTaxCharges($taxCharges))) {
            throw new \InvalidArgumentException($taxChargesArrayErrorMessage, __LINE__);
        }
        $this->TaxCharges = $taxCharges;
        return $this;
    }
    /**
     * Add item to TaxCharges value
     * @throws \InvalidArgumentException
     * @param \Ups\upsshipStruct\UpsTaxChargeType $item
     * @return \Ups\upsshipStruct\UpsShipmentChargesType
     */
    public function addToTaxCharges(\Ups\upsshipStruct\UpsTaxChargeType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Ups\upsshipStruct\UpsTaxChargeType) {
            throw new \InvalidArgumentException(sprintf('The TaxCharges property can only contain items of type \Ups\upsshipStruct\UpsTaxChargeType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->TaxCharges[] = $item;
        return $this;
    }
    /**
     * Get TotalCharges value
     * @return \Ups\upsshipStruct\UpsShipChargeType|null
     */
    public function getTotalCharges()
    {
        return $this->TotalCharges;
    }
    /**
     * Set TotalCharges value
     * @param \Ups\upsshipStruct\UpsShipChargeType $totalCharges
     * @return \Ups\upsshipStruct\UpsShipmentChargesType
     */
    public function setTotalCharges(\Ups\upsshipStruct\UpsShipChargeType $totalCharges = null)
    {
        $this->TotalCharges = $totalCharges;
        return $this;
    }
    /**
     * Get TotalChargesWithTaxes value
     * @return \Ups\upsshipStruct\UpsShipChargeType|null
     */
    public function getTotalChargesWithTaxes()
    {
        return $this->TotalChargesWithTaxes;
    }
    /**
     * Set TotalChargesWithTaxes value
     * @param \Ups\upsshipStruct\UpsShipChargeType $totalChargesWithTaxes
     * @return \Ups\upsshipStruct\UpsShipmentChargesType
     */
    public function setTotalChargesWithTaxes(\Ups\upsshipStruct\UpsShipChargeType $totalChargesWithTaxes = null)
    {
        $this->TotalChargesWithTaxes = $totalChargesWithTaxes;
        return $this;
    }
}
