<?php

namespace Ups\upsshipStruct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ShipFromType upsshipStruct
 * @package Ups
 * @subpackage Structs
 */
class UpsShipFromType extends UpsCompanyInfoType
{
    /**
     * The FaxNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $FaxNumber;
    /**
     * The Address
     * @var \Ups\upsshipStruct\UpsShipAddressType
     */
    public $Address;
    /**
     * The EMailAddress
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $EMailAddress;
    /**
     * Constructor method for ShipFromType
     * @uses UpsShipFromType::setFaxNumber()
     * @uses UpsShipFromType::setAddress()
     * @uses UpsShipFromType::setEMailAddress()
     * @param string $faxNumber
     * @param \Ups\upsshipStruct\UpsShipAddressType $address
     * @param string $eMailAddress
     */
    public function __construct($faxNumber = null, \Ups\upsshipStruct\UpsShipAddressType $address = null, $eMailAddress = null)
    {
        $this
            ->setFaxNumber($faxNumber)
            ->setAddress($address)
            ->setEMailAddress($eMailAddress);
    }
    /**
     * Get FaxNumber value
     * @return string|null
     */
    public function getFaxNumber()
    {
        return $this->FaxNumber;
    }
    /**
     * Set FaxNumber value
     * @param string $faxNumber
     * @return \Ups\upsshipStruct\UpsShipFromType
     */
    public function setFaxNumber($faxNumber = null)
    {
        // validation for constraint: string
        if (!is_null($faxNumber) && !is_string($faxNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($faxNumber, true), gettype($faxNumber)), __LINE__);
        }
        $this->FaxNumber = $faxNumber;
        return $this;
    }
    /**
     * Get Address value
     * @return \Ups\upsshipStruct\UpsShipAddressType|null
     */
    public function getAddress()
    {
        return $this->Address;
    }
    /**
     * Set Address value
     * @param \Ups\upsshipStruct\UpsShipAddressType $address
     * @return \Ups\upsshipStruct\UpsShipFromType
     */
    public function setAddress(\Ups\upsshipStruct\UpsShipAddressType $address = null)
    {
        $this->Address = $address;
        return $this;
    }
    /**
     * Get EMailAddress value
     * @return string|null
     */
    public function getEMailAddress()
    {
        return $this->EMailAddress;
    }
    /**
     * Set EMailAddress value
     * @param string $eMailAddress
     * @return \Ups\upsshipStruct\UpsShipFromType
     */
    public function setEMailAddress($eMailAddress = null)
    {
        // validation for constraint: string
        if (!is_null($eMailAddress) && !is_string($eMailAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eMailAddress, true), gettype($eMailAddress)), __LINE__);
        }
        $this->EMailAddress = $eMailAddress;
        return $this;
    }
}
