<?php

namespace Ups\upsshipStruct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for NotificationType upsshipStruct
 * @package Ups
 * @subpackage Structs
 */
class UpsNotificationType extends AbstractStructBase
{
    /**
     * The NotificationCode
     * @var string
     */
    public $NotificationCode;
    /**
     * The EMail
     * @var \Ups\upsshipStruct\UpsEmailDetailsType
     */
    public $EMail;
    /**
     * The VoiceMessage
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \Ups\upsshipStruct\UpsShipmentServiceOptionsNotificationVoiceMessageType
     */
    public $VoiceMessage;
    /**
     * The TextMessage
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \Ups\upsshipStruct\UpsShipmentServiceOptionsNotificationTextMessageType
     */
    public $TextMessage;
    /**
     * The Locale
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \Ups\upsshipStruct\UpsLocaleType
     */
    public $Locale;
    /**
     * Constructor method for NotificationType
     * @uses UpsNotificationType::setNotificationCode()
     * @uses UpsNotificationType::setEMail()
     * @uses UpsNotificationType::setVoiceMessage()
     * @uses UpsNotificationType::setTextMessage()
     * @uses UpsNotificationType::setLocale()
     * @param string $notificationCode
     * @param \Ups\upsshipStruct\UpsEmailDetailsType $eMail
     * @param \Ups\upsshipStruct\UpsShipmentServiceOptionsNotificationVoiceMessageType $voiceMessage
     * @param \Ups\upsshipStruct\UpsShipmentServiceOptionsNotificationTextMessageType $textMessage
     * @param \Ups\upsshipStruct\UpsLocaleType $locale
     */
    public function __construct($notificationCode = null, \Ups\upsshipStruct\UpsEmailDetailsType $eMail = null, \Ups\upsshipStruct\UpsShipmentServiceOptionsNotificationVoiceMessageType $voiceMessage = null, \Ups\upsshipStruct\UpsShipmentServiceOptionsNotificationTextMessageType $textMessage = null, \Ups\upsshipStruct\UpsLocaleType $locale = null)
    {
        $this
            ->setNotificationCode($notificationCode)
            ->setEMail($eMail)
            ->setVoiceMessage($voiceMessage)
            ->setTextMessage($textMessage)
            ->setLocale($locale);
    }
    /**
     * Get NotificationCode value
     * @return string|null
     */
    public function getNotificationCode()
    {
        return $this->NotificationCode;
    }
    /**
     * Set NotificationCode value
     * @param string $notificationCode
     * @return \Ups\upsshipStruct\UpsNotificationType
     */
    public function setNotificationCode($notificationCode = null)
    {
        // validation for constraint: string
        if (!is_null($notificationCode) && !is_string($notificationCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($notificationCode, true), gettype($notificationCode)), __LINE__);
        }
        $this->NotificationCode = $notificationCode;
        return $this;
    }
    /**
     * Get EMail value
     * @return \Ups\upsshipStruct\UpsEmailDetailsType|null
     */
    public function getEMail()
    {
        return $this->EMail;
    }
    /**
     * Set EMail value
     * @param \Ups\upsshipStruct\UpsEmailDetailsType $eMail
     * @return \Ups\upsshipStruct\UpsNotificationType
     */
    public function setEMail(\Ups\upsshipStruct\UpsEmailDetailsType $eMail = null)
    {
        $this->EMail = $eMail;
        return $this;
    }
    /**
     * Get VoiceMessage value
     * @return \Ups\upsshipStruct\UpsShipmentServiceOptionsNotificationVoiceMessageType|null
     */
    public function getVoiceMessage()
    {
        return $this->VoiceMessage;
    }
    /**
     * Set VoiceMessage value
     * @param \Ups\upsshipStruct\UpsShipmentServiceOptionsNotificationVoiceMessageType $voiceMessage
     * @return \Ups\upsshipStruct\UpsNotificationType
     */
    public function setVoiceMessage(\Ups\upsshipStruct\UpsShipmentServiceOptionsNotificationVoiceMessageType $voiceMessage = null)
    {
        $this->VoiceMessage = $voiceMessage;
        return $this;
    }
    /**
     * Get TextMessage value
     * @return \Ups\upsshipStruct\UpsShipmentServiceOptionsNotificationTextMessageType|null
     */
    public function getTextMessage()
    {
        return $this->TextMessage;
    }
    /**
     * Set TextMessage value
     * @param \Ups\upsshipStruct\UpsShipmentServiceOptionsNotificationTextMessageType $textMessage
     * @return \Ups\upsshipStruct\UpsNotificationType
     */
    public function setTextMessage(\Ups\upsshipStruct\UpsShipmentServiceOptionsNotificationTextMessageType $textMessage = null)
    {
        $this->TextMessage = $textMessage;
        return $this;
    }
    /**
     * Get Locale value
     * @return \Ups\upsshipStruct\UpsLocaleType|null
     */
    public function getLocale()
    {
        return $this->Locale;
    }
    /**
     * Set Locale value
     * @param \Ups\upsshipStruct\UpsLocaleType $locale
     * @return \Ups\upsshipStruct\UpsNotificationType
     */
    public function setLocale(\Ups\upsshipStruct\UpsLocaleType $locale = null)
    {
        $this->Locale = $locale;
        return $this;
    }
}
