<?php

namespace Ups\upsshipStruct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FRSPaymentInfoType upsshipStruct
 * @package Ups
 * @subpackage Structs
 */
class UpsFRSPaymentInfoType extends AbstractStructBase
{
    /**
     * The Type
     * @var \Ups\upsshipStruct\UpsPaymentType
     */
    public $Type;
    /**
     * The AccountNumber
     * @var string
     */
    public $AccountNumber;
    /**
     * The Address
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \Ups\upsshipStruct\UpsAccountAddressType
     */
    public $Address;
    /**
     * Constructor method for FRSPaymentInfoType
     * @uses UpsFRSPaymentInfoType::setType()
     * @uses UpsFRSPaymentInfoType::setAccountNumber()
     * @uses UpsFRSPaymentInfoType::setAddress()
     * @param \Ups\upsshipStruct\UpsPaymentType $type
     * @param string $accountNumber
     * @param \Ups\upsshipStruct\UpsAccountAddressType $address
     */
    public function __construct(\Ups\upsshipStruct\UpsPaymentType $type = null, $accountNumber = null, \Ups\upsshipStruct\UpsAccountAddressType $address = null)
    {
        $this
            ->setType($type)
            ->setAccountNumber($accountNumber)
            ->setAddress($address);
    }
    /**
     * Get Type value
     * @return \Ups\upsshipStruct\UpsPaymentType|null
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @param \Ups\upsshipStruct\UpsPaymentType $type
     * @return \Ups\upsshipStruct\UpsFRSPaymentInfoType
     */
    public function setType(\Ups\upsshipStruct\UpsPaymentType $type = null)
    {
        $this->Type = $type;
        return $this;
    }
    /**
     * Get AccountNumber value
     * @return string|null
     */
    public function getAccountNumber()
    {
        return $this->AccountNumber;
    }
    /**
     * Set AccountNumber value
     * @param string $accountNumber
     * @return \Ups\upsshipStruct\UpsFRSPaymentInfoType
     */
    public function setAccountNumber($accountNumber = null)
    {
        // validation for constraint: string
        if (!is_null($accountNumber) && !is_string($accountNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accountNumber, true), gettype($accountNumber)), __LINE__);
        }
        $this->AccountNumber = $accountNumber;
        return $this;
    }
    /**
     * Get Address value
     * @return \Ups\upsshipStruct\UpsAccountAddressType|null
     */
    public function getAddress()
    {
        return $this->Address;
    }
    /**
     * Set Address value
     * @param \Ups\upsshipStruct\UpsAccountAddressType $address
     * @return \Ups\upsshipStruct\UpsFRSPaymentInfoType
     */
    public function setAddress(\Ups\upsshipStruct\UpsAccountAddressType $address = null)
    {
        $this->Address = $address;
        return $this;
    }
}
