<?php

namespace Ups\upsshipStruct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DryIceWeightType upsshipStruct
 * @package Ups
 * @subpackage Structs
 */
class UpsDryIceWeightType extends AbstractStructBase
{
    /**
     * The UnitOfMeasurement
     * @var \Ups\upsshipStruct\UpsShipUnitOfMeasurementType
     */
    public $UnitOfMeasurement;
    /**
     * The Weight
     * @var string
     */
    public $Weight;
    /**
     * Constructor method for DryIceWeightType
     * @uses UpsDryIceWeightType::setUnitOfMeasurement()
     * @uses UpsDryIceWeightType::setWeight()
     * @param \Ups\upsshipStruct\UpsShipUnitOfMeasurementType $unitOfMeasurement
     * @param string $weight
     */
    public function __construct(\Ups\upsshipStruct\UpsShipUnitOfMeasurementType $unitOfMeasurement = null, $weight = null)
    {
        $this
            ->setUnitOfMeasurement($unitOfMeasurement)
            ->setWeight($weight);
    }
    /**
     * Get UnitOfMeasurement value
     * @return \Ups\upsshipStruct\UpsShipUnitOfMeasurementType|null
     */
    public function getUnitOfMeasurement()
    {
        return $this->UnitOfMeasurement;
    }
    /**
     * Set UnitOfMeasurement value
     * @param \Ups\upsshipStruct\UpsShipUnitOfMeasurementType $unitOfMeasurement
     * @return \Ups\upsshipStruct\UpsDryIceWeightType
     */
    public function setUnitOfMeasurement(\Ups\upsshipStruct\UpsShipUnitOfMeasurementType $unitOfMeasurement = null)
    {
        $this->UnitOfMeasurement = $unitOfMeasurement;
        return $this;
    }
    /**
     * Get Weight value
     * @return string|null
     */
    public function getWeight()
    {
        return $this->Weight;
    }
    /**
     * Set Weight value
     * @param string $weight
     * @return \Ups\upsshipStruct\UpsDryIceWeightType
     */
    public function setWeight($weight = null)
    {
        // validation for constraint: string
        if (!is_null($weight) && !is_string($weight)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($weight, true), gettype($weight)), __LINE__);
        }
        $this->Weight = $weight;
        return $this;
    }
}
