<?php

namespace Ups\upsshipStruct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UPSPremierType upsshipStruct
 * @package Ups
 * @subpackage Structs
 */
class UpsUPSPremierType extends AbstractStructBase
{
    /**
     * The Category
     * @var string
     */
    public $Category;
    /**
     * The SensorID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $SensorID;
    /**
     * The HandlingInstructions
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \Ups\upsshipStruct\UpsHandlingInstructionsType
     */
    public $HandlingInstructions;
    /**
     * Constructor method for UPSPremierType
     * @uses UpsUPSPremierType::setCategory()
     * @uses UpsUPSPremierType::setSensorID()
     * @uses UpsUPSPremierType::setHandlingInstructions()
     * @param string $category
     * @param string $sensorID
     * @param \Ups\upsshipStruct\UpsHandlingInstructionsType $handlingInstructions
     */
    public function __construct($category = null, $sensorID = null, \Ups\upsshipStruct\UpsHandlingInstructionsType $handlingInstructions = null)
    {
        $this
            ->setCategory($category)
            ->setSensorID($sensorID)
            ->setHandlingInstructions($handlingInstructions);
    }
    /**
     * Get Category value
     * @return string|null
     */
    public function getCategory()
    {
        return $this->Category;
    }
    /**
     * Set Category value
     * @param string $category
     * @return \Ups\upsshipStruct\UpsUPSPremierType
     */
    public function setCategory($category = null)
    {
        // validation for constraint: string
        if (!is_null($category) && !is_string($category)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($category, true), gettype($category)), __LINE__);
        }
        $this->Category = $category;
        return $this;
    }
    /**
     * Get SensorID value
     * @return string|null
     */
    public function getSensorID()
    {
        return $this->SensorID;
    }
    /**
     * Set SensorID value
     * @param string $sensorID
     * @return \Ups\upsshipStruct\UpsUPSPremierType
     */
    public function setSensorID($sensorID = null)
    {
        // validation for constraint: string
        if (!is_null($sensorID) && !is_string($sensorID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sensorID, true), gettype($sensorID)), __LINE__);
        }
        $this->SensorID = $sensorID;
        return $this;
    }
    /**
     * Get HandlingInstructions value
     * @return \Ups\upsshipStruct\UpsHandlingInstructionsType|null
     */
    public function getHandlingInstructions()
    {
        return $this->HandlingInstructions;
    }
    /**
     * Set HandlingInstructions value
     * @param \Ups\upsshipStruct\UpsHandlingInstructionsType $handlingInstructions
     * @return \Ups\upsshipStruct\UpsUPSPremierType
     */
    public function setHandlingInstructions(\Ups\upsshipStruct\UpsHandlingInstructionsType $handlingInstructions = null)
    {
        $this->HandlingInstructions = $handlingInstructions;
        return $this;
    }
}
