<?php

namespace Ups\upsshipStruct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SoldToType upsshipStruct
 * @package Ups
 * @subpackage Structs
 */
class UpsSoldToType extends AbstractStructBase
{
    /**
     * The Name
     * @var string
     */
    public $Name;
    /**
     * The AttentionName
     * @var string
     */
    public $AttentionName;
    /**
     * The TaxIdentificationNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $TaxIdentificationNumber;
    /**
     * The Phone
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \Ups\upsshipStruct\UpsPhoneType
     */
    public $Phone;
    /**
     * The Option
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Option;
    /**
     * The Address
     * @var \Ups\upsshipStruct\UpsAddressType
     */
    public $Address;
    /**
     * The EMailAddress
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $EMailAddress;
    /**
     * Constructor method for SoldToType
     * @uses UpsSoldToType::setName()
     * @uses UpsSoldToType::setAttentionName()
     * @uses UpsSoldToType::setTaxIdentificationNumber()
     * @uses UpsSoldToType::setPhone()
     * @uses UpsSoldToType::setOption()
     * @uses UpsSoldToType::setAddress()
     * @uses UpsSoldToType::setEMailAddress()
     * @param string $name
     * @param string $attentionName
     * @param string $taxIdentificationNumber
     * @param \Ups\upsshipStruct\UpsPhoneType $phone
     * @param string $option
     * @param \Ups\upsshipStruct\UpsAddressType $address
     * @param string $eMailAddress
     */
    public function __construct($name = null, $attentionName = null, $taxIdentificationNumber = null, \Ups\upsshipStruct\UpsPhoneType $phone = null, $option = null, \Ups\upsshipStruct\UpsAddressType $address = null, $eMailAddress = null)
    {
        $this
            ->setName($name)
            ->setAttentionName($attentionName)
            ->setTaxIdentificationNumber($taxIdentificationNumber)
            ->setPhone($phone)
            ->setOption($option)
            ->setAddress($address)
            ->setEMailAddress($eMailAddress);
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \Ups\upsshipStruct\UpsSoldToType
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get AttentionName value
     * @return string|null
     */
    public function getAttentionName()
    {
        return $this->AttentionName;
    }
    /**
     * Set AttentionName value
     * @param string $attentionName
     * @return \Ups\upsshipStruct\UpsSoldToType
     */
    public function setAttentionName($attentionName = null)
    {
        // validation for constraint: string
        if (!is_null($attentionName) && !is_string($attentionName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($attentionName, true), gettype($attentionName)), __LINE__);
        }
        $this->AttentionName = $attentionName;
        return $this;
    }
    /**
     * Get TaxIdentificationNumber value
     * @return string|null
     */
    public function getTaxIdentificationNumber()
    {
        return $this->TaxIdentificationNumber;
    }
    /**
     * Set TaxIdentificationNumber value
     * @param string $taxIdentificationNumber
     * @return \Ups\upsshipStruct\UpsSoldToType
     */
    public function setTaxIdentificationNumber($taxIdentificationNumber = null)
    {
        // validation for constraint: string
        if (!is_null($taxIdentificationNumber) && !is_string($taxIdentificationNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($taxIdentificationNumber, true), gettype($taxIdentificationNumber)), __LINE__);
        }
        $this->TaxIdentificationNumber = $taxIdentificationNumber;
        return $this;
    }
    /**
     * Get Phone value
     * @return \Ups\upsshipStruct\UpsPhoneType|null
     */
    public function getPhone()
    {
        return $this->Phone;
    }
    /**
     * Set Phone value
     * @param \Ups\upsshipStruct\UpsPhoneType $phone
     * @return \Ups\upsshipStruct\UpsSoldToType
     */
    public function setPhone(\Ups\upsshipStruct\UpsPhoneType $phone = null)
    {
        $this->Phone = $phone;
        return $this;
    }
    /**
     * Get Option value
     * @return string|null
     */
    public function getOption()
    {
        return $this->Option;
    }
    /**
     * Set Option value
     * @param string $option
     * @return \Ups\upsshipStruct\UpsSoldToType
     */
    public function setOption($option = null)
    {
        // validation for constraint: string
        if (!is_null($option) && !is_string($option)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($option, true), gettype($option)), __LINE__);
        }
        $this->Option = $option;
        return $this;
    }
    /**
     * Get Address value
     * @return \Ups\upsshipStruct\UpsAddressType|null
     */
    public function getAddress()
    {
        return $this->Address;
    }
    /**
     * Set Address value
     * @param \Ups\upsshipStruct\UpsAddressType $address
     * @return \Ups\upsshipStruct\UpsSoldToType
     */
    public function setAddress(\Ups\upsshipStruct\UpsAddressType $address = null)
    {
        $this->Address = $address;
        return $this;
    }
    /**
     * Get EMailAddress value
     * @return string|null
     */
    public function getEMailAddress()
    {
        return $this->EMailAddress;
    }
    /**
     * Set EMailAddress value
     * @param string $eMailAddress
     * @return \Ups\upsshipStruct\UpsSoldToType
     */
    public function setEMailAddress($eMailAddress = null)
    {
        // validation for constraint: string
        if (!is_null($eMailAddress) && !is_string($eMailAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eMailAddress, true), gettype($eMailAddress)), __LINE__);
        }
        $this->EMailAddress = $eMailAddress;
        return $this;
    }
}
