<?php

namespace Ups\upsshipStruct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ShipmentResponse upsshipStruct
 * @package Ups
 * @subpackage Structs
 */
class UpsShipmentResponse extends AbstractStructBase
{
    /**
     * The Response
     * Meta information extracted from the WSDL
     * - ref: common:Response
     * @var \Ups\upsshipStruct\UpsResponseType
     */
    public $Response;
    /**
     * The ShipmentResults
     * @var \Ups\upsshipStruct\UpsShipmentResultsType
     */
    public $ShipmentResults;
    /**
     * Constructor method for ShipmentResponse
     * @uses UpsShipmentResponse::setResponse()
     * @uses UpsShipmentResponse::setShipmentResults()
     * @param \Ups\upsshipStruct\UpsResponseType $response
     * @param \Ups\upsshipStruct\UpsShipmentResultsType $shipmentResults
     */
    public function __construct(\Ups\upsshipStruct\UpsResponseType $response = null, \Ups\upsshipStruct\UpsShipmentResultsType $shipmentResults = null)
    {
        $this
            ->setResponse($response)
            ->setShipmentResults($shipmentResults);
    }
    /**
     * Get Response value
     * @return \Ups\upsshipStruct\UpsResponseType|null
     */
    public function getResponse()
    {
        return $this->Response;
    }
    /**
     * Set Response value
     * @param \Ups\upsshipStruct\UpsResponseType $response
     * @return \Ups\upsshipStruct\UpsShipmentResponse
     */
    public function setResponse(\Ups\upsshipStruct\UpsResponseType $response = null)
    {
        $this->Response = $response;
        return $this;
    }
    /**
     * Get ShipmentResults value
     * @return \Ups\upsshipStruct\UpsShipmentResultsType|null
     */
    public function getShipmentResults()
    {
        return $this->ShipmentResults;
    }
    /**
     * Set ShipmentResults value
     * @param \Ups\upsshipStruct\UpsShipmentResultsType $shipmentResults
     * @return \Ups\upsshipStruct\UpsShipmentResponse
     */
    public function setShipmentResults(\Ups\upsshipStruct\UpsShipmentResultsType $shipmentResults = null)
    {
        $this->ShipmentResults = $shipmentResults;
        return $this;
    }
}
