<?php

namespace Ups\upsshipStruct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ShipAcceptRequest upsshipStruct
 * @package Ups
 * @subpackage Structs
 */
class UpsShipAcceptRequest extends AbstractStructBase
{
    /**
     * The Request
     * Meta information extracted from the WSDL
     * - ref: common:Request
     * @var \Ups\upsshipStruct\UpsRequestType
     */
    public $Request;
    /**
     * The ShipmentDigest
     * @var string
     */
    public $ShipmentDigest;
    /**
     * Constructor method for ShipAcceptRequest
     * @uses UpsShipAcceptRequest::setRequest()
     * @uses UpsShipAcceptRequest::setShipmentDigest()
     * @param \Ups\upsshipStruct\UpsRequestType $request
     * @param string $shipmentDigest
     */
    public function __construct(\Ups\upsshipStruct\UpsRequestType $request = null, $shipmentDigest = null)
    {
        $this
            ->setRequest($request)
            ->setShipmentDigest($shipmentDigest);
    }
    /**
     * Get Request value
     * @return \Ups\upsshipStruct\UpsRequestType|null
     */
    public function getRequest()
    {
        return $this->Request;
    }
    /**
     * Set Request value
     * @param \Ups\upsshipStruct\UpsRequestType $request
     * @return \Ups\upsshipStruct\UpsShipAcceptRequest
     */
    public function setRequest(\Ups\upsshipStruct\UpsRequestType $request = null)
    {
        $this->Request = $request;
        return $this;
    }
    /**
     * Get ShipmentDigest value
     * @return string|null
     */
    public function getShipmentDigest()
    {
        return $this->ShipmentDigest;
    }
    /**
     * Set ShipmentDigest value
     * @param string $shipmentDigest
     * @return \Ups\upsshipStruct\UpsShipAcceptRequest
     */
    public function setShipmentDigest($shipmentDigest = null)
    {
        // validation for constraint: string
        if (!is_null($shipmentDigest) && !is_string($shipmentDigest)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shipmentDigest, true), gettype($shipmentDigest)), __LINE__);
        }
        $this->ShipmentDigest = $shipmentDigest;
        return $this;
    }
}
