<?php

namespace Ups\upsshipStruct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LabelDeliveryType upsshipStruct
 * @package Ups
 * @subpackage Structs
 */
class UpsLabelDeliveryType extends AbstractStructBase
{
    /**
     * The EMail
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \Ups\upsshipStruct\UpsEmailDetailsType
     */
    public $EMail;
    /**
     * The LabelLinksIndicator
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $LabelLinksIndicator;
    /**
     * Constructor method for LabelDeliveryType
     * @uses UpsLabelDeliveryType::setEMail()
     * @uses UpsLabelDeliveryType::setLabelLinksIndicator()
     * @param \Ups\upsshipStruct\UpsEmailDetailsType $eMail
     * @param string $labelLinksIndicator
     */
    public function __construct(\Ups\upsshipStruct\UpsEmailDetailsType $eMail = null, $labelLinksIndicator = null)
    {
        $this
            ->setEMail($eMail)
            ->setLabelLinksIndicator($labelLinksIndicator);
    }
    /**
     * Get EMail value
     * @return \Ups\upsshipStruct\UpsEmailDetailsType|null
     */
    public function getEMail()
    {
        return $this->EMail;
    }
    /**
     * Set EMail value
     * @param \Ups\upsshipStruct\UpsEmailDetailsType $eMail
     * @return \Ups\upsshipStruct\UpsLabelDeliveryType
     */
    public function setEMail(\Ups\upsshipStruct\UpsEmailDetailsType $eMail = null)
    {
        $this->EMail = $eMail;
        return $this;
    }
    /**
     * Get LabelLinksIndicator value
     * @return string|null
     */
    public function getLabelLinksIndicator()
    {
        return $this->LabelLinksIndicator;
    }
    /**
     * Set LabelLinksIndicator value
     * @param string $labelLinksIndicator
     * @return \Ups\upsshipStruct\UpsLabelDeliveryType
     */
    public function setLabelLinksIndicator($labelLinksIndicator = null)
    {
        // validation for constraint: string
        if (!is_null($labelLinksIndicator) && !is_string($labelLinksIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($labelLinksIndicator, true), gettype($labelLinksIndicator)), __LINE__);
        }
        $this->LabelLinksIndicator = $labelLinksIndicator;
        return $this;
    }
}
