<?php

namespace Ups\upsshipStruct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for HandlingUnitsResponseType upsshipStruct
 * @package Ups
 * @subpackage Structs
 */
class UpsHandlingUnitsResponseType extends AbstractStructBase
{
    /**
     * The Quantity
     * @var string
     */
    public $Quantity;
    /**
     * The Type
     * @var \Ups\upsshipStruct\UpsShipUnitOfMeasurementType
     */
    public $Type;
    /**
     * The Dimensions
     * @var \Ups\upsshipStruct\UpsHandlingUnitsDimensionsType
     */
    public $Dimensions;
    /**
     * The AdjustedHeight
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \Ups\upsshipStruct\UpsAdjustedHeightType
     */
    public $AdjustedHeight;
    /**
     * Constructor method for HandlingUnitsResponseType
     * @uses UpsHandlingUnitsResponseType::setQuantity()
     * @uses UpsHandlingUnitsResponseType::setType()
     * @uses UpsHandlingUnitsResponseType::setDimensions()
     * @uses UpsHandlingUnitsResponseType::setAdjustedHeight()
     * @param string $quantity
     * @param \Ups\upsshipStruct\UpsShipUnitOfMeasurementType $type
     * @param \Ups\upsshipStruct\UpsHandlingUnitsDimensionsType $dimensions
     * @param \Ups\upsshipStruct\UpsAdjustedHeightType $adjustedHeight
     */
    public function __construct($quantity = null, \Ups\upsshipStruct\UpsShipUnitOfMeasurementType $type = null, \Ups\upsshipStruct\UpsHandlingUnitsDimensionsType $dimensions = null, \Ups\upsshipStruct\UpsAdjustedHeightType $adjustedHeight = null)
    {
        $this
            ->setQuantity($quantity)
            ->setType($type)
            ->setDimensions($dimensions)
            ->setAdjustedHeight($adjustedHeight);
    }
    /**
     * Get Quantity value
     * @return string|null
     */
    public function getQuantity()
    {
        return $this->Quantity;
    }
    /**
     * Set Quantity value
     * @param string $quantity
     * @return \Ups\upsshipStruct\UpsHandlingUnitsResponseType
     */
    public function setQuantity($quantity = null)
    {
        // validation for constraint: string
        if (!is_null($quantity) && !is_string($quantity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($quantity, true), gettype($quantity)), __LINE__);
        }
        $this->Quantity = $quantity;
        return $this;
    }
    /**
     * Get Type value
     * @return \Ups\upsshipStruct\UpsShipUnitOfMeasurementType|null
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @param \Ups\upsshipStruct\UpsShipUnitOfMeasurementType $type
     * @return \Ups\upsshipStruct\UpsHandlingUnitsResponseType
     */
    public function setType(\Ups\upsshipStruct\UpsShipUnitOfMeasurementType $type = null)
    {
        $this->Type = $type;
        return $this;
    }
    /**
     * Get Dimensions value
     * @return \Ups\upsshipStruct\UpsHandlingUnitsDimensionsType|null
     */
    public function getDimensions()
    {
        return $this->Dimensions;
    }
    /**
     * Set Dimensions value
     * @param \Ups\upsshipStruct\UpsHandlingUnitsDimensionsType $dimensions
     * @return \Ups\upsshipStruct\UpsHandlingUnitsResponseType
     */
    public function setDimensions(\Ups\upsshipStruct\UpsHandlingUnitsDimensionsType $dimensions = null)
    {
        $this->Dimensions = $dimensions;
        return $this;
    }
    /**
     * Get AdjustedHeight value
     * @return \Ups\upsshipStruct\UpsAdjustedHeightType|null
     */
    public function getAdjustedHeight()
    {
        return $this->AdjustedHeight;
    }
    /**
     * Set AdjustedHeight value
     * @param \Ups\upsshipStruct\UpsAdjustedHeightType $adjustedHeight
     * @return \Ups\upsshipStruct\UpsHandlingUnitsResponseType
     */
    public function setAdjustedHeight(\Ups\upsshipStruct\UpsAdjustedHeightType $adjustedHeight = null)
    {
        $this->AdjustedHeight = $adjustedHeight;
        return $this;
    }
}
