<?php

namespace Ups\upsshipStruct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CN22ContentType upsshipStruct
 * @package Ups
 * @subpackage Structs
 */
class UpsCN22ContentType extends AbstractStructBase
{
    /**
     * The CN22ContentQuantity
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $CN22ContentQuantity;
    /**
     * The CN22ContentDescription
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $CN22ContentDescription;
    /**
     * The CN22ContentWeight
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \Ups\upsshipStruct\UpsProductWeightType
     */
    public $CN22ContentWeight;
    /**
     * The CN22ContentTotalValue
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $CN22ContentTotalValue;
    /**
     * The CN22ContentCurrencyCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $CN22ContentCurrencyCode;
    /**
     * The CN22ContentCountryOfOrigin
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $CN22ContentCountryOfOrigin;
    /**
     * The CN22ContentTariffNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $CN22ContentTariffNumber;
    /**
     * Constructor method for CN22ContentType
     * @uses UpsCN22ContentType::setCN22ContentQuantity()
     * @uses UpsCN22ContentType::setCN22ContentDescription()
     * @uses UpsCN22ContentType::setCN22ContentWeight()
     * @uses UpsCN22ContentType::setCN22ContentTotalValue()
     * @uses UpsCN22ContentType::setCN22ContentCurrencyCode()
     * @uses UpsCN22ContentType::setCN22ContentCountryOfOrigin()
     * @uses UpsCN22ContentType::setCN22ContentTariffNumber()
     * @param string $cN22ContentQuantity
     * @param string $cN22ContentDescription
     * @param \Ups\upsshipStruct\UpsProductWeightType $cN22ContentWeight
     * @param string $cN22ContentTotalValue
     * @param string $cN22ContentCurrencyCode
     * @param string $cN22ContentCountryOfOrigin
     * @param string $cN22ContentTariffNumber
     */
    public function __construct($cN22ContentQuantity = null, $cN22ContentDescription = null, \Ups\upsshipStruct\UpsProductWeightType $cN22ContentWeight = null, $cN22ContentTotalValue = null, $cN22ContentCurrencyCode = null, $cN22ContentCountryOfOrigin = null, $cN22ContentTariffNumber = null)
    {
        $this
            ->setCN22ContentQuantity($cN22ContentQuantity)
            ->setCN22ContentDescription($cN22ContentDescription)
            ->setCN22ContentWeight($cN22ContentWeight)
            ->setCN22ContentTotalValue($cN22ContentTotalValue)
            ->setCN22ContentCurrencyCode($cN22ContentCurrencyCode)
            ->setCN22ContentCountryOfOrigin($cN22ContentCountryOfOrigin)
            ->setCN22ContentTariffNumber($cN22ContentTariffNumber);
    }
    /**
     * Get CN22ContentQuantity value
     * @return string|null
     */
    public function getCN22ContentQuantity()
    {
        return $this->CN22ContentQuantity;
    }
    /**
     * Set CN22ContentQuantity value
     * @param string $cN22ContentQuantity
     * @return \Ups\upsshipStruct\UpsCN22ContentType
     */
    public function setCN22ContentQuantity($cN22ContentQuantity = null)
    {
        // validation for constraint: string
        if (!is_null($cN22ContentQuantity) && !is_string($cN22ContentQuantity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cN22ContentQuantity, true), gettype($cN22ContentQuantity)), __LINE__);
        }
        $this->CN22ContentQuantity = $cN22ContentQuantity;
        return $this;
    }
    /**
     * Get CN22ContentDescription value
     * @return string|null
     */
    public function getCN22ContentDescription()
    {
        return $this->CN22ContentDescription;
    }
    /**
     * Set CN22ContentDescription value
     * @param string $cN22ContentDescription
     * @return \Ups\upsshipStruct\UpsCN22ContentType
     */
    public function setCN22ContentDescription($cN22ContentDescription = null)
    {
        // validation for constraint: string
        if (!is_null($cN22ContentDescription) && !is_string($cN22ContentDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cN22ContentDescription, true), gettype($cN22ContentDescription)), __LINE__);
        }
        $this->CN22ContentDescription = $cN22ContentDescription;
        return $this;
    }
    /**
     * Get CN22ContentWeight value
     * @return \Ups\upsshipStruct\UpsProductWeightType|null
     */
    public function getCN22ContentWeight()
    {
        return $this->CN22ContentWeight;
    }
    /**
     * Set CN22ContentWeight value
     * @param \Ups\upsshipStruct\UpsProductWeightType $cN22ContentWeight
     * @return \Ups\upsshipStruct\UpsCN22ContentType
     */
    public function setCN22ContentWeight(\Ups\upsshipStruct\UpsProductWeightType $cN22ContentWeight = null)
    {
        $this->CN22ContentWeight = $cN22ContentWeight;
        return $this;
    }
    /**
     * Get CN22ContentTotalValue value
     * @return string|null
     */
    public function getCN22ContentTotalValue()
    {
        return $this->CN22ContentTotalValue;
    }
    /**
     * Set CN22ContentTotalValue value
     * @param string $cN22ContentTotalValue
     * @return \Ups\upsshipStruct\UpsCN22ContentType
     */
    public function setCN22ContentTotalValue($cN22ContentTotalValue = null)
    {
        // validation for constraint: string
        if (!is_null($cN22ContentTotalValue) && !is_string($cN22ContentTotalValue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cN22ContentTotalValue, true), gettype($cN22ContentTotalValue)), __LINE__);
        }
        $this->CN22ContentTotalValue = $cN22ContentTotalValue;
        return $this;
    }
    /**
     * Get CN22ContentCurrencyCode value
     * @return string|null
     */
    public function getCN22ContentCurrencyCode()
    {
        return $this->CN22ContentCurrencyCode;
    }
    /**
     * Set CN22ContentCurrencyCode value
     * @param string $cN22ContentCurrencyCode
     * @return \Ups\upsshipStruct\UpsCN22ContentType
     */
    public function setCN22ContentCurrencyCode($cN22ContentCurrencyCode = null)
    {
        // validation for constraint: string
        if (!is_null($cN22ContentCurrencyCode) && !is_string($cN22ContentCurrencyCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cN22ContentCurrencyCode, true), gettype($cN22ContentCurrencyCode)), __LINE__);
        }
        $this->CN22ContentCurrencyCode = $cN22ContentCurrencyCode;
        return $this;
    }
    /**
     * Get CN22ContentCountryOfOrigin value
     * @return string|null
     */
    public function getCN22ContentCountryOfOrigin()
    {
        return $this->CN22ContentCountryOfOrigin;
    }
    /**
     * Set CN22ContentCountryOfOrigin value
     * @param string $cN22ContentCountryOfOrigin
     * @return \Ups\upsshipStruct\UpsCN22ContentType
     */
    public function setCN22ContentCountryOfOrigin($cN22ContentCountryOfOrigin = null)
    {
        // validation for constraint: string
        if (!is_null($cN22ContentCountryOfOrigin) && !is_string($cN22ContentCountryOfOrigin)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cN22ContentCountryOfOrigin, true), gettype($cN22ContentCountryOfOrigin)), __LINE__);
        }
        $this->CN22ContentCountryOfOrigin = $cN22ContentCountryOfOrigin;
        return $this;
    }
    /**
     * Get CN22ContentTariffNumber value
     * @return string|null
     */
    public function getCN22ContentTariffNumber()
    {
        return $this->CN22ContentTariffNumber;
    }
    /**
     * Set CN22ContentTariffNumber value
     * @param string $cN22ContentTariffNumber
     * @return \Ups\upsshipStruct\UpsCN22ContentType
     */
    public function setCN22ContentTariffNumber($cN22ContentTariffNumber = null)
    {
        // validation for constraint: string
        if (!is_null($cN22ContentTariffNumber) && !is_string($cN22ContentTariffNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cN22ContentTariffNumber, true), gettype($cN22ContentTariffNumber)), __LINE__);
        }
        $this->CN22ContentTariffNumber = $cN22ContentTariffNumber;
        return $this;
    }
}
