<?php

namespace Ups\upsshipStruct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BillReceiverType upsshipStruct
 * @package Ups
 * @subpackage Structs
 */
class UpsBillReceiverType extends AbstractStructBase
{
    /**
     * The AccountNumber
     * @var string
     */
    public $AccountNumber;
    /**
     * The Address
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \Ups\upsshipStruct\UpsBillReceiverAddressType
     */
    public $Address;
    /**
     * Constructor method for BillReceiverType
     * @uses UpsBillReceiverType::setAccountNumber()
     * @uses UpsBillReceiverType::setAddress()
     * @param string $accountNumber
     * @param \Ups\upsshipStruct\UpsBillReceiverAddressType $address
     */
    public function __construct($accountNumber = null, \Ups\upsshipStruct\UpsBillReceiverAddressType $address = null)
    {
        $this
            ->setAccountNumber($accountNumber)
            ->setAddress($address);
    }
    /**
     * Get AccountNumber value
     * @return string|null
     */
    public function getAccountNumber()
    {
        return $this->AccountNumber;
    }
    /**
     * Set AccountNumber value
     * @param string $accountNumber
     * @return \Ups\upsshipStruct\UpsBillReceiverType
     */
    public function setAccountNumber($accountNumber = null)
    {
        // validation for constraint: string
        if (!is_null($accountNumber) && !is_string($accountNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accountNumber, true), gettype($accountNumber)), __LINE__);
        }
        $this->AccountNumber = $accountNumber;
        return $this;
    }
    /**
     * Get Address value
     * @return \Ups\upsshipStruct\UpsBillReceiverAddressType|null
     */
    public function getAddress()
    {
        return $this->Address;
    }
    /**
     * Set Address value
     * @param \Ups\upsshipStruct\UpsBillReceiverAddressType $address
     * @return \Ups\upsshipStruct\UpsBillReceiverType
     */
    public function setAddress(\Ups\upsshipStruct\UpsBillReceiverAddressType $address = null)
    {
        $this->Address = $address;
        return $this;
    }
}
