<?php

namespace Ups\upsshipStruct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PromotionalDiscountInformationType upsshipStruct
 * @package Ups
 * @subpackage Structs
 */
class UpsPromotionalDiscountInformationType extends AbstractStructBase
{
    /**
     * The PromoCode
     * @var string
     */
    public $PromoCode;
    /**
     * The PromoAliasCode
     * @var string
     */
    public $PromoAliasCode;
    /**
     * Constructor method for PromotionalDiscountInformationType
     * @uses UpsPromotionalDiscountInformationType::setPromoCode()
     * @uses UpsPromotionalDiscountInformationType::setPromoAliasCode()
     * @param string $promoCode
     * @param string $promoAliasCode
     */
    public function __construct($promoCode = null, $promoAliasCode = null)
    {
        $this
            ->setPromoCode($promoCode)
            ->setPromoAliasCode($promoAliasCode);
    }
    /**
     * Get PromoCode value
     * @return string|null
     */
    public function getPromoCode()
    {
        return $this->PromoCode;
    }
    /**
     * Set PromoCode value
     * @param string $promoCode
     * @return \Ups\upsshipStruct\UpsPromotionalDiscountInformationType
     */
    public function setPromoCode($promoCode = null)
    {
        // validation for constraint: string
        if (!is_null($promoCode) && !is_string($promoCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($promoCode, true), gettype($promoCode)), __LINE__);
        }
        $this->PromoCode = $promoCode;
        return $this;
    }
    /**
     * Get PromoAliasCode value
     * @return string|null
     */
    public function getPromoAliasCode()
    {
        return $this->PromoAliasCode;
    }
    /**
     * Set PromoAliasCode value
     * @param string $promoAliasCode
     * @return \Ups\upsshipStruct\UpsPromotionalDiscountInformationType
     */
    public function setPromoAliasCode($promoAliasCode = null)
    {
        // validation for constraint: string
        if (!is_null($promoAliasCode) && !is_string($promoAliasCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($promoAliasCode, true), gettype($promoAliasCode)), __LINE__);
        }
        $this->PromoAliasCode = $promoAliasCode;
        return $this;
    }
}
