<?php

namespace Ups_transit\UPStransitStruct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CodeType UPStransitStruct
 * @package Ups_transit
 * @subpackage Structs
 */
class Ups_transitCodeType extends AbstractStructBase
{
    /**
     * The Code
     * @var string
     */
    public $Code;
    /**
     * The Description
     * @var string
     */
    public $Description;
    /**
     * The Digest
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Digest;
    /**
     * Constructor method for CodeType
     * @uses Ups_transitCodeType::setCode()
     * @uses Ups_transitCodeType::setDescription()
     * @uses Ups_transitCodeType::setDigest()
     * @param string $code
     * @param string $description
     * @param string $digest
     */
    public function __construct($code = null, $description = null, $digest = null)
    {
        $this
            ->setCode($code)
            ->setDescription($description)
            ->setDigest($digest);
    }
    /**
     * Get Code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @param string $code
     * @return \Ups_transit\UPStransitStruct\Ups_transitCodeType
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($code, true), gettype($code)), __LINE__);
        }
        $this->Code = $code;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \Ups_transit\UPStransitStruct\Ups_transitCodeType
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Get Digest value
     * @return string|null
     */
    public function getDigest()
    {
        return $this->Digest;
    }
    /**
     * Set Digest value
     * @param string $digest
     * @return \Ups_transit\UPStransitStruct\Ups_transitCodeType
     */
    public function setDigest($digest = null)
    {
        // validation for constraint: string
        if (!is_null($digest) && !is_string($digest)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($digest, true), gettype($digest)), __LINE__);
        }
        $this->Digest = $digest;
        return $this;
    }
}
