<?php

namespace Ups_transit\UPStransitStruct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TimeInTransitRequest UPStransitStruct
 * @package Ups_transit
 * @subpackage Structs
 */
class Ups_transitTimeInTransitRequest extends AbstractStructBase
{
    /**
     * The Request
     * Meta information extracted from the WSDL
     * - ref: common:Request
     * @var \Ups_transit\UPStransitStruct\Ups_transitRequestType
     */
    public $Request;
    /**
     * The ShipFrom
     * @var \Ups_transit\UPStransitStruct\Ups_transitRequestShipFromType
     */
    public $ShipFrom;
    /**
     * The ShipTo
     * @var \Ups_transit\UPStransitStruct\Ups_transitRequestShipToType
     */
    public $ShipTo;
    /**
     * The Pickup
     * @var \Ups_transit\UPStransitStruct\Ups_transitPickupType
     */
    public $Pickup;
    /**
     * The ShipmentWeight
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \Ups_transit\UPStransitStruct\Ups_transitShipmentWeightType
     */
    public $ShipmentWeight;
    /**
     * The TotalPackagesInShipment
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $TotalPackagesInShipment;
    /**
     * The InvoiceLineTotal
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \Ups_transit\UPStransitStruct\Ups_transitInvoiceLineTotalType
     */
    public $InvoiceLineTotal;
    /**
     * The DocumentsOnlyIndicator
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $DocumentsOnlyIndicator;
    /**
     * The BillType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $BillType;
    /**
     * The MaximumListSize
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $MaximumListSize;
    /**
     * The SaturdayDeliveryInfoRequestIndicator
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $SaturdayDeliveryInfoRequestIndicator;
    /**
     * The DropOffAtFacilityIndicator
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $DropOffAtFacilityIndicator;
    /**
     * The HoldForPickupIndicator
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $HoldForPickupIndicator;
    /**
     * The IncludeAllServicesIndicator
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - usage: ups
     * @var string
     */
    public $IncludeAllServicesIndicator;
    /**
     * The ReturnContractServices
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Ups_transit\UPStransitStruct\Ups_transitReturnContractServicesType[]
     */
    public $ReturnContractServices;
    /**
     * Constructor method for TimeInTransitRequest
     * @uses Ups_transitTimeInTransitRequest::setRequest()
     * @uses Ups_transitTimeInTransitRequest::setShipFrom()
     * @uses Ups_transitTimeInTransitRequest::setShipTo()
     * @uses Ups_transitTimeInTransitRequest::setPickup()
     * @uses Ups_transitTimeInTransitRequest::setShipmentWeight()
     * @uses Ups_transitTimeInTransitRequest::setTotalPackagesInShipment()
     * @uses Ups_transitTimeInTransitRequest::setInvoiceLineTotal()
     * @uses Ups_transitTimeInTransitRequest::setDocumentsOnlyIndicator()
     * @uses Ups_transitTimeInTransitRequest::setBillType()
     * @uses Ups_transitTimeInTransitRequest::setMaximumListSize()
     * @uses Ups_transitTimeInTransitRequest::setSaturdayDeliveryInfoRequestIndicator()
     * @uses Ups_transitTimeInTransitRequest::setDropOffAtFacilityIndicator()
     * @uses Ups_transitTimeInTransitRequest::setHoldForPickupIndicator()
     * @uses Ups_transitTimeInTransitRequest::setIncludeAllServicesIndicator()
     * @uses Ups_transitTimeInTransitRequest::setReturnContractServices()
     * @param \Ups_transit\UPStransitStruct\Ups_transitRequestType $request
     * @param \Ups_transit\UPStransitStruct\Ups_transitRequestShipFromType $shipFrom
     * @param \Ups_transit\UPStransitStruct\Ups_transitRequestShipToType $shipTo
     * @param \Ups_transit\UPStransitStruct\Ups_transitPickupType $pickup
     * @param \Ups_transit\UPStransitStruct\Ups_transitShipmentWeightType $shipmentWeight
     * @param string $totalPackagesInShipment
     * @param \Ups_transit\UPStransitStruct\Ups_transitInvoiceLineTotalType $invoiceLineTotal
     * @param string $documentsOnlyIndicator
     * @param string $billType
     * @param string $maximumListSize
     * @param string $saturdayDeliveryInfoRequestIndicator
     * @param string $dropOffAtFacilityIndicator
     * @param string $holdForPickupIndicator
     * @param string $includeAllServicesIndicator
     * @param \Ups_transit\UPStransitStruct\Ups_transitReturnContractServicesType[] $returnContractServices
     */
    public function __construct(\Ups_transit\UPStransitStruct\Ups_transitRequestType $request = null, \Ups_transit\UPStransitStruct\Ups_transitRequestShipFromType $shipFrom = null, \Ups_transit\UPStransitStruct\Ups_transitRequestShipToType $shipTo = null, \Ups_transit\UPStransitStruct\Ups_transitPickupType $pickup = null, \Ups_transit\UPStransitStruct\Ups_transitShipmentWeightType $shipmentWeight = null, $totalPackagesInShipment = null, \Ups_transit\UPStransitStruct\Ups_transitInvoiceLineTotalType $invoiceLineTotal = null, $documentsOnlyIndicator = null, $billType = null, $maximumListSize = null, $saturdayDeliveryInfoRequestIndicator = null, $dropOffAtFacilityIndicator = null, $holdForPickupIndicator = null, $includeAllServicesIndicator = null, array $returnContractServices = array())
    {
        $this
            ->setRequest($request)
            ->setShipFrom($shipFrom)
            ->setShipTo($shipTo)
            ->setPickup($pickup)
            ->setShipmentWeight($shipmentWeight)
            ->setTotalPackagesInShipment($totalPackagesInShipment)
            ->setInvoiceLineTotal($invoiceLineTotal)
            ->setDocumentsOnlyIndicator($documentsOnlyIndicator)
            ->setBillType($billType)
            ->setMaximumListSize($maximumListSize)
            ->setSaturdayDeliveryInfoRequestIndicator($saturdayDeliveryInfoRequestIndicator)
            ->setDropOffAtFacilityIndicator($dropOffAtFacilityIndicator)
            ->setHoldForPickupIndicator($holdForPickupIndicator)
            ->setIncludeAllServicesIndicator($includeAllServicesIndicator)
            ->setReturnContractServices($returnContractServices);
    }
    /**
     * Get Request value
     * @return \Ups_transit\UPStransitStruct\Ups_transitRequestType|null
     */
    public function getRequest()
    {
        return $this->Request;
    }
    /**
     * Set Request value
     * @param \Ups_transit\UPStransitStruct\Ups_transitRequestType $request
     * @return \Ups_transit\UPStransitStruct\Ups_transitTimeInTransitRequest
     */
    public function setRequest(\Ups_transit\UPStransitStruct\Ups_transitRequestType $request = null)
    {
        $this->Request = $request;
        return $this;
    }
    /**
     * Get ShipFrom value
     * @return \Ups_transit\UPStransitStruct\Ups_transitRequestShipFromType|null
     */
    public function getShipFrom()
    {
        return $this->ShipFrom;
    }
    /**
     * Set ShipFrom value
     * @param \Ups_transit\UPStransitStruct\Ups_transitRequestShipFromType $shipFrom
     * @return \Ups_transit\UPStransitStruct\Ups_transitTimeInTransitRequest
     */
    public function setShipFrom(\Ups_transit\UPStransitStruct\Ups_transitRequestShipFromType $shipFrom = null)
    {
        $this->ShipFrom = $shipFrom;
        return $this;
    }
    /**
     * Get ShipTo value
     * @return \Ups_transit\UPStransitStruct\Ups_transitRequestShipToType|null
     */
    public function getShipTo()
    {
        return $this->ShipTo;
    }
    /**
     * Set ShipTo value
     * @param \Ups_transit\UPStransitStruct\Ups_transitRequestShipToType $shipTo
     * @return \Ups_transit\UPStransitStruct\Ups_transitTimeInTransitRequest
     */
    public function setShipTo(\Ups_transit\UPStransitStruct\Ups_transitRequestShipToType $shipTo = null)
    {
        $this->ShipTo = $shipTo;
        return $this;
    }
    /**
     * Get Pickup value
     * @return \Ups_transit\UPStransitStruct\Ups_transitPickupType|null
     */
    public function getPickup()
    {
        return $this->Pickup;
    }
    /**
     * Set Pickup value
     * @param \Ups_transit\UPStransitStruct\Ups_transitPickupType $pickup
     * @return \Ups_transit\UPStransitStruct\Ups_transitTimeInTransitRequest
     */
    public function setPickup(\Ups_transit\UPStransitStruct\Ups_transitPickupType $pickup = null)
    {
        $this->Pickup = $pickup;
        return $this;
    }
    /**
     * Get ShipmentWeight value
     * @return \Ups_transit\UPStransitStruct\Ups_transitShipmentWeightType|null
     */
    public function getShipmentWeight()
    {
        return $this->ShipmentWeight;
    }
    /**
     * Set ShipmentWeight value
     * @param \Ups_transit\UPStransitStruct\Ups_transitShipmentWeightType $shipmentWeight
     * @return \Ups_transit\UPStransitStruct\Ups_transitTimeInTransitRequest
     */
    public function setShipmentWeight(\Ups_transit\UPStransitStruct\Ups_transitShipmentWeightType $shipmentWeight = null)
    {
        $this->ShipmentWeight = $shipmentWeight;
        return $this;
    }
    /**
     * Get TotalPackagesInShipment value
     * @return string|null
     */
    public function getTotalPackagesInShipment()
    {
        return $this->TotalPackagesInShipment;
    }
    /**
     * Set TotalPackagesInShipment value
     * @param string $totalPackagesInShipment
     * @return \Ups_transit\UPStransitStruct\Ups_transitTimeInTransitRequest
     */
    public function setTotalPackagesInShipment($totalPackagesInShipment = null)
    {
        // validation for constraint: string
        if (!is_null($totalPackagesInShipment) && !is_string($totalPackagesInShipment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($totalPackagesInShipment, true), gettype($totalPackagesInShipment)), __LINE__);
        }
        $this->TotalPackagesInShipment = $totalPackagesInShipment;
        return $this;
    }
    /**
     * Get InvoiceLineTotal value
     * @return \Ups_transit\UPStransitStruct\Ups_transitInvoiceLineTotalType|null
     */
    public function getInvoiceLineTotal()
    {
        return $this->InvoiceLineTotal;
    }
    /**
     * Set InvoiceLineTotal value
     * @param \Ups_transit\UPStransitStruct\Ups_transitInvoiceLineTotalType $invoiceLineTotal
     * @return \Ups_transit\UPStransitStruct\Ups_transitTimeInTransitRequest
     */
    public function setInvoiceLineTotal(\Ups_transit\UPStransitStruct\Ups_transitInvoiceLineTotalType $invoiceLineTotal = null)
    {
        $this->InvoiceLineTotal = $invoiceLineTotal;
        return $this;
    }
    /**
     * Get DocumentsOnlyIndicator value
     * @return string|null
     */
    public function getDocumentsOnlyIndicator()
    {
        return $this->DocumentsOnlyIndicator;
    }
    /**
     * Set DocumentsOnlyIndicator value
     * @param string $documentsOnlyIndicator
     * @return \Ups_transit\UPStransitStruct\Ups_transitTimeInTransitRequest
     */
    public function setDocumentsOnlyIndicator($documentsOnlyIndicator = null)
    {
        // validation for constraint: string
        if (!is_null($documentsOnlyIndicator) && !is_string($documentsOnlyIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($documentsOnlyIndicator, true), gettype($documentsOnlyIndicator)), __LINE__);
        }
        $this->DocumentsOnlyIndicator = $documentsOnlyIndicator;
        return $this;
    }
    /**
     * Get BillType value
     * @return string|null
     */
    public function getBillType()
    {
        return $this->BillType;
    }
    /**
     * Set BillType value
     * @param string $billType
     * @return \Ups_transit\UPStransitStruct\Ups_transitTimeInTransitRequest
     */
    public function setBillType($billType = null)
    {
        // validation for constraint: string
        if (!is_null($billType) && !is_string($billType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($billType, true), gettype($billType)), __LINE__);
        }
        $this->BillType = $billType;
        return $this;
    }
    /**
     * Get MaximumListSize value
     * @return string|null
     */
    public function getMaximumListSize()
    {
        return $this->MaximumListSize;
    }
    /**
     * Set MaximumListSize value
     * @param string $maximumListSize
     * @return \Ups_transit\UPStransitStruct\Ups_transitTimeInTransitRequest
     */
    public function setMaximumListSize($maximumListSize = null)
    {
        // validation for constraint: string
        if (!is_null($maximumListSize) && !is_string($maximumListSize)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($maximumListSize, true), gettype($maximumListSize)), __LINE__);
        }
        $this->MaximumListSize = $maximumListSize;
        return $this;
    }
    /**
     * Get SaturdayDeliveryInfoRequestIndicator value
     * @return string|null
     */
    public function getSaturdayDeliveryInfoRequestIndicator()
    {
        return $this->SaturdayDeliveryInfoRequestIndicator;
    }
    /**
     * Set SaturdayDeliveryInfoRequestIndicator value
     * @param string $saturdayDeliveryInfoRequestIndicator
     * @return \Ups_transit\UPStransitStruct\Ups_transitTimeInTransitRequest
     */
    public function setSaturdayDeliveryInfoRequestIndicator($saturdayDeliveryInfoRequestIndicator = null)
    {
        // validation for constraint: string
        if (!is_null($saturdayDeliveryInfoRequestIndicator) && !is_string($saturdayDeliveryInfoRequestIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($saturdayDeliveryInfoRequestIndicator, true), gettype($saturdayDeliveryInfoRequestIndicator)), __LINE__);
        }
        $this->SaturdayDeliveryInfoRequestIndicator = $saturdayDeliveryInfoRequestIndicator;
        return $this;
    }
    /**
     * Get DropOffAtFacilityIndicator value
     * @return string|null
     */
    public function getDropOffAtFacilityIndicator()
    {
        return $this->DropOffAtFacilityIndicator;
    }
    /**
     * Set DropOffAtFacilityIndicator value
     * @param string $dropOffAtFacilityIndicator
     * @return \Ups_transit\UPStransitStruct\Ups_transitTimeInTransitRequest
     */
    public function setDropOffAtFacilityIndicator($dropOffAtFacilityIndicator = null)
    {
        // validation for constraint: string
        if (!is_null($dropOffAtFacilityIndicator) && !is_string($dropOffAtFacilityIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dropOffAtFacilityIndicator, true), gettype($dropOffAtFacilityIndicator)), __LINE__);
        }
        $this->DropOffAtFacilityIndicator = $dropOffAtFacilityIndicator;
        return $this;
    }
    /**
     * Get HoldForPickupIndicator value
     * @return string|null
     */
    public function getHoldForPickupIndicator()
    {
        return $this->HoldForPickupIndicator;
    }
    /**
     * Set HoldForPickupIndicator value
     * @param string $holdForPickupIndicator
     * @return \Ups_transit\UPStransitStruct\Ups_transitTimeInTransitRequest
     */
    public function setHoldForPickupIndicator($holdForPickupIndicator = null)
    {
        // validation for constraint: string
        if (!is_null($holdForPickupIndicator) && !is_string($holdForPickupIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($holdForPickupIndicator, true), gettype($holdForPickupIndicator)), __LINE__);
        }
        $this->HoldForPickupIndicator = $holdForPickupIndicator;
        return $this;
    }
    /**
     * Get IncludeAllServicesIndicator value
     * @return string|null
     */
    public function getIncludeAllServicesIndicator()
    {
        return $this->IncludeAllServicesIndicator;
    }
    /**
     * Set IncludeAllServicesIndicator value
     * @param string $includeAllServicesIndicator
     * @return \Ups_transit\UPStransitStruct\Ups_transitTimeInTransitRequest
     */
    public function setIncludeAllServicesIndicator($includeAllServicesIndicator = null)
    {
        // validation for constraint: string
        if (!is_null($includeAllServicesIndicator) && !is_string($includeAllServicesIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($includeAllServicesIndicator, true), gettype($includeAllServicesIndicator)), __LINE__);
        }
        $this->IncludeAllServicesIndicator = $includeAllServicesIndicator;
        return $this;
    }
    /**
     * Get ReturnContractServices value
     * @return \Ups_transit\UPStransitStruct\Ups_transitReturnContractServicesType[]|null
     */
    public function getReturnContractServices()
    {
        return $this->ReturnContractServices;
    }
    /**
     * This method is responsible for validating the values passed to the setReturnContractServices method
     * This method is willingly generated in order to preserve the one-line inline validation within the setReturnContractServices method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateReturnContractServicesForArrayConstraintsFromSetReturnContractServices(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $timeInTransitRequestReturnContractServicesItem) {
            // validation for constraint: itemType
            if (!$timeInTransitRequestReturnContractServicesItem instanceof \Ups_transit\UPStransitStruct\Ups_transitReturnContractServicesType) {
                $invalidValues[] = is_object($timeInTransitRequestReturnContractServicesItem) ? get_class($timeInTransitRequestReturnContractServicesItem) : sprintf('%s(%s)', gettype($timeInTransitRequestReturnContractServicesItem), var_export($timeInTransitRequestReturnContractServicesItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ReturnContractServices property can only contain items of type \Ups_transit\UPStransitStruct\Ups_transitReturnContractServicesType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ReturnContractServices value
     * @throws \InvalidArgumentException
     * @param \Ups_transit\UPStransitStruct\Ups_transitReturnContractServicesType[] $returnContractServices
     * @return \Ups_transit\UPStransitStruct\Ups_transitTimeInTransitRequest
     */
    public function setReturnContractServices(array $returnContractServices = array())
    {
        // validation for constraint: array
        if ('' !== ($returnContractServicesArrayErrorMessage = self::validateReturnContractServicesForArrayConstraintsFromSetReturnContractServices($returnContractServices))) {
            throw new \InvalidArgumentException($returnContractServicesArrayErrorMessage, __LINE__);
        }
        $this->ReturnContractServices = $returnContractServices;
        return $this;
    }
    /**
     * Add item to ReturnContractServices value
     * @throws \InvalidArgumentException
     * @param \Ups_transit\UPStransitStruct\Ups_transitReturnContractServicesType $item
     * @return \Ups_transit\UPStransitStruct\Ups_transitTimeInTransitRequest
     */
    public function addToReturnContractServices(\Ups_transit\UPStransitStruct\Ups_transitReturnContractServicesType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Ups_transit\UPStransitStruct\Ups_transitReturnContractServicesType) {
            throw new \InvalidArgumentException(sprintf('The ReturnContractServices property can only contain items of type \Ups_transit\UPStransitStruct\Ups_transitReturnContractServicesType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ReturnContractServices[] = $item;
        return $this;
    }
}
