<?php

namespace Ups_transit\UPStransitStruct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TransitResponseType UPStransitStruct
 * @package Ups_transit
 * @subpackage Structs
 */
class Ups_transitTransitResponseType extends AbstractStructBase
{
    /**
     * The ShipFrom
     * @var \Ups_transit\UPStransitStruct\Ups_transitResponseShipFromType
     */
    public $ShipFrom;
    /**
     * The ShipTo
     * @var \Ups_transit\UPStransitStruct\Ups_transitResponseShipToType
     */
    public $ShipTo;
    /**
     * The PickupDate
     * @var string
     */
    public $PickupDate;
    /**
     * The ShipmentWeight
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \Ups_transit\UPStransitStruct\Ups_transitShipmentWeightType
     */
    public $ShipmentWeight;
    /**
     * The InvoiceLineTotal
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \Ups_transit\UPStransitStruct\Ups_transitInvoiceLineTotalType
     */
    public $InvoiceLineTotal;
    /**
     * The DocumentsOnlyIndicator
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $DocumentsOnlyIndicator;
    /**
     * The BillType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $BillType;
    /**
     * The MaximumListSize
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $MaximumListSize;
    /**
     * The ServiceSummary
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \Ups_transit\UPStransitStruct\Ups_transitServiceSummaryType[]
     */
    public $ServiceSummary;
    /**
     * The AutoDutyCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $AutoDutyCode;
    /**
     * The Disclaimer
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Disclaimer;
    /**
     * Constructor method for TransitResponseType
     * @uses Ups_transitTransitResponseType::setShipFrom()
     * @uses Ups_transitTransitResponseType::setShipTo()
     * @uses Ups_transitTransitResponseType::setPickupDate()
     * @uses Ups_transitTransitResponseType::setShipmentWeight()
     * @uses Ups_transitTransitResponseType::setInvoiceLineTotal()
     * @uses Ups_transitTransitResponseType::setDocumentsOnlyIndicator()
     * @uses Ups_transitTransitResponseType::setBillType()
     * @uses Ups_transitTransitResponseType::setMaximumListSize()
     * @uses Ups_transitTransitResponseType::setServiceSummary()
     * @uses Ups_transitTransitResponseType::setAutoDutyCode()
     * @uses Ups_transitTransitResponseType::setDisclaimer()
     * @param \Ups_transit\UPStransitStruct\Ups_transitResponseShipFromType $shipFrom
     * @param \Ups_transit\UPStransitStruct\Ups_transitResponseShipToType $shipTo
     * @param string $pickupDate
     * @param \Ups_transit\UPStransitStruct\Ups_transitShipmentWeightType $shipmentWeight
     * @param \Ups_transit\UPStransitStruct\Ups_transitInvoiceLineTotalType $invoiceLineTotal
     * @param string $documentsOnlyIndicator
     * @param string $billType
     * @param string $maximumListSize
     * @param \Ups_transit\UPStransitStruct\Ups_transitServiceSummaryType[] $serviceSummary
     * @param string $autoDutyCode
     * @param string $disclaimer
     */
    public function __construct(\Ups_transit\UPStransitStruct\Ups_transitResponseShipFromType $shipFrom = null, \Ups_transit\UPStransitStruct\Ups_transitResponseShipToType $shipTo = null, $pickupDate = null, \Ups_transit\UPStransitStruct\Ups_transitShipmentWeightType $shipmentWeight = null, \Ups_transit\UPStransitStruct\Ups_transitInvoiceLineTotalType $invoiceLineTotal = null, $documentsOnlyIndicator = null, $billType = null, $maximumListSize = null, array $serviceSummary = array(), $autoDutyCode = null, $disclaimer = null)
    {
        $this
            ->setShipFrom($shipFrom)
            ->setShipTo($shipTo)
            ->setPickupDate($pickupDate)
            ->setShipmentWeight($shipmentWeight)
            ->setInvoiceLineTotal($invoiceLineTotal)
            ->setDocumentsOnlyIndicator($documentsOnlyIndicator)
            ->setBillType($billType)
            ->setMaximumListSize($maximumListSize)
            ->setServiceSummary($serviceSummary)
            ->setAutoDutyCode($autoDutyCode)
            ->setDisclaimer($disclaimer);
    }
    /**
     * Get ShipFrom value
     * @return \Ups_transit\UPStransitStruct\Ups_transitResponseShipFromType|null
     */
    public function getShipFrom()
    {
        return $this->ShipFrom;
    }
    /**
     * Set ShipFrom value
     * @param \Ups_transit\UPStransitStruct\Ups_transitResponseShipFromType $shipFrom
     * @return \Ups_transit\UPStransitStruct\Ups_transitTransitResponseType
     */
    public function setShipFrom(\Ups_transit\UPStransitStruct\Ups_transitResponseShipFromType $shipFrom = null)
    {
        $this->ShipFrom = $shipFrom;
        return $this;
    }
    /**
     * Get ShipTo value
     * @return \Ups_transit\UPStransitStruct\Ups_transitResponseShipToType|null
     */
    public function getShipTo()
    {
        return $this->ShipTo;
    }
    /**
     * Set ShipTo value
     * @param \Ups_transit\UPStransitStruct\Ups_transitResponseShipToType $shipTo
     * @return \Ups_transit\UPStransitStruct\Ups_transitTransitResponseType
     */
    public function setShipTo(\Ups_transit\UPStransitStruct\Ups_transitResponseShipToType $shipTo = null)
    {
        $this->ShipTo = $shipTo;
        return $this;
    }
    /**
     * Get PickupDate value
     * @return string|null
     */
    public function getPickupDate()
    {
        return $this->PickupDate;
    }
    /**
     * Set PickupDate value
     * @param string $pickupDate
     * @return \Ups_transit\UPStransitStruct\Ups_transitTransitResponseType
     */
    public function setPickupDate($pickupDate = null)
    {
        // validation for constraint: string
        if (!is_null($pickupDate) && !is_string($pickupDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pickupDate, true), gettype($pickupDate)), __LINE__);
        }
        $this->PickupDate = $pickupDate;
        return $this;
    }
    /**
     * Get ShipmentWeight value
     * @return \Ups_transit\UPStransitStruct\Ups_transitShipmentWeightType|null
     */
    public function getShipmentWeight()
    {
        return $this->ShipmentWeight;
    }
    /**
     * Set ShipmentWeight value
     * @param \Ups_transit\UPStransitStruct\Ups_transitShipmentWeightType $shipmentWeight
     * @return \Ups_transit\UPStransitStruct\Ups_transitTransitResponseType
     */
    public function setShipmentWeight(\Ups_transit\UPStransitStruct\Ups_transitShipmentWeightType $shipmentWeight = null)
    {
        $this->ShipmentWeight = $shipmentWeight;
        return $this;
    }
    /**
     * Get InvoiceLineTotal value
     * @return \Ups_transit\UPStransitStruct\Ups_transitInvoiceLineTotalType|null
     */
    public function getInvoiceLineTotal()
    {
        return $this->InvoiceLineTotal;
    }
    /**
     * Set InvoiceLineTotal value
     * @param \Ups_transit\UPStransitStruct\Ups_transitInvoiceLineTotalType $invoiceLineTotal
     * @return \Ups_transit\UPStransitStruct\Ups_transitTransitResponseType
     */
    public function setInvoiceLineTotal(\Ups_transit\UPStransitStruct\Ups_transitInvoiceLineTotalType $invoiceLineTotal = null)
    {
        $this->InvoiceLineTotal = $invoiceLineTotal;
        return $this;
    }
    /**
     * Get DocumentsOnlyIndicator value
     * @return string|null
     */
    public function getDocumentsOnlyIndicator()
    {
        return $this->DocumentsOnlyIndicator;
    }
    /**
     * Set DocumentsOnlyIndicator value
     * @param string $documentsOnlyIndicator
     * @return \Ups_transit\UPStransitStruct\Ups_transitTransitResponseType
     */
    public function setDocumentsOnlyIndicator($documentsOnlyIndicator = null)
    {
        // validation for constraint: string
        if (!is_null($documentsOnlyIndicator) && !is_string($documentsOnlyIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($documentsOnlyIndicator, true), gettype($documentsOnlyIndicator)), __LINE__);
        }
        $this->DocumentsOnlyIndicator = $documentsOnlyIndicator;
        return $this;
    }
    /**
     * Get BillType value
     * @return string|null
     */
    public function getBillType()
    {
        return $this->BillType;
    }
    /**
     * Set BillType value
     * @param string $billType
     * @return \Ups_transit\UPStransitStruct\Ups_transitTransitResponseType
     */
    public function setBillType($billType = null)
    {
        // validation for constraint: string
        if (!is_null($billType) && !is_string($billType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($billType, true), gettype($billType)), __LINE__);
        }
        $this->BillType = $billType;
        return $this;
    }
    /**
     * Get MaximumListSize value
     * @return string|null
     */
    public function getMaximumListSize()
    {
        return $this->MaximumListSize;
    }
    /**
     * Set MaximumListSize value
     * @param string $maximumListSize
     * @return \Ups_transit\UPStransitStruct\Ups_transitTransitResponseType
     */
    public function setMaximumListSize($maximumListSize = null)
    {
        // validation for constraint: string
        if (!is_null($maximumListSize) && !is_string($maximumListSize)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($maximumListSize, true), gettype($maximumListSize)), __LINE__);
        }
        $this->MaximumListSize = $maximumListSize;
        return $this;
    }
    /**
     * Get ServiceSummary value
     * @return \Ups_transit\UPStransitStruct\Ups_transitServiceSummaryType[]|null
     */
    public function getServiceSummary()
    {
        return $this->ServiceSummary;
    }
    /**
     * This method is responsible for validating the values passed to the setServiceSummary method
     * This method is willingly generated in order to preserve the one-line inline validation within the setServiceSummary method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateServiceSummaryForArrayConstraintsFromSetServiceSummary(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $transitResponseTypeServiceSummaryItem) {
            // validation for constraint: itemType
            if (!$transitResponseTypeServiceSummaryItem instanceof \Ups_transit\UPStransitStruct\Ups_transitServiceSummaryType) {
                $invalidValues[] = is_object($transitResponseTypeServiceSummaryItem) ? get_class($transitResponseTypeServiceSummaryItem) : sprintf('%s(%s)', gettype($transitResponseTypeServiceSummaryItem), var_export($transitResponseTypeServiceSummaryItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ServiceSummary property can only contain items of type \Ups_transit\UPStransitStruct\Ups_transitServiceSummaryType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ServiceSummary value
     * @throws \InvalidArgumentException
     * @param \Ups_transit\UPStransitStruct\Ups_transitServiceSummaryType[] $serviceSummary
     * @return \Ups_transit\UPStransitStruct\Ups_transitTransitResponseType
     */
    public function setServiceSummary(array $serviceSummary = array())
    {
        // validation for constraint: array
        if ('' !== ($serviceSummaryArrayErrorMessage = self::validateServiceSummaryForArrayConstraintsFromSetServiceSummary($serviceSummary))) {
            throw new \InvalidArgumentException($serviceSummaryArrayErrorMessage, __LINE__);
        }
        $this->ServiceSummary = $serviceSummary;
        return $this;
    }
    /**
     * Add item to ServiceSummary value
     * @throws \InvalidArgumentException
     * @param \Ups_transit\UPStransitStruct\Ups_transitServiceSummaryType $item
     * @return \Ups_transit\UPStransitStruct\Ups_transitTransitResponseType
     */
    public function addToServiceSummary(\Ups_transit\UPStransitStruct\Ups_transitServiceSummaryType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Ups_transit\UPStransitStruct\Ups_transitServiceSummaryType) {
            throw new \InvalidArgumentException(sprintf('The ServiceSummary property can only contain items of type \Ups_transit\UPStransitStruct\Ups_transitServiceSummaryType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ServiceSummary[] = $item;
        return $this;
    }
    /**
     * Get AutoDutyCode value
     * @return string|null
     */
    public function getAutoDutyCode()
    {
        return $this->AutoDutyCode;
    }
    /**
     * Set AutoDutyCode value
     * @param string $autoDutyCode
     * @return \Ups_transit\UPStransitStruct\Ups_transitTransitResponseType
     */
    public function setAutoDutyCode($autoDutyCode = null)
    {
        // validation for constraint: string
        if (!is_null($autoDutyCode) && !is_string($autoDutyCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($autoDutyCode, true), gettype($autoDutyCode)), __LINE__);
        }
        $this->AutoDutyCode = $autoDutyCode;
        return $this;
    }
    /**
     * Get Disclaimer value
     * @return string|null
     */
    public function getDisclaimer()
    {
        return $this->Disclaimer;
    }
    /**
     * Set Disclaimer value
     * @param string $disclaimer
     * @return \Ups_transit\UPStransitStruct\Ups_transitTransitResponseType
     */
    public function setDisclaimer($disclaimer = null)
    {
        // validation for constraint: string
        if (!is_null($disclaimer) && !is_string($disclaimer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($disclaimer, true), gettype($disclaimer)), __LINE__);
        }
        $this->Disclaimer = $disclaimer;
        return $this;
    }
}
