<?php

namespace Ups_transit\UPStransitStruct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ErrorDetailType UPStransitStruct
 * @package Ups_transit
 * @subpackage Structs
 */
class Ups_transitErrorDetailType extends AbstractStructBase
{
    /**
     * The Severity
     * @var string
     */
    public $Severity;
    /**
     * The PrimaryErrorCode
     * @var \Ups_transit\UPStransitStruct\Ups_transitCodeType
     */
    public $PrimaryErrorCode;
    /**
     * The MinimumRetrySeconds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $MinimumRetrySeconds;
    /**
     * The Location
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \Ups_transit\UPStransitStruct\Ups_transitLocationType
     */
    public $Location;
    /**
     * The SubErrorCode
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Ups_transit\UPStransitStruct\Ups_transitCodeType[]
     */
    public $SubErrorCode;
    /**
     * The AdditionalInformation
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Ups_transit\UPStransitStruct\Ups_transitAdditionalInfoType[]
     */
    public $AdditionalInformation;
    /**
     * The ElementLevelInformation
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \Ups_transit\UPStransitStruct\Ups_transitElementLevelInformationType
     */
    public $ElementLevelInformation;
    /**
     * Constructor method for ErrorDetailType
     * @uses Ups_transitErrorDetailType::setSeverity()
     * @uses Ups_transitErrorDetailType::setPrimaryErrorCode()
     * @uses Ups_transitErrorDetailType::setMinimumRetrySeconds()
     * @uses Ups_transitErrorDetailType::setLocation()
     * @uses Ups_transitErrorDetailType::setSubErrorCode()
     * @uses Ups_transitErrorDetailType::setAdditionalInformation()
     * @uses Ups_transitErrorDetailType::setElementLevelInformation()
     * @param string $severity
     * @param \Ups_transit\UPStransitStruct\Ups_transitCodeType $primaryErrorCode
     * @param string $minimumRetrySeconds
     * @param \Ups_transit\UPStransitStruct\Ups_transitLocationType $location
     * @param \Ups_transit\UPStransitStruct\Ups_transitCodeType[] $subErrorCode
     * @param \Ups_transit\UPStransitStruct\Ups_transitAdditionalInfoType[] $additionalInformation
     * @param \Ups_transit\UPStransitStruct\Ups_transitElementLevelInformationType $elementLevelInformation
     */
    public function __construct($severity = null, \Ups_transit\UPStransitStruct\Ups_transitCodeType $primaryErrorCode = null, $minimumRetrySeconds = null, \Ups_transit\UPStransitStruct\Ups_transitLocationType $location = null, array $subErrorCode = array(), array $additionalInformation = array(), \Ups_transit\UPStransitStruct\Ups_transitElementLevelInformationType $elementLevelInformation = null)
    {
        $this
            ->setSeverity($severity)
            ->setPrimaryErrorCode($primaryErrorCode)
            ->setMinimumRetrySeconds($minimumRetrySeconds)
            ->setLocation($location)
            ->setSubErrorCode($subErrorCode)
            ->setAdditionalInformation($additionalInformation)
            ->setElementLevelInformation($elementLevelInformation);
    }
    /**
     * Get Severity value
     * @return string|null
     */
    public function getSeverity()
    {
        return $this->Severity;
    }
    /**
     * Set Severity value
     * @param string $severity
     * @return \Ups_transit\UPStransitStruct\Ups_transitErrorDetailType
     */
    public function setSeverity($severity = null)
    {
        // validation for constraint: string
        if (!is_null($severity) && !is_string($severity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($severity, true), gettype($severity)), __LINE__);
        }
        $this->Severity = $severity;
        return $this;
    }
    /**
     * Get PrimaryErrorCode value
     * @return \Ups_transit\UPStransitStruct\Ups_transitCodeType|null
     */
    public function getPrimaryErrorCode()
    {
        return $this->PrimaryErrorCode;
    }
    /**
     * Set PrimaryErrorCode value
     * @param \Ups_transit\UPStransitStruct\Ups_transitCodeType $primaryErrorCode
     * @return \Ups_transit\UPStransitStruct\Ups_transitErrorDetailType
     */
    public function setPrimaryErrorCode(\Ups_transit\UPStransitStruct\Ups_transitCodeType $primaryErrorCode = null)
    {
        $this->PrimaryErrorCode = $primaryErrorCode;
        return $this;
    }
    /**
     * Get MinimumRetrySeconds value
     * @return string|null
     */
    public function getMinimumRetrySeconds()
    {
        return $this->MinimumRetrySeconds;
    }
    /**
     * Set MinimumRetrySeconds value
     * @param string $minimumRetrySeconds
     * @return \Ups_transit\UPStransitStruct\Ups_transitErrorDetailType
     */
    public function setMinimumRetrySeconds($minimumRetrySeconds = null)
    {
        // validation for constraint: string
        if (!is_null($minimumRetrySeconds) && !is_string($minimumRetrySeconds)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($minimumRetrySeconds, true), gettype($minimumRetrySeconds)), __LINE__);
        }
        $this->MinimumRetrySeconds = $minimumRetrySeconds;
        return $this;
    }
    /**
     * Get Location value
     * @return \Ups_transit\UPStransitStruct\Ups_transitLocationType|null
     */
    public function getLocation()
    {
        return $this->Location;
    }
    /**
     * Set Location value
     * @param \Ups_transit\UPStransitStruct\Ups_transitLocationType $location
     * @return \Ups_transit\UPStransitStruct\Ups_transitErrorDetailType
     */
    public function setLocation(\Ups_transit\UPStransitStruct\Ups_transitLocationType $location = null)
    {
        $this->Location = $location;
        return $this;
    }
    /**
     * Get SubErrorCode value
     * @return \Ups_transit\UPStransitStruct\Ups_transitCodeType[]|null
     */
    public function getSubErrorCode()
    {
        return $this->SubErrorCode;
    }
    /**
     * This method is responsible for validating the values passed to the setSubErrorCode method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSubErrorCode method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSubErrorCodeForArrayConstraintsFromSetSubErrorCode(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $errorDetailTypeSubErrorCodeItem) {
            // validation for constraint: itemType
            if (!$errorDetailTypeSubErrorCodeItem instanceof \Ups_transit\UPStransitStruct\Ups_transitCodeType) {
                $invalidValues[] = is_object($errorDetailTypeSubErrorCodeItem) ? get_class($errorDetailTypeSubErrorCodeItem) : sprintf('%s(%s)', gettype($errorDetailTypeSubErrorCodeItem), var_export($errorDetailTypeSubErrorCodeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The SubErrorCode property can only contain items of type \Ups_transit\UPStransitStruct\Ups_transitCodeType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set SubErrorCode value
     * @throws \InvalidArgumentException
     * @param \Ups_transit\UPStransitStruct\Ups_transitCodeType[] $subErrorCode
     * @return \Ups_transit\UPStransitStruct\Ups_transitErrorDetailType
     */
    public function setSubErrorCode(array $subErrorCode = array())
    {
        // validation for constraint: array
        if ('' !== ($subErrorCodeArrayErrorMessage = self::validateSubErrorCodeForArrayConstraintsFromSetSubErrorCode($subErrorCode))) {
            throw new \InvalidArgumentException($subErrorCodeArrayErrorMessage, __LINE__);
        }
        $this->SubErrorCode = $subErrorCode;
        return $this;
    }
    /**
     * Add item to SubErrorCode value
     * @throws \InvalidArgumentException
     * @param \Ups_transit\UPStransitStruct\Ups_transitCodeType $item
     * @return \Ups_transit\UPStransitStruct\Ups_transitErrorDetailType
     */
    public function addToSubErrorCode(\Ups_transit\UPStransitStruct\Ups_transitCodeType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Ups_transit\UPStransitStruct\Ups_transitCodeType) {
            throw new \InvalidArgumentException(sprintf('The SubErrorCode property can only contain items of type \Ups_transit\UPStransitStruct\Ups_transitCodeType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->SubErrorCode[] = $item;
        return $this;
    }
    /**
     * Get AdditionalInformation value
     * @return \Ups_transit\UPStransitStruct\Ups_transitAdditionalInfoType[]|null
     */
    public function getAdditionalInformation()
    {
        return $this->AdditionalInformation;
    }
    /**
     * This method is responsible for validating the values passed to the setAdditionalInformation method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAdditionalInformation method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAdditionalInformationForArrayConstraintsFromSetAdditionalInformation(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $errorDetailTypeAdditionalInformationItem) {
            // validation for constraint: itemType
            if (!$errorDetailTypeAdditionalInformationItem instanceof \Ups_transit\UPStransitStruct\Ups_transitAdditionalInfoType) {
                $invalidValues[] = is_object($errorDetailTypeAdditionalInformationItem) ? get_class($errorDetailTypeAdditionalInformationItem) : sprintf('%s(%s)', gettype($errorDetailTypeAdditionalInformationItem), var_export($errorDetailTypeAdditionalInformationItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The AdditionalInformation property can only contain items of type \Ups_transit\UPStransitStruct\Ups_transitAdditionalInfoType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set AdditionalInformation value
     * @throws \InvalidArgumentException
     * @param \Ups_transit\UPStransitStruct\Ups_transitAdditionalInfoType[] $additionalInformation
     * @return \Ups_transit\UPStransitStruct\Ups_transitErrorDetailType
     */
    public function setAdditionalInformation(array $additionalInformation = array())
    {
        // validation for constraint: array
        if ('' !== ($additionalInformationArrayErrorMessage = self::validateAdditionalInformationForArrayConstraintsFromSetAdditionalInformation($additionalInformation))) {
            throw new \InvalidArgumentException($additionalInformationArrayErrorMessage, __LINE__);
        }
        $this->AdditionalInformation = $additionalInformation;
        return $this;
    }
    /**
     * Add item to AdditionalInformation value
     * @throws \InvalidArgumentException
     * @param \Ups_transit\UPStransitStruct\Ups_transitAdditionalInfoType $item
     * @return \Ups_transit\UPStransitStruct\Ups_transitErrorDetailType
     */
    public function addToAdditionalInformation(\Ups_transit\UPStransitStruct\Ups_transitAdditionalInfoType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Ups_transit\UPStransitStruct\Ups_transitAdditionalInfoType) {
            throw new \InvalidArgumentException(sprintf('The AdditionalInformation property can only contain items of type \Ups_transit\UPStransitStruct\Ups_transitAdditionalInfoType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->AdditionalInformation[] = $item;
        return $this;
    }
    /**
     * Get ElementLevelInformation value
     * @return \Ups_transit\UPStransitStruct\Ups_transitElementLevelInformationType|null
     */
    public function getElementLevelInformation()
    {
        return $this->ElementLevelInformation;
    }
    /**
     * Set ElementLevelInformation value
     * @param \Ups_transit\UPStransitStruct\Ups_transitElementLevelInformationType $elementLevelInformation
     * @return \Ups_transit\UPStransitStruct\Ups_transitErrorDetailType
     */
    public function setElementLevelInformation(\Ups_transit\UPStransitStruct\Ups_transitElementLevelInformationType $elementLevelInformation = null)
    {
        $this->ElementLevelInformation = $elementLevelInformation;
        return $this;
    }
}
