<?php

namespace Ups_transit\UPStransitStruct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ResponseType UPStransitStruct
 * @package Ups_transit
 * @subpackage Structs
 */
class Ups_transitResponseType extends AbstractStructBase
{
    /**
     * The ResponseStatus
     * @var \Ups_transit\UPStransitStruct\Ups_transitCodeDescriptionType
     */
    public $ResponseStatus;
    /**
     * The Alert
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Ups_transit\UPStransitStruct\Ups_transitCodeDescriptionType[]
     */
    public $Alert;
    /**
     * The AlertDetail
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Ups_transit\UPStransitStruct\Ups_transitDetailType[]
     */
    public $AlertDetail;
    /**
     * The TransactionReference
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \Ups_transit\UPStransitStruct\Ups_transitTransactionReferenceType
     */
    public $TransactionReference;
    /**
     * Constructor method for ResponseType
     * @uses Ups_transitResponseType::setResponseStatus()
     * @uses Ups_transitResponseType::setAlert()
     * @uses Ups_transitResponseType::setAlertDetail()
     * @uses Ups_transitResponseType::setTransactionReference()
     * @param \Ups_transit\UPStransitStruct\Ups_transitCodeDescriptionType $responseStatus
     * @param \Ups_transit\UPStransitStruct\Ups_transitCodeDescriptionType[] $alert
     * @param \Ups_transit\UPStransitStruct\Ups_transitDetailType[] $alertDetail
     * @param \Ups_transit\UPStransitStruct\Ups_transitTransactionReferenceType $transactionReference
     */
    public function __construct(\Ups_transit\UPStransitStruct\Ups_transitCodeDescriptionType $responseStatus = null, array $alert = array(), array $alertDetail = array(), \Ups_transit\UPStransitStruct\Ups_transitTransactionReferenceType $transactionReference = null)
    {
        $this
            ->setResponseStatus($responseStatus)
            ->setAlert($alert)
            ->setAlertDetail($alertDetail)
            ->setTransactionReference($transactionReference);
    }
    /**
     * Get ResponseStatus value
     * @return \Ups_transit\UPStransitStruct\Ups_transitCodeDescriptionType|null
     */
    public function getResponseStatus()
    {
        return $this->ResponseStatus;
    }
    /**
     * Set ResponseStatus value
     * @param \Ups_transit\UPStransitStruct\Ups_transitCodeDescriptionType $responseStatus
     * @return \Ups_transit\UPStransitStruct\Ups_transitResponseType
     */
    public function setResponseStatus(\Ups_transit\UPStransitStruct\Ups_transitCodeDescriptionType $responseStatus = null)
    {
        $this->ResponseStatus = $responseStatus;
        return $this;
    }
    /**
     * Get Alert value
     * @return \Ups_transit\UPStransitStruct\Ups_transitCodeDescriptionType[]|null
     */
    public function getAlert()
    {
        return $this->Alert;
    }
    /**
     * This method is responsible for validating the values passed to the setAlert method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAlert method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAlertForArrayConstraintsFromSetAlert(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $responseTypeAlertItem) {
            // validation for constraint: itemType
            if (!$responseTypeAlertItem instanceof \Ups_transit\UPStransitStruct\Ups_transitCodeDescriptionType) {
                $invalidValues[] = is_object($responseTypeAlertItem) ? get_class($responseTypeAlertItem) : sprintf('%s(%s)', gettype($responseTypeAlertItem), var_export($responseTypeAlertItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Alert property can only contain items of type \Ups_transit\UPStransitStruct\Ups_transitCodeDescriptionType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Alert value
     * @throws \InvalidArgumentException
     * @param \Ups_transit\UPStransitStruct\Ups_transitCodeDescriptionType[] $alert
     * @return \Ups_transit\UPStransitStruct\Ups_transitResponseType
     */
    public function setAlert(array $alert = array())
    {
        // validation for constraint: array
        if ('' !== ($alertArrayErrorMessage = self::validateAlertForArrayConstraintsFromSetAlert($alert))) {
            throw new \InvalidArgumentException($alertArrayErrorMessage, __LINE__);
        }
        $this->Alert = $alert;
        return $this;
    }
    /**
     * Add item to Alert value
     * @throws \InvalidArgumentException
     * @param \Ups_transit\UPStransitStruct\Ups_transitCodeDescriptionType $item
     * @return \Ups_transit\UPStransitStruct\Ups_transitResponseType
     */
    public function addToAlert(\Ups_transit\UPStransitStruct\Ups_transitCodeDescriptionType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Ups_transit\UPStransitStruct\Ups_transitCodeDescriptionType) {
            throw new \InvalidArgumentException(sprintf('The Alert property can only contain items of type \Ups_transit\UPStransitStruct\Ups_transitCodeDescriptionType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Alert[] = $item;
        return $this;
    }
    /**
     * Get AlertDetail value
     * @return \Ups_transit\UPStransitStruct\Ups_transitDetailType[]|null
     */
    public function getAlertDetail()
    {
        return $this->AlertDetail;
    }
    /**
     * This method is responsible for validating the values passed to the setAlertDetail method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAlertDetail method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAlertDetailForArrayConstraintsFromSetAlertDetail(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $responseTypeAlertDetailItem) {
            // validation for constraint: itemType
            if (!$responseTypeAlertDetailItem instanceof \Ups_transit\UPStransitStruct\Ups_transitDetailType) {
                $invalidValues[] = is_object($responseTypeAlertDetailItem) ? get_class($responseTypeAlertDetailItem) : sprintf('%s(%s)', gettype($responseTypeAlertDetailItem), var_export($responseTypeAlertDetailItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The AlertDetail property can only contain items of type \Ups_transit\UPStransitStruct\Ups_transitDetailType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set AlertDetail value
     * @throws \InvalidArgumentException
     * @param \Ups_transit\UPStransitStruct\Ups_transitDetailType[] $alertDetail
     * @return \Ups_transit\UPStransitStruct\Ups_transitResponseType
     */
    public function setAlertDetail(array $alertDetail = array())
    {
        // validation for constraint: array
        if ('' !== ($alertDetailArrayErrorMessage = self::validateAlertDetailForArrayConstraintsFromSetAlertDetail($alertDetail))) {
            throw new \InvalidArgumentException($alertDetailArrayErrorMessage, __LINE__);
        }
        $this->AlertDetail = $alertDetail;
        return $this;
    }
    /**
     * Add item to AlertDetail value
     * @throws \InvalidArgumentException
     * @param \Ups_transit\UPStransitStruct\Ups_transitDetailType $item
     * @return \Ups_transit\UPStransitStruct\Ups_transitResponseType
     */
    public function addToAlertDetail(\Ups_transit\UPStransitStruct\Ups_transitDetailType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Ups_transit\UPStransitStruct\Ups_transitDetailType) {
            throw new \InvalidArgumentException(sprintf('The AlertDetail property can only contain items of type \Ups_transit\UPStransitStruct\Ups_transitDetailType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->AlertDetail[] = $item;
        return $this;
    }
    /**
     * Get TransactionReference value
     * @return \Ups_transit\UPStransitStruct\Ups_transitTransactionReferenceType|null
     */
    public function getTransactionReference()
    {
        return $this->TransactionReference;
    }
    /**
     * Set TransactionReference value
     * @param \Ups_transit\UPStransitStruct\Ups_transitTransactionReferenceType $transactionReference
     * @return \Ups_transit\UPStransitStruct\Ups_transitResponseType
     */
    public function setTransactionReference(\Ups_transit\UPStransitStruct\Ups_transitTransactionReferenceType $transactionReference = null)
    {
        $this->TransactionReference = $transactionReference;
        return $this;
    }
}
