<?php

namespace Ups_transit\UPStransitService;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Process UPStransitService
 * @package Ups_transit
 * @subpackage Services
 */
class Ups_transitProcess extends AbstractSoapClientBase
{
    /**
     * Sets the UPSSecurity SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \Ups_transit\UPStransitStruct\Ups_transitUPSSecurity $uPSSecurity
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderUPSSecurity(\Ups_transit\UPStransitStruct\Ups_transitUPSSecurity $uPSSecurity, $nameSpace = 'http://www.ups.com/XMLSchema/XOLTWS/UPSS/v1.0', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'UPSSecurity', $uPSSecurity, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named ProcessTimeInTransit
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: UPSSecurity
     * - SOAPHeaderNamespaces: http://www.ups.com/XMLSchema/XOLTWS/UPSS/v1.0
     * - SOAPHeaderTypes: \Ups_transit\UPStransitStruct\Ups_transitUPSSecurity
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Ups_transit\UPStransitStruct\Ups_transitTimeInTransitRequest $body
     * @return \Ups_transit\UPStransitStruct\Ups_transitTimeInTransitResponse|bool
     */
    public function ProcessTimeInTransit(\Ups_transit\UPStransitStruct\Ups_transitTimeInTransitRequest $body)
    {
        try {
            $this->setResult($this->getSoapClient()->ProcessTimeInTransit($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \Ups_transit\UPStransitStruct\Ups_transitTimeInTransitResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
