<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for WebShipment StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:WebShipment
 * @subpackage Structs
 */
class WebShipment extends AbstractStructBase
{
    /**
     * The Date
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Date;
    /**
     * The Number
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Number;
    /**
     * The Shipment
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Shipment;
    /**
     * The Sum
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $Sum;
    /**
     * Constructor method for WebShipment
     * @uses WebShipment::setDate()
     * @uses WebShipment::setNumber()
     * @uses WebShipment::setShipment()
     * @uses WebShipment::setSum()
     * @param string $date
     * @param int $number
     * @param string $shipment
     * @param float $sum
     */
    public function __construct($date = null, $number = null, $shipment = null, $sum = null)
    {
        $this
            ->setDate($date)
            ->setNumber($number)
            ->setShipment($shipment)
            ->setSum($sum);
    }
    /**
     * Get Date value
     * @return string|null
     */
    public function getDate()
    {
        return $this->Date;
    }
    /**
     * Set Date value
     * @param string $date
     * @return \StructType\WebShipment
     */
    public function setDate($date = null)
    {
        // validation for constraint: string
        if (!is_null($date) && !is_string($date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($date, true), gettype($date)), __LINE__);
        }
        $this->Date = $date;
        return $this;
    }
    /**
     * Get Number value
     * @return int|null
     */
    public function getNumber()
    {
        return $this->Number;
    }
    /**
     * Set Number value
     * @param int $number
     * @return \StructType\WebShipment
     */
    public function setNumber($number = null)
    {
        // validation for constraint: int
        if (!is_null($number) && !(is_int($number) || ctype_digit($number))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($number, true), gettype($number)), __LINE__);
        }
        $this->Number = $number;
        return $this;
    }
    /**
     * Get Shipment value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getShipment()
    {
        return isset($this->Shipment) ? $this->Shipment : null;
    }
    /**
     * Set Shipment value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $shipment
     * @return \StructType\WebShipment
     */
    public function setShipment($shipment = null)
    {
        // validation for constraint: string
        if (!is_null($shipment) && !is_string($shipment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shipment, true), gettype($shipment)), __LINE__);
        }
        if (is_null($shipment) || (is_array($shipment) && empty($shipment))) {
            unset($this->Shipment);
        } else {
            $this->Shipment = $shipment;
        }
        return $this;
    }
    /**
     * Get Sum value
     * @return float|null
     */
    public function getSum()
    {
        return $this->Sum;
    }
    /**
     * Set Sum value
     * @param float $sum
     * @return \StructType\WebShipment
     */
    public function setSum($sum = null)
    {
        // validation for constraint: float
        if (!is_null($sum) && !(is_float($sum) || is_numeric($sum))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($sum, true), gettype($sum)), __LINE__);
        }
        $this->Sum = $sum;
        return $this;
    }
}
