<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Get ServiceType
 * @subpackage Services
 */
class Get extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named GetShipmentList
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetShipmentList $parameters
     * @return \StructType\GetShipmentListResponse|bool
     */
    public function GetShipmentList(\StructType\GetShipmentList $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetShipmentList($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetShipment
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetShipment $parameters
     * @return \StructType\GetShipmentResponse|bool
     */
    public function GetShipment(\StructType\GetShipment $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetShipment($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\GetShipmentListResponse|\StructType\GetShipmentResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
