<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfWebShipment ArrayType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfWebShipment
 * @subpackage Arrays
 */
class ArrayOfWebShipment extends AbstractStructArrayBase
{
    /**
     * The WebShipment
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\WebShipment[]
     */
    public $WebShipment;
    /**
     * Constructor method for ArrayOfWebShipment
     * @uses ArrayOfWebShipment::setWebShipment()
     * @param \StructType\WebShipment[] $webShipment
     */
    public function __construct(array $webShipment = array())
    {
        $this
            ->setWebShipment($webShipment);
    }
    /**
     * Get WebShipment value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\WebShipment[]|null
     */
    public function getWebShipment()
    {
        return isset($this->WebShipment) ? $this->WebShipment : null;
    }
    /**
     * This method is responsible for validating the values passed to the setWebShipment method
     * This method is willingly generated in order to preserve the one-line inline validation within the setWebShipment method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateWebShipmentForArrayConstraintsFromSetWebShipment(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfWebShipmentWebShipmentItem) {
            // validation for constraint: itemType
            if (!$arrayOfWebShipmentWebShipmentItem instanceof \StructType\WebShipment) {
                $invalidValues[] = is_object($arrayOfWebShipmentWebShipmentItem) ? get_class($arrayOfWebShipmentWebShipmentItem) : sprintf('%s(%s)', gettype($arrayOfWebShipmentWebShipmentItem), var_export($arrayOfWebShipmentWebShipmentItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The WebShipment property can only contain items of type \StructType\WebShipment, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set WebShipment value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\WebShipment[] $webShipment
     * @return \ArrayType\ArrayOfWebShipment
     */
    public function setWebShipment(array $webShipment = array())
    {
        // validation for constraint: array
        if ('' !== ($webShipmentArrayErrorMessage = self::validateWebShipmentForArrayConstraintsFromSetWebShipment($webShipment))) {
            throw new \InvalidArgumentException($webShipmentArrayErrorMessage, __LINE__);
        }
        if (is_null($webShipment) || (is_array($webShipment) && empty($webShipment))) {
            unset($this->WebShipment);
        } else {
            $this->WebShipment = $webShipment;
        }
        return $this;
    }
    /**
     * Add item to WebShipment value
     * @throws \InvalidArgumentException
     * @param \StructType\WebShipment $item
     * @return \ArrayType\ArrayOfWebShipment
     */
    public function addToWebShipment(\StructType\WebShipment $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\WebShipment) {
            throw new \InvalidArgumentException(sprintf('The WebShipment property can only contain items of type \StructType\WebShipment, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->WebShipment[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\WebShipment|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\WebShipment|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\WebShipment|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\WebShipment|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\WebShipment|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string WebShipment
     */
    public function getAttributeName()
    {
        return 'WebShipment';
    }
}
