<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the first needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientBase class (each generated ServiceType class extends this class)
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'main.wsdl',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc...
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'main.wsdl',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => \App\API\SOAP\ClassMap::get(),
);
/**
 * Samples for Get ServiceType
 */
$get = new \App\API\SOAP\ServiceType\Get($options);
/**
 * Sample call for GetList operation/method
 */
if ($get->GetList(new \App\API\SOAP\StructType\GetList()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for Get operation/method
 */
if ($get->Get(new \App\API\SOAP\StructType\Get()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetCustomFieldSchema operation/method
 */
if ($get->GetCustomFieldSchema(new \App\API\SOAP\StructType\GetCustomFieldSchema()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetProcessStatus operation/method
 */
if ($get->GetProcessStatus(new \App\API\SOAP\StructType\GetProcessStatus()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetFiles operation/method
 */
if ($get->GetFiles(new \App\API\SOAP\StructType\GetFiles()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Samples for Put ServiceType
 */
$put = new \App\API\SOAP\ServiceType\Put($options);
/**
 * Sample call for Put operation/method
 */
if ($put->Put(new \App\API\SOAP\StructType\Put()) !== false) {
    print_r($put->getResult());
} else {
    print_r($put->getLastError());
}
/**
 * Sample call for PutFiles operation/method
 */
if ($put->PutFiles(new \App\API\SOAP\StructType\PutFiles()) !== false) {
    print_r($put->getResult());
} else {
    print_r($put->getLastError());
}
/**
 * Samples for Sanity ServiceType
 */
$sanity = new \App\API\SOAP\ServiceType\Sanity($options);
/**
 * Sample call for SanityCheck operation/method
 */
if ($sanity->SanityCheck(new \App\API\SOAP\StructType\SanityCheck()) !== false) {
    print_r($sanity->getResult());
} else {
    print_r($sanity->getLastError());
}
/**
 * Samples for Login ServiceType
 */
$login = new \App\API\SOAP\ServiceType\Login($options);
/**
 * Sample call for Login operation/method
 */
if ($login->Login(new \App\API\SOAP\StructType\Login()) !== false) {
    print_r($login->getResult());
} else {
    print_r($login->getLastError());
}
/**
 * Samples for Logout ServiceType
 */
$logout = new \App\API\SOAP\ServiceType\Logout($options);
/**
 * Sample call for Logout operation/method
 */
if ($logout->Logout(new \App\API\SOAP\StructType\Logout()) !== false) {
    print_r($logout->getResult());
} else {
    print_r($logout->getLastError());
}
/**
 * Samples for Set ServiceType
 */
$set = new \App\API\SOAP\ServiceType\Set($options);
/**
 * Sample call for SetBusinessDate operation/method
 */
if ($set->SetBusinessDate(new \App\API\SOAP\StructType\SetBusinessDate()) !== false) {
    print_r($set->getResult());
} else {
    print_r($set->getLastError());
}
/**
 * Samples for Delete ServiceType
 */
$delete = new \App\API\SOAP\ServiceType\Delete($options);
/**
 * Sample call for Delete operation/method
 */
if ($delete->Delete(new \App\API\SOAP\StructType\Delete()) !== false) {
    print_r($delete->getResult());
} else {
    print_r($delete->getLastError());
}
/**
 * Samples for Invoke ServiceType
 */
$invoke = new \App\API\SOAP\ServiceType\Invoke($options);
/**
 * Sample call for Invoke operation/method
 */
if ($invoke->Invoke(new \App\API\SOAP\StructType\Invoke()) !== false) {
    print_r($invoke->getResult());
} else {
    print_r($invoke->getLastError());
}
