<?php

namespace App\API\SOAP\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for VendorPricesInquiry StructType
 * @subpackage Structs
 */
class VendorPricesInquiry extends Entity
{
    /**
     * The InventoryID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $InventoryID;
    /**
     * The ItemClass
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $ItemClass;
    /**
     * The ProductManager
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $ProductManager;
    /**
     * The ProductWorkgroup
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $ProductWorkgroup;
    /**
     * The Vendor
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $Vendor;
    /**
     * The VendorPriceDetails
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\VendorPriceDetails
     */
    public $VendorPriceDetails;
    /**
     * Constructor method for VendorPricesInquiry
     * @uses VendorPricesInquiry::setInventoryID()
     * @uses VendorPricesInquiry::setItemClass()
     * @uses VendorPricesInquiry::setProductManager()
     * @uses VendorPricesInquiry::setProductWorkgroup()
     * @uses VendorPricesInquiry::setVendor()
     * @uses VendorPricesInquiry::setVendorPriceDetails()
     * @param \App\API\SOAP\StructType\StringValue $inventoryID
     * @param \App\API\SOAP\StructType\StringValue $itemClass
     * @param \App\API\SOAP\StructType\StringValue $productManager
     * @param \App\API\SOAP\StructType\StringValue $productWorkgroup
     * @param \App\API\SOAP\StructType\StringValue $vendor
     * @param \App\API\SOAP\StructType\VendorPriceDetails $vendorPriceDetails
     */
    public function __construct(\App\API\SOAP\StructType\StringValue $inventoryID = null, \App\API\SOAP\StructType\StringValue $itemClass = null, \App\API\SOAP\StructType\StringValue $productManager = null, \App\API\SOAP\StructType\StringValue $productWorkgroup = null, \App\API\SOAP\StructType\StringValue $vendor = null, \App\API\SOAP\StructType\VendorPriceDetails $vendorPriceDetails = null)
    {
        $this
            ->setInventoryID($inventoryID)
            ->setItemClass($itemClass)
            ->setProductManager($productManager)
            ->setProductWorkgroup($productWorkgroup)
            ->setVendor($vendor)
            ->setVendorPriceDetails($vendorPriceDetails);
    }
    /**
     * Get InventoryID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getInventoryID()
    {
        return isset($this->InventoryID) ? $this->InventoryID : null;
    }
    /**
     * Set InventoryID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $inventoryID
     * @return \App\API\SOAP\StructType\VendorPricesInquiry
     */
    public function setInventoryID(\App\API\SOAP\StructType\StringValue $inventoryID = null)
    {
        if (is_null($inventoryID) || (is_array($inventoryID) && empty($inventoryID))) {
            unset($this->InventoryID);
        } else {
            $this->InventoryID = $inventoryID;
        }
        return $this;
    }
    /**
     * Get ItemClass value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getItemClass()
    {
        return isset($this->ItemClass) ? $this->ItemClass : null;
    }
    /**
     * Set ItemClass value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $itemClass
     * @return \App\API\SOAP\StructType\VendorPricesInquiry
     */
    public function setItemClass(\App\API\SOAP\StructType\StringValue $itemClass = null)
    {
        if (is_null($itemClass) || (is_array($itemClass) && empty($itemClass))) {
            unset($this->ItemClass);
        } else {
            $this->ItemClass = $itemClass;
        }
        return $this;
    }
    /**
     * Get ProductManager value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getProductManager()
    {
        return isset($this->ProductManager) ? $this->ProductManager : null;
    }
    /**
     * Set ProductManager value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $productManager
     * @return \App\API\SOAP\StructType\VendorPricesInquiry
     */
    public function setProductManager(\App\API\SOAP\StructType\StringValue $productManager = null)
    {
        if (is_null($productManager) || (is_array($productManager) && empty($productManager))) {
            unset($this->ProductManager);
        } else {
            $this->ProductManager = $productManager;
        }
        return $this;
    }
    /**
     * Get ProductWorkgroup value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getProductWorkgroup()
    {
        return isset($this->ProductWorkgroup) ? $this->ProductWorkgroup : null;
    }
    /**
     * Set ProductWorkgroup value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $productWorkgroup
     * @return \App\API\SOAP\StructType\VendorPricesInquiry
     */
    public function setProductWorkgroup(\App\API\SOAP\StructType\StringValue $productWorkgroup = null)
    {
        if (is_null($productWorkgroup) || (is_array($productWorkgroup) && empty($productWorkgroup))) {
            unset($this->ProductWorkgroup);
        } else {
            $this->ProductWorkgroup = $productWorkgroup;
        }
        return $this;
    }
    /**
     * Get Vendor value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getVendor()
    {
        return isset($this->Vendor) ? $this->Vendor : null;
    }
    /**
     * Set Vendor value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $vendor
     * @return \App\API\SOAP\StructType\VendorPricesInquiry
     */
    public function setVendor(\App\API\SOAP\StructType\StringValue $vendor = null)
    {
        if (is_null($vendor) || (is_array($vendor) && empty($vendor))) {
            unset($this->Vendor);
        } else {
            $this->Vendor = $vendor;
        }
        return $this;
    }
    /**
     * Get VendorPriceDetails value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\VendorPriceDetails|null
     */
    public function getVendorPriceDetails()
    {
        return isset($this->VendorPriceDetails) ? $this->VendorPriceDetails : null;
    }
    /**
     * Set VendorPriceDetails value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\VendorPriceDetails $vendorPriceDetails
     * @return \App\API\SOAP\StructType\VendorPricesInquiry
     */
    public function setVendorPriceDetails(\App\API\SOAP\StructType\VendorPriceDetails $vendorPriceDetails = null)
    {
        if (is_null($vendorPriceDetails) || (is_array($vendorPriceDetails) && empty($vendorPriceDetails))) {
            unset($this->VendorPriceDetails);
        } else {
            $this->VendorPriceDetails = $vendorPriceDetails;
        }
        return $this;
    }
}
