<?php

namespace App\API\SOAP\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for VendorDetails StructType
 * @subpackage Structs
 */
class VendorDetails extends AbstractStructBase
{
    /**
     * The StockItemVendorDetail
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StockItemVendorDetail[]
     */
    public $StockItemVendorDetail;
    /**
     * The NonStockItemVendorDetail
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\NonStockItemVendorDetail[]
     */
    public $NonStockItemVendorDetail;
    /**
     * Constructor method for VendorDetails
     * @uses VendorDetails::setStockItemVendorDetail()
     * @uses VendorDetails::setNonStockItemVendorDetail()
     * @param \App\API\SOAP\StructType\StockItemVendorDetail[] $stockItemVendorDetail
     * @param \App\API\SOAP\StructType\NonStockItemVendorDetail[] $nonStockItemVendorDetail
     */
    public function __construct(array $stockItemVendorDetail = array(), array $nonStockItemVendorDetail = array())
    {
        $this
            ->setStockItemVendorDetail($stockItemVendorDetail)
            ->setNonStockItemVendorDetail($nonStockItemVendorDetail);
    }
    /**
     * Get StockItemVendorDetail value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StockItemVendorDetail[]|null
     */
    public function getStockItemVendorDetail()
    {
        return isset($this->StockItemVendorDetail) ? $this->StockItemVendorDetail : null;
    }
    /**
     * This method is responsible for validating the values passed to the setStockItemVendorDetail method
     * This method is willingly generated in order to preserve the one-line inline validation within the setStockItemVendorDetail method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateStockItemVendorDetailForArrayConstraintsFromSetStockItemVendorDetail(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $vendorDetailsStockItemVendorDetailItem) {
            // validation for constraint: itemType
            if (!$vendorDetailsStockItemVendorDetailItem instanceof \App\API\SOAP\StructType\StockItemVendorDetail) {
                $invalidValues[] = is_object($vendorDetailsStockItemVendorDetailItem) ? get_class($vendorDetailsStockItemVendorDetailItem) : sprintf('%s(%s)', gettype($vendorDetailsStockItemVendorDetailItem), var_export($vendorDetailsStockItemVendorDetailItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The StockItemVendorDetail property can only contain items of type \App\API\SOAP\StructType\StockItemVendorDetail, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set StockItemVendorDetail value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \App\API\SOAP\StructType\StockItemVendorDetail[] $stockItemVendorDetail
     * @return \App\API\SOAP\StructType\VendorDetails
     */
    public function setStockItemVendorDetail(array $stockItemVendorDetail = array())
    {
        // validation for constraint: array
        if ('' !== ($stockItemVendorDetailArrayErrorMessage = self::validateStockItemVendorDetailForArrayConstraintsFromSetStockItemVendorDetail($stockItemVendorDetail))) {
            throw new \InvalidArgumentException($stockItemVendorDetailArrayErrorMessage, __LINE__);
        }
        if (is_null($stockItemVendorDetail) || (is_array($stockItemVendorDetail) && empty($stockItemVendorDetail))) {
            unset($this->StockItemVendorDetail);
        } else {
            $this->StockItemVendorDetail = $stockItemVendorDetail;
        }
        return $this;
    }
    /**
     * Add item to StockItemVendorDetail value
     * @throws \InvalidArgumentException
     * @param \App\API\SOAP\StructType\StockItemVendorDetail $item
     * @return \App\API\SOAP\StructType\VendorDetails
     */
    public function addToStockItemVendorDetail(\App\API\SOAP\StructType\StockItemVendorDetail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \App\API\SOAP\StructType\StockItemVendorDetail) {
            throw new \InvalidArgumentException(sprintf('The StockItemVendorDetail property can only contain items of type \App\API\SOAP\StructType\StockItemVendorDetail, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->StockItemVendorDetail[] = $item;
        return $this;
    }
    /**
     * Get NonStockItemVendorDetail value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\NonStockItemVendorDetail[]|null
     */
    public function getNonStockItemVendorDetail()
    {
        return isset($this->NonStockItemVendorDetail) ? $this->NonStockItemVendorDetail : null;
    }
    /**
     * This method is responsible for validating the values passed to the setNonStockItemVendorDetail method
     * This method is willingly generated in order to preserve the one-line inline validation within the setNonStockItemVendorDetail method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateNonStockItemVendorDetailForArrayConstraintsFromSetNonStockItemVendorDetail(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $vendorDetailsNonStockItemVendorDetailItem) {
            // validation for constraint: itemType
            if (!$vendorDetailsNonStockItemVendorDetailItem instanceof \App\API\SOAP\StructType\NonStockItemVendorDetail) {
                $invalidValues[] = is_object($vendorDetailsNonStockItemVendorDetailItem) ? get_class($vendorDetailsNonStockItemVendorDetailItem) : sprintf('%s(%s)', gettype($vendorDetailsNonStockItemVendorDetailItem), var_export($vendorDetailsNonStockItemVendorDetailItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The NonStockItemVendorDetail property can only contain items of type \App\API\SOAP\StructType\NonStockItemVendorDetail, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set NonStockItemVendorDetail value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \App\API\SOAP\StructType\NonStockItemVendorDetail[] $nonStockItemVendorDetail
     * @return \App\API\SOAP\StructType\VendorDetails
     */
    public function setNonStockItemVendorDetail(array $nonStockItemVendorDetail = array())
    {
        // validation for constraint: array
        if ('' !== ($nonStockItemVendorDetailArrayErrorMessage = self::validateNonStockItemVendorDetailForArrayConstraintsFromSetNonStockItemVendorDetail($nonStockItemVendorDetail))) {
            throw new \InvalidArgumentException($nonStockItemVendorDetailArrayErrorMessage, __LINE__);
        }
        if (is_null($nonStockItemVendorDetail) || (is_array($nonStockItemVendorDetail) && empty($nonStockItemVendorDetail))) {
            unset($this->NonStockItemVendorDetail);
        } else {
            $this->NonStockItemVendorDetail = $nonStockItemVendorDetail;
        }
        return $this;
    }
    /**
     * Add item to NonStockItemVendorDetail value
     * @throws \InvalidArgumentException
     * @param \App\API\SOAP\StructType\NonStockItemVendorDetail $item
     * @return \App\API\SOAP\StructType\VendorDetails
     */
    public function addToNonStockItemVendorDetail(\App\API\SOAP\StructType\NonStockItemVendorDetail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \App\API\SOAP\StructType\NonStockItemVendorDetail) {
            throw new \InvalidArgumentException(sprintf('The NonStockItemVendorDetail property can only contain items of type \App\API\SOAP\StructType\NonStockItemVendorDetail, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->NonStockItemVendorDetail[] = $item;
        return $this;
    }
}
