<?php

namespace App\API\SOAP\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UnionLocals StructType
 * @subpackage Structs
 */
class UnionLocals extends AbstractStructBase
{
    /**
     * The ProjectUnionLocal
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\ProjectUnionLocal[]
     */
    public $ProjectUnionLocal;
    /**
     * Constructor method for UnionLocals
     * @uses UnionLocals::setProjectUnionLocal()
     * @param \App\API\SOAP\StructType\ProjectUnionLocal[] $projectUnionLocal
     */
    public function __construct(array $projectUnionLocal = array())
    {
        $this
            ->setProjectUnionLocal($projectUnionLocal);
    }
    /**
     * Get ProjectUnionLocal value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\ProjectUnionLocal[]|null
     */
    public function getProjectUnionLocal()
    {
        return isset($this->ProjectUnionLocal) ? $this->ProjectUnionLocal : null;
    }
    /**
     * This method is responsible for validating the values passed to the setProjectUnionLocal method
     * This method is willingly generated in order to preserve the one-line inline validation within the setProjectUnionLocal method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateProjectUnionLocalForArrayConstraintsFromSetProjectUnionLocal(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $unionLocalsProjectUnionLocalItem) {
            // validation for constraint: itemType
            if (!$unionLocalsProjectUnionLocalItem instanceof \App\API\SOAP\StructType\ProjectUnionLocal) {
                $invalidValues[] = is_object($unionLocalsProjectUnionLocalItem) ? get_class($unionLocalsProjectUnionLocalItem) : sprintf('%s(%s)', gettype($unionLocalsProjectUnionLocalItem), var_export($unionLocalsProjectUnionLocalItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ProjectUnionLocal property can only contain items of type \App\API\SOAP\StructType\ProjectUnionLocal, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ProjectUnionLocal value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \App\API\SOAP\StructType\ProjectUnionLocal[] $projectUnionLocal
     * @return \App\API\SOAP\StructType\UnionLocals
     */
    public function setProjectUnionLocal(array $projectUnionLocal = array())
    {
        // validation for constraint: array
        if ('' !== ($projectUnionLocalArrayErrorMessage = self::validateProjectUnionLocalForArrayConstraintsFromSetProjectUnionLocal($projectUnionLocal))) {
            throw new \InvalidArgumentException($projectUnionLocalArrayErrorMessage, __LINE__);
        }
        if (is_null($projectUnionLocal) || (is_array($projectUnionLocal) && empty($projectUnionLocal))) {
            unset($this->ProjectUnionLocal);
        } else {
            $this->ProjectUnionLocal = $projectUnionLocal;
        }
        return $this;
    }
    /**
     * Add item to ProjectUnionLocal value
     * @throws \InvalidArgumentException
     * @param \App\API\SOAP\StructType\ProjectUnionLocal $item
     * @return \App\API\SOAP\StructType\UnionLocals
     */
    public function addToProjectUnionLocal(\App\API\SOAP\StructType\ProjectUnionLocal $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \App\API\SOAP\StructType\ProjectUnionLocal) {
            throw new \InvalidArgumentException(sprintf('The ProjectUnionLocal property can only contain items of type \App\API\SOAP\StructType\ProjectUnionLocal, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ProjectUnionLocal[] = $item;
        return $this;
    }
}
