<?php

namespace App\API\SOAP\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TransferOrderDetailAllocation StructType
 * @subpackage Structs
 */
class TransferOrderDetailAllocation extends Entity
{
    /**
     * The LocationID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $LocationID;
    /**
     * The LotSerialNbr
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $LotSerialNbr;
    /**
     * The Qty
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\DecimalValue
     */
    public $Qty;
    /**
     * The SplitLineNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\IntValue
     */
    public $SplitLineNumber;
    /**
     * The Subitem
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $Subitem;
    /**
     * Constructor method for TransferOrderDetailAllocation
     * @uses TransferOrderDetailAllocation::setLocationID()
     * @uses TransferOrderDetailAllocation::setLotSerialNbr()
     * @uses TransferOrderDetailAllocation::setQty()
     * @uses TransferOrderDetailAllocation::setSplitLineNumber()
     * @uses TransferOrderDetailAllocation::setSubitem()
     * @param \App\API\SOAP\StructType\StringValue $locationID
     * @param \App\API\SOAP\StructType\StringValue $lotSerialNbr
     * @param \App\API\SOAP\StructType\DecimalValue $qty
     * @param \App\API\SOAP\StructType\IntValue $splitLineNumber
     * @param \App\API\SOAP\StructType\StringValue $subitem
     */
    public function __construct(\App\API\SOAP\StructType\StringValue $locationID = null, \App\API\SOAP\StructType\StringValue $lotSerialNbr = null, \App\API\SOAP\StructType\DecimalValue $qty = null, \App\API\SOAP\StructType\IntValue $splitLineNumber = null, \App\API\SOAP\StructType\StringValue $subitem = null)
    {
        $this
            ->setLocationID($locationID)
            ->setLotSerialNbr($lotSerialNbr)
            ->setQty($qty)
            ->setSplitLineNumber($splitLineNumber)
            ->setSubitem($subitem);
    }
    /**
     * Get LocationID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getLocationID()
    {
        return isset($this->LocationID) ? $this->LocationID : null;
    }
    /**
     * Set LocationID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $locationID
     * @return \App\API\SOAP\StructType\TransferOrderDetailAllocation
     */
    public function setLocationID(\App\API\SOAP\StructType\StringValue $locationID = null)
    {
        if (is_null($locationID) || (is_array($locationID) && empty($locationID))) {
            unset($this->LocationID);
        } else {
            $this->LocationID = $locationID;
        }
        return $this;
    }
    /**
     * Get LotSerialNbr value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getLotSerialNbr()
    {
        return isset($this->LotSerialNbr) ? $this->LotSerialNbr : null;
    }
    /**
     * Set LotSerialNbr value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $lotSerialNbr
     * @return \App\API\SOAP\StructType\TransferOrderDetailAllocation
     */
    public function setLotSerialNbr(\App\API\SOAP\StructType\StringValue $lotSerialNbr = null)
    {
        if (is_null($lotSerialNbr) || (is_array($lotSerialNbr) && empty($lotSerialNbr))) {
            unset($this->LotSerialNbr);
        } else {
            $this->LotSerialNbr = $lotSerialNbr;
        }
        return $this;
    }
    /**
     * Get Qty value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\DecimalValue|null
     */
    public function getQty()
    {
        return isset($this->Qty) ? $this->Qty : null;
    }
    /**
     * Set Qty value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\DecimalValue $qty
     * @return \App\API\SOAP\StructType\TransferOrderDetailAllocation
     */
    public function setQty(\App\API\SOAP\StructType\DecimalValue $qty = null)
    {
        if (is_null($qty) || (is_array($qty) && empty($qty))) {
            unset($this->Qty);
        } else {
            $this->Qty = $qty;
        }
        return $this;
    }
    /**
     * Get SplitLineNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\IntValue|null
     */
    public function getSplitLineNumber()
    {
        return isset($this->SplitLineNumber) ? $this->SplitLineNumber : null;
    }
    /**
     * Set SplitLineNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\IntValue $splitLineNumber
     * @return \App\API\SOAP\StructType\TransferOrderDetailAllocation
     */
    public function setSplitLineNumber(\App\API\SOAP\StructType\IntValue $splitLineNumber = null)
    {
        if (is_null($splitLineNumber) || (is_array($splitLineNumber) && empty($splitLineNumber))) {
            unset($this->SplitLineNumber);
        } else {
            $this->SplitLineNumber = $splitLineNumber;
        }
        return $this;
    }
    /**
     * Get Subitem value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getSubitem()
    {
        return isset($this->Subitem) ? $this->Subitem : null;
    }
    /**
     * Set Subitem value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $subitem
     * @return \App\API\SOAP\StructType\TransferOrderDetailAllocation
     */
    public function setSubitem(\App\API\SOAP\StructType\StringValue $subitem = null)
    {
        if (is_null($subitem) || (is_array($subitem) && empty($subitem))) {
            unset($this->Subitem);
        } else {
            $this->Subitem = $subitem;
        }
        return $this;
    }
}
