<?php

namespace App\API\SOAP\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TimeAndMaterial StructType
 * @subpackage Structs
 */
class TimeAndMaterial extends Entity
{
    /**
     * The AmountToInvoice
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\DecimalValue
     */
    public $AmountToInvoice;
    /**
     * The BilledAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\DecimalValue
     */
    public $BilledAmount;
    /**
     * The BilledQty
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\DecimalValue
     */
    public $BilledQty;
    /**
     * The Branch
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $Branch;
    /**
     * The CostCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $CostCode;
    /**
     * The Date
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\DateTimeValue
     */
    public $Date;
    /**
     * The DeferralCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $DeferralCode;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $Description;
    /**
     * The EmployeeID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $EmployeeID;
    /**
     * The InventoryID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $InventoryID;
    /**
     * The MaxAvailableAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\DecimalValue
     */
    public $MaxAvailableAmount;
    /**
     * The MaxLimitAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\DecimalValue
     */
    public $MaxLimitAmount;
    /**
     * The OverLimitAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\DecimalValue
     */
    public $OverLimitAmount;
    /**
     * The ProjectTaskID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $ProjectTaskID;
    /**
     * The QtyToInvoice
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\DecimalValue
     */
    public $QtyToInvoice;
    /**
     * The Retainage
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\DecimalValue
     */
    public $Retainage;
    /**
     * The RetainageAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\DecimalValue
     */
    public $RetainageAmount;
    /**
     * The SalesAccount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $SalesAccount;
    /**
     * The SalesSubaccount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $SalesSubaccount;
    /**
     * The Status
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $Status;
    /**
     * The TaxCategory
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $TaxCategory;
    /**
     * The UnitPrice
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\DecimalValue
     */
    public $UnitPrice;
    /**
     * The UOM
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $UOM;
    /**
     * The Vendor
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $Vendor;
    /**
     * The TimeAndMaterial
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\TimeAndMaterial[]
     */
    public $TimeAndMaterial;
    /**
     * Constructor method for TimeAndMaterial
     * @uses TimeAndMaterial::setAmountToInvoice()
     * @uses TimeAndMaterial::setBilledAmount()
     * @uses TimeAndMaterial::setBilledQty()
     * @uses TimeAndMaterial::setBranch()
     * @uses TimeAndMaterial::setCostCode()
     * @uses TimeAndMaterial::setDate()
     * @uses TimeAndMaterial::setDeferralCode()
     * @uses TimeAndMaterial::setDescription()
     * @uses TimeAndMaterial::setEmployeeID()
     * @uses TimeAndMaterial::setInventoryID()
     * @uses TimeAndMaterial::setMaxAvailableAmount()
     * @uses TimeAndMaterial::setMaxLimitAmount()
     * @uses TimeAndMaterial::setOverLimitAmount()
     * @uses TimeAndMaterial::setProjectTaskID()
     * @uses TimeAndMaterial::setQtyToInvoice()
     * @uses TimeAndMaterial::setRetainage()
     * @uses TimeAndMaterial::setRetainageAmount()
     * @uses TimeAndMaterial::setSalesAccount()
     * @uses TimeAndMaterial::setSalesSubaccount()
     * @uses TimeAndMaterial::setStatus()
     * @uses TimeAndMaterial::setTaxCategory()
     * @uses TimeAndMaterial::setUnitPrice()
     * @uses TimeAndMaterial::setUOM()
     * @uses TimeAndMaterial::setVendor()
     * @uses TimeAndMaterial::setTimeAndMaterial()
     * @param \App\API\SOAP\StructType\DecimalValue $amountToInvoice
     * @param \App\API\SOAP\StructType\DecimalValue $billedAmount
     * @param \App\API\SOAP\StructType\DecimalValue $billedQty
     * @param \App\API\SOAP\StructType\StringValue $branch
     * @param \App\API\SOAP\StructType\StringValue $costCode
     * @param \App\API\SOAP\StructType\DateTimeValue $date
     * @param \App\API\SOAP\StructType\StringValue $deferralCode
     * @param \App\API\SOAP\StructType\StringValue $description
     * @param \App\API\SOAP\StructType\StringValue $employeeID
     * @param \App\API\SOAP\StructType\StringValue $inventoryID
     * @param \App\API\SOAP\StructType\DecimalValue $maxAvailableAmount
     * @param \App\API\SOAP\StructType\DecimalValue $maxLimitAmount
     * @param \App\API\SOAP\StructType\DecimalValue $overLimitAmount
     * @param \App\API\SOAP\StructType\StringValue $projectTaskID
     * @param \App\API\SOAP\StructType\DecimalValue $qtyToInvoice
     * @param \App\API\SOAP\StructType\DecimalValue $retainage
     * @param \App\API\SOAP\StructType\DecimalValue $retainageAmount
     * @param \App\API\SOAP\StructType\StringValue $salesAccount
     * @param \App\API\SOAP\StructType\StringValue $salesSubaccount
     * @param \App\API\SOAP\StructType\StringValue $status
     * @param \App\API\SOAP\StructType\StringValue $taxCategory
     * @param \App\API\SOAP\StructType\DecimalValue $unitPrice
     * @param \App\API\SOAP\StructType\StringValue $uOM
     * @param \App\API\SOAP\StructType\StringValue $vendor
     * @param \App\API\SOAP\StructType\TimeAndMaterial[] $timeAndMaterial
     */
    public function __construct(\App\API\SOAP\StructType\DecimalValue $amountToInvoice = null, \App\API\SOAP\StructType\DecimalValue $billedAmount = null, \App\API\SOAP\StructType\DecimalValue $billedQty = null, \App\API\SOAP\StructType\StringValue $branch = null, \App\API\SOAP\StructType\StringValue $costCode = null, \App\API\SOAP\StructType\DateTimeValue $date = null, \App\API\SOAP\StructType\StringValue $deferralCode = null, \App\API\SOAP\StructType\StringValue $description = null, \App\API\SOAP\StructType\StringValue $employeeID = null, \App\API\SOAP\StructType\StringValue $inventoryID = null, \App\API\SOAP\StructType\DecimalValue $maxAvailableAmount = null, \App\API\SOAP\StructType\DecimalValue $maxLimitAmount = null, \App\API\SOAP\StructType\DecimalValue $overLimitAmount = null, \App\API\SOAP\StructType\StringValue $projectTaskID = null, \App\API\SOAP\StructType\DecimalValue $qtyToInvoice = null, \App\API\SOAP\StructType\DecimalValue $retainage = null, \App\API\SOAP\StructType\DecimalValue $retainageAmount = null, \App\API\SOAP\StructType\StringValue $salesAccount = null, \App\API\SOAP\StructType\StringValue $salesSubaccount = null, \App\API\SOAP\StructType\StringValue $status = null, \App\API\SOAP\StructType\StringValue $taxCategory = null, \App\API\SOAP\StructType\DecimalValue $unitPrice = null, \App\API\SOAP\StructType\StringValue $uOM = null, \App\API\SOAP\StructType\StringValue $vendor = null, array $timeAndMaterial = array())
    {
        $this
            ->setAmountToInvoice($amountToInvoice)
            ->setBilledAmount($billedAmount)
            ->setBilledQty($billedQty)
            ->setBranch($branch)
            ->setCostCode($costCode)
            ->setDate($date)
            ->setDeferralCode($deferralCode)
            ->setDescription($description)
            ->setEmployeeID($employeeID)
            ->setInventoryID($inventoryID)
            ->setMaxAvailableAmount($maxAvailableAmount)
            ->setMaxLimitAmount($maxLimitAmount)
            ->setOverLimitAmount($overLimitAmount)
            ->setProjectTaskID($projectTaskID)
            ->setQtyToInvoice($qtyToInvoice)
            ->setRetainage($retainage)
            ->setRetainageAmount($retainageAmount)
            ->setSalesAccount($salesAccount)
            ->setSalesSubaccount($salesSubaccount)
            ->setStatus($status)
            ->setTaxCategory($taxCategory)
            ->setUnitPrice($unitPrice)
            ->setUOM($uOM)
            ->setVendor($vendor)
            ->setTimeAndMaterial($timeAndMaterial);
    }
    /**
     * Get AmountToInvoice value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\DecimalValue|null
     */
    public function getAmountToInvoice()
    {
        return isset($this->AmountToInvoice) ? $this->AmountToInvoice : null;
    }
    /**
     * Set AmountToInvoice value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\DecimalValue $amountToInvoice
     * @return \App\API\SOAP\StructType\TimeAndMaterial
     */
    public function setAmountToInvoice(\App\API\SOAP\StructType\DecimalValue $amountToInvoice = null)
    {
        if (is_null($amountToInvoice) || (is_array($amountToInvoice) && empty($amountToInvoice))) {
            unset($this->AmountToInvoice);
        } else {
            $this->AmountToInvoice = $amountToInvoice;
        }
        return $this;
    }
    /**
     * Get BilledAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\DecimalValue|null
     */
    public function getBilledAmount()
    {
        return isset($this->BilledAmount) ? $this->BilledAmount : null;
    }
    /**
     * Set BilledAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\DecimalValue $billedAmount
     * @return \App\API\SOAP\StructType\TimeAndMaterial
     */
    public function setBilledAmount(\App\API\SOAP\StructType\DecimalValue $billedAmount = null)
    {
        if (is_null($billedAmount) || (is_array($billedAmount) && empty($billedAmount))) {
            unset($this->BilledAmount);
        } else {
            $this->BilledAmount = $billedAmount;
        }
        return $this;
    }
    /**
     * Get BilledQty value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\DecimalValue|null
     */
    public function getBilledQty()
    {
        return isset($this->BilledQty) ? $this->BilledQty : null;
    }
    /**
     * Set BilledQty value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\DecimalValue $billedQty
     * @return \App\API\SOAP\StructType\TimeAndMaterial
     */
    public function setBilledQty(\App\API\SOAP\StructType\DecimalValue $billedQty = null)
    {
        if (is_null($billedQty) || (is_array($billedQty) && empty($billedQty))) {
            unset($this->BilledQty);
        } else {
            $this->BilledQty = $billedQty;
        }
        return $this;
    }
    /**
     * Get Branch value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getBranch()
    {
        return isset($this->Branch) ? $this->Branch : null;
    }
    /**
     * Set Branch value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $branch
     * @return \App\API\SOAP\StructType\TimeAndMaterial
     */
    public function setBranch(\App\API\SOAP\StructType\StringValue $branch = null)
    {
        if (is_null($branch) || (is_array($branch) && empty($branch))) {
            unset($this->Branch);
        } else {
            $this->Branch = $branch;
        }
        return $this;
    }
    /**
     * Get CostCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getCostCode()
    {
        return isset($this->CostCode) ? $this->CostCode : null;
    }
    /**
     * Set CostCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $costCode
     * @return \App\API\SOAP\StructType\TimeAndMaterial
     */
    public function setCostCode(\App\API\SOAP\StructType\StringValue $costCode = null)
    {
        if (is_null($costCode) || (is_array($costCode) && empty($costCode))) {
            unset($this->CostCode);
        } else {
            $this->CostCode = $costCode;
        }
        return $this;
    }
    /**
     * Get Date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\DateTimeValue|null
     */
    public function getDate()
    {
        return isset($this->Date) ? $this->Date : null;
    }
    /**
     * Set Date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\DateTimeValue $date
     * @return \App\API\SOAP\StructType\TimeAndMaterial
     */
    public function setDate(\App\API\SOAP\StructType\DateTimeValue $date = null)
    {
        if (is_null($date) || (is_array($date) && empty($date))) {
            unset($this->Date);
        } else {
            $this->Date = $date;
        }
        return $this;
    }
    /**
     * Get DeferralCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getDeferralCode()
    {
        return isset($this->DeferralCode) ? $this->DeferralCode : null;
    }
    /**
     * Set DeferralCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $deferralCode
     * @return \App\API\SOAP\StructType\TimeAndMaterial
     */
    public function setDeferralCode(\App\API\SOAP\StructType\StringValue $deferralCode = null)
    {
        if (is_null($deferralCode) || (is_array($deferralCode) && empty($deferralCode))) {
            unset($this->DeferralCode);
        } else {
            $this->DeferralCode = $deferralCode;
        }
        return $this;
    }
    /**
     * Get Description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getDescription()
    {
        return isset($this->Description) ? $this->Description : null;
    }
    /**
     * Set Description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $description
     * @return \App\API\SOAP\StructType\TimeAndMaterial
     */
    public function setDescription(\App\API\SOAP\StructType\StringValue $description = null)
    {
        if (is_null($description) || (is_array($description) && empty($description))) {
            unset($this->Description);
        } else {
            $this->Description = $description;
        }
        return $this;
    }
    /**
     * Get EmployeeID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getEmployeeID()
    {
        return isset($this->EmployeeID) ? $this->EmployeeID : null;
    }
    /**
     * Set EmployeeID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $employeeID
     * @return \App\API\SOAP\StructType\TimeAndMaterial
     */
    public function setEmployeeID(\App\API\SOAP\StructType\StringValue $employeeID = null)
    {
        if (is_null($employeeID) || (is_array($employeeID) && empty($employeeID))) {
            unset($this->EmployeeID);
        } else {
            $this->EmployeeID = $employeeID;
        }
        return $this;
    }
    /**
     * Get InventoryID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getInventoryID()
    {
        return isset($this->InventoryID) ? $this->InventoryID : null;
    }
    /**
     * Set InventoryID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $inventoryID
     * @return \App\API\SOAP\StructType\TimeAndMaterial
     */
    public function setInventoryID(\App\API\SOAP\StructType\StringValue $inventoryID = null)
    {
        if (is_null($inventoryID) || (is_array($inventoryID) && empty($inventoryID))) {
            unset($this->InventoryID);
        } else {
            $this->InventoryID = $inventoryID;
        }
        return $this;
    }
    /**
     * Get MaxAvailableAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\DecimalValue|null
     */
    public function getMaxAvailableAmount()
    {
        return isset($this->MaxAvailableAmount) ? $this->MaxAvailableAmount : null;
    }
    /**
     * Set MaxAvailableAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\DecimalValue $maxAvailableAmount
     * @return \App\API\SOAP\StructType\TimeAndMaterial
     */
    public function setMaxAvailableAmount(\App\API\SOAP\StructType\DecimalValue $maxAvailableAmount = null)
    {
        if (is_null($maxAvailableAmount) || (is_array($maxAvailableAmount) && empty($maxAvailableAmount))) {
            unset($this->MaxAvailableAmount);
        } else {
            $this->MaxAvailableAmount = $maxAvailableAmount;
        }
        return $this;
    }
    /**
     * Get MaxLimitAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\DecimalValue|null
     */
    public function getMaxLimitAmount()
    {
        return isset($this->MaxLimitAmount) ? $this->MaxLimitAmount : null;
    }
    /**
     * Set MaxLimitAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\DecimalValue $maxLimitAmount
     * @return \App\API\SOAP\StructType\TimeAndMaterial
     */
    public function setMaxLimitAmount(\App\API\SOAP\StructType\DecimalValue $maxLimitAmount = null)
    {
        if (is_null($maxLimitAmount) || (is_array($maxLimitAmount) && empty($maxLimitAmount))) {
            unset($this->MaxLimitAmount);
        } else {
            $this->MaxLimitAmount = $maxLimitAmount;
        }
        return $this;
    }
    /**
     * Get OverLimitAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\DecimalValue|null
     */
    public function getOverLimitAmount()
    {
        return isset($this->OverLimitAmount) ? $this->OverLimitAmount : null;
    }
    /**
     * Set OverLimitAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\DecimalValue $overLimitAmount
     * @return \App\API\SOAP\StructType\TimeAndMaterial
     */
    public function setOverLimitAmount(\App\API\SOAP\StructType\DecimalValue $overLimitAmount = null)
    {
        if (is_null($overLimitAmount) || (is_array($overLimitAmount) && empty($overLimitAmount))) {
            unset($this->OverLimitAmount);
        } else {
            $this->OverLimitAmount = $overLimitAmount;
        }
        return $this;
    }
    /**
     * Get ProjectTaskID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getProjectTaskID()
    {
        return isset($this->ProjectTaskID) ? $this->ProjectTaskID : null;
    }
    /**
     * Set ProjectTaskID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $projectTaskID
     * @return \App\API\SOAP\StructType\TimeAndMaterial
     */
    public function setProjectTaskID(\App\API\SOAP\StructType\StringValue $projectTaskID = null)
    {
        if (is_null($projectTaskID) || (is_array($projectTaskID) && empty($projectTaskID))) {
            unset($this->ProjectTaskID);
        } else {
            $this->ProjectTaskID = $projectTaskID;
        }
        return $this;
    }
    /**
     * Get QtyToInvoice value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\DecimalValue|null
     */
    public function getQtyToInvoice()
    {
        return isset($this->QtyToInvoice) ? $this->QtyToInvoice : null;
    }
    /**
     * Set QtyToInvoice value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\DecimalValue $qtyToInvoice
     * @return \App\API\SOAP\StructType\TimeAndMaterial
     */
    public function setQtyToInvoice(\App\API\SOAP\StructType\DecimalValue $qtyToInvoice = null)
    {
        if (is_null($qtyToInvoice) || (is_array($qtyToInvoice) && empty($qtyToInvoice))) {
            unset($this->QtyToInvoice);
        } else {
            $this->QtyToInvoice = $qtyToInvoice;
        }
        return $this;
    }
    /**
     * Get Retainage value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\DecimalValue|null
     */
    public function getRetainage()
    {
        return isset($this->Retainage) ? $this->Retainage : null;
    }
    /**
     * Set Retainage value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\DecimalValue $retainage
     * @return \App\API\SOAP\StructType\TimeAndMaterial
     */
    public function setRetainage(\App\API\SOAP\StructType\DecimalValue $retainage = null)
    {
        if (is_null($retainage) || (is_array($retainage) && empty($retainage))) {
            unset($this->Retainage);
        } else {
            $this->Retainage = $retainage;
        }
        return $this;
    }
    /**
     * Get RetainageAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\DecimalValue|null
     */
    public function getRetainageAmount()
    {
        return isset($this->RetainageAmount) ? $this->RetainageAmount : null;
    }
    /**
     * Set RetainageAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\DecimalValue $retainageAmount
     * @return \App\API\SOAP\StructType\TimeAndMaterial
     */
    public function setRetainageAmount(\App\API\SOAP\StructType\DecimalValue $retainageAmount = null)
    {
        if (is_null($retainageAmount) || (is_array($retainageAmount) && empty($retainageAmount))) {
            unset($this->RetainageAmount);
        } else {
            $this->RetainageAmount = $retainageAmount;
        }
        return $this;
    }
    /**
     * Get SalesAccount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getSalesAccount()
    {
        return isset($this->SalesAccount) ? $this->SalesAccount : null;
    }
    /**
     * Set SalesAccount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $salesAccount
     * @return \App\API\SOAP\StructType\TimeAndMaterial
     */
    public function setSalesAccount(\App\API\SOAP\StructType\StringValue $salesAccount = null)
    {
        if (is_null($salesAccount) || (is_array($salesAccount) && empty($salesAccount))) {
            unset($this->SalesAccount);
        } else {
            $this->SalesAccount = $salesAccount;
        }
        return $this;
    }
    /**
     * Get SalesSubaccount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getSalesSubaccount()
    {
        return isset($this->SalesSubaccount) ? $this->SalesSubaccount : null;
    }
    /**
     * Set SalesSubaccount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $salesSubaccount
     * @return \App\API\SOAP\StructType\TimeAndMaterial
     */
    public function setSalesSubaccount(\App\API\SOAP\StructType\StringValue $salesSubaccount = null)
    {
        if (is_null($salesSubaccount) || (is_array($salesSubaccount) && empty($salesSubaccount))) {
            unset($this->SalesSubaccount);
        } else {
            $this->SalesSubaccount = $salesSubaccount;
        }
        return $this;
    }
    /**
     * Get Status value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getStatus()
    {
        return isset($this->Status) ? $this->Status : null;
    }
    /**
     * Set Status value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $status
     * @return \App\API\SOAP\StructType\TimeAndMaterial
     */
    public function setStatus(\App\API\SOAP\StructType\StringValue $status = null)
    {
        if (is_null($status) || (is_array($status) && empty($status))) {
            unset($this->Status);
        } else {
            $this->Status = $status;
        }
        return $this;
    }
    /**
     * Get TaxCategory value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getTaxCategory()
    {
        return isset($this->TaxCategory) ? $this->TaxCategory : null;
    }
    /**
     * Set TaxCategory value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $taxCategory
     * @return \App\API\SOAP\StructType\TimeAndMaterial
     */
    public function setTaxCategory(\App\API\SOAP\StructType\StringValue $taxCategory = null)
    {
        if (is_null($taxCategory) || (is_array($taxCategory) && empty($taxCategory))) {
            unset($this->TaxCategory);
        } else {
            $this->TaxCategory = $taxCategory;
        }
        return $this;
    }
    /**
     * Get UnitPrice value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\DecimalValue|null
     */
    public function getUnitPrice()
    {
        return isset($this->UnitPrice) ? $this->UnitPrice : null;
    }
    /**
     * Set UnitPrice value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\DecimalValue $unitPrice
     * @return \App\API\SOAP\StructType\TimeAndMaterial
     */
    public function setUnitPrice(\App\API\SOAP\StructType\DecimalValue $unitPrice = null)
    {
        if (is_null($unitPrice) || (is_array($unitPrice) && empty($unitPrice))) {
            unset($this->UnitPrice);
        } else {
            $this->UnitPrice = $unitPrice;
        }
        return $this;
    }
    /**
     * Get UOM value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getUOM()
    {
        return isset($this->UOM) ? $this->UOM : null;
    }
    /**
     * Set UOM value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $uOM
     * @return \App\API\SOAP\StructType\TimeAndMaterial
     */
    public function setUOM(\App\API\SOAP\StructType\StringValue $uOM = null)
    {
        if (is_null($uOM) || (is_array($uOM) && empty($uOM))) {
            unset($this->UOM);
        } else {
            $this->UOM = $uOM;
        }
        return $this;
    }
    /**
     * Get Vendor value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getVendor()
    {
        return isset($this->Vendor) ? $this->Vendor : null;
    }
    /**
     * Set Vendor value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $vendor
     * @return \App\API\SOAP\StructType\TimeAndMaterial
     */
    public function setVendor(\App\API\SOAP\StructType\StringValue $vendor = null)
    {
        if (is_null($vendor) || (is_array($vendor) && empty($vendor))) {
            unset($this->Vendor);
        } else {
            $this->Vendor = $vendor;
        }
        return $this;
    }
    /**
     * Get TimeAndMaterial value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\TimeAndMaterial[]|null
     */
    public function getTimeAndMaterial()
    {
        return isset($this->TimeAndMaterial) ? $this->TimeAndMaterial : null;
    }
    /**
     * This method is responsible for validating the values passed to the setTimeAndMaterial method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTimeAndMaterial method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTimeAndMaterialForArrayConstraintsFromSetTimeAndMaterial(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $timeAndMaterialTimeAndMaterialItem) {
            // validation for constraint: itemType
            if (!$timeAndMaterialTimeAndMaterialItem instanceof \App\API\SOAP\StructType\TimeAndMaterial) {
                $invalidValues[] = is_object($timeAndMaterialTimeAndMaterialItem) ? get_class($timeAndMaterialTimeAndMaterialItem) : sprintf('%s(%s)', gettype($timeAndMaterialTimeAndMaterialItem), var_export($timeAndMaterialTimeAndMaterialItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The TimeAndMaterial property can only contain items of type \App\API\SOAP\StructType\TimeAndMaterial, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set TimeAndMaterial value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \App\API\SOAP\StructType\TimeAndMaterial[] $timeAndMaterial
     * @return \App\API\SOAP\StructType\TimeAndMaterial
     */
    public function setTimeAndMaterial(array $timeAndMaterial = array())
    {
        // validation for constraint: array
        if ('' !== ($timeAndMaterialArrayErrorMessage = self::validateTimeAndMaterialForArrayConstraintsFromSetTimeAndMaterial($timeAndMaterial))) {
            throw new \InvalidArgumentException($timeAndMaterialArrayErrorMessage, __LINE__);
        }
        if (is_null($timeAndMaterial) || (is_array($timeAndMaterial) && empty($timeAndMaterial))) {
            unset($this->TimeAndMaterial);
        } else {
            $this->TimeAndMaterial = $timeAndMaterial;
        }
        return $this;
    }
    /**
     * Add item to TimeAndMaterial value
     * @throws \InvalidArgumentException
     * @param \App\API\SOAP\StructType\TimeAndMaterial $item
     * @return \App\API\SOAP\StructType\TimeAndMaterial
     */
    public function addToTimeAndMaterial(\App\API\SOAP\StructType\TimeAndMaterial $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \App\API\SOAP\StructType\TimeAndMaterial) {
            throw new \InvalidArgumentException(sprintf('The TimeAndMaterial property can only contain items of type \App\API\SOAP\StructType\TimeAndMaterial, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->TimeAndMaterial[] = $item;
        return $this;
    }
}
