<?php

namespace App\API\SOAP\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TaxCategory StructType
 * @subpackage Structs
 */
class TaxCategory extends Entity
{
    /**
     * The Active
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\BooleanValue
     */
    public $Active;
    /**
     * The CreatedDateTime
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\DateTimeValue
     */
    public $CreatedDateTime;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $Description;
    /**
     * The Details
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\Details
     */
    public $Details;
    /**
     * The ExcludeListedTaxes
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\BooleanValue
     */
    public $ExcludeListedTaxes;
    /**
     * The LastModifiedDateTime
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\DateTimeValue
     */
    public $LastModifiedDateTime;
    /**
     * The TaxCategoryID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $TaxCategoryID;
    /**
     * Constructor method for TaxCategory
     * @uses TaxCategory::setActive()
     * @uses TaxCategory::setCreatedDateTime()
     * @uses TaxCategory::setDescription()
     * @uses TaxCategory::setDetails()
     * @uses TaxCategory::setExcludeListedTaxes()
     * @uses TaxCategory::setLastModifiedDateTime()
     * @uses TaxCategory::setTaxCategoryID()
     * @param \App\API\SOAP\StructType\BooleanValue $active
     * @param \App\API\SOAP\StructType\DateTimeValue $createdDateTime
     * @param \App\API\SOAP\StructType\StringValue $description
     * @param \App\API\SOAP\StructType\Details $details
     * @param \App\API\SOAP\StructType\BooleanValue $excludeListedTaxes
     * @param \App\API\SOAP\StructType\DateTimeValue $lastModifiedDateTime
     * @param \App\API\SOAP\StructType\StringValue $taxCategoryID
     */
    public function __construct(\App\API\SOAP\StructType\BooleanValue $active = null, \App\API\SOAP\StructType\DateTimeValue $createdDateTime = null, \App\API\SOAP\StructType\StringValue $description = null, \App\API\SOAP\StructType\Details $details = null, \App\API\SOAP\StructType\BooleanValue $excludeListedTaxes = null, \App\API\SOAP\StructType\DateTimeValue $lastModifiedDateTime = null, \App\API\SOAP\StructType\StringValue $taxCategoryID = null)
    {
        $this
            ->setActive($active)
            ->setCreatedDateTime($createdDateTime)
            ->setDescription($description)
            ->setDetails($details)
            ->setExcludeListedTaxes($excludeListedTaxes)
            ->setLastModifiedDateTime($lastModifiedDateTime)
            ->setTaxCategoryID($taxCategoryID);
    }
    /**
     * Get Active value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\BooleanValue|null
     */
    public function getActive()
    {
        return isset($this->Active) ? $this->Active : null;
    }
    /**
     * Set Active value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\BooleanValue $active
     * @return \App\API\SOAP\StructType\TaxCategory
     */
    public function setActive(\App\API\SOAP\StructType\BooleanValue $active = null)
    {
        if (is_null($active) || (is_array($active) && empty($active))) {
            unset($this->Active);
        } else {
            $this->Active = $active;
        }
        return $this;
    }
    /**
     * Get CreatedDateTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\DateTimeValue|null
     */
    public function getCreatedDateTime()
    {
        return isset($this->CreatedDateTime) ? $this->CreatedDateTime : null;
    }
    /**
     * Set CreatedDateTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\DateTimeValue $createdDateTime
     * @return \App\API\SOAP\StructType\TaxCategory
     */
    public function setCreatedDateTime(\App\API\SOAP\StructType\DateTimeValue $createdDateTime = null)
    {
        if (is_null($createdDateTime) || (is_array($createdDateTime) && empty($createdDateTime))) {
            unset($this->CreatedDateTime);
        } else {
            $this->CreatedDateTime = $createdDateTime;
        }
        return $this;
    }
    /**
     * Get Description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getDescription()
    {
        return isset($this->Description) ? $this->Description : null;
    }
    /**
     * Set Description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $description
     * @return \App\API\SOAP\StructType\TaxCategory
     */
    public function setDescription(\App\API\SOAP\StructType\StringValue $description = null)
    {
        if (is_null($description) || (is_array($description) && empty($description))) {
            unset($this->Description);
        } else {
            $this->Description = $description;
        }
        return $this;
    }
    /**
     * Get Details value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\Details|null
     */
    public function getDetails()
    {
        return isset($this->Details) ? $this->Details : null;
    }
    /**
     * Set Details value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\Details $details
     * @return \App\API\SOAP\StructType\TaxCategory
     */
    public function setDetails(\App\API\SOAP\StructType\Details $details = null)
    {
        if (is_null($details) || (is_array($details) && empty($details))) {
            unset($this->Details);
        } else {
            $this->Details = $details;
        }
        return $this;
    }
    /**
     * Get ExcludeListedTaxes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\BooleanValue|null
     */
    public function getExcludeListedTaxes()
    {
        return isset($this->ExcludeListedTaxes) ? $this->ExcludeListedTaxes : null;
    }
    /**
     * Set ExcludeListedTaxes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\BooleanValue $excludeListedTaxes
     * @return \App\API\SOAP\StructType\TaxCategory
     */
    public function setExcludeListedTaxes(\App\API\SOAP\StructType\BooleanValue $excludeListedTaxes = null)
    {
        if (is_null($excludeListedTaxes) || (is_array($excludeListedTaxes) && empty($excludeListedTaxes))) {
            unset($this->ExcludeListedTaxes);
        } else {
            $this->ExcludeListedTaxes = $excludeListedTaxes;
        }
        return $this;
    }
    /**
     * Get LastModifiedDateTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\DateTimeValue|null
     */
    public function getLastModifiedDateTime()
    {
        return isset($this->LastModifiedDateTime) ? $this->LastModifiedDateTime : null;
    }
    /**
     * Set LastModifiedDateTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\DateTimeValue $lastModifiedDateTime
     * @return \App\API\SOAP\StructType\TaxCategory
     */
    public function setLastModifiedDateTime(\App\API\SOAP\StructType\DateTimeValue $lastModifiedDateTime = null)
    {
        if (is_null($lastModifiedDateTime) || (is_array($lastModifiedDateTime) && empty($lastModifiedDateTime))) {
            unset($this->LastModifiedDateTime);
        } else {
            $this->LastModifiedDateTime = $lastModifiedDateTime;
        }
        return $this;
    }
    /**
     * Get TaxCategoryID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getTaxCategoryID()
    {
        return isset($this->TaxCategoryID) ? $this->TaxCategoryID : null;
    }
    /**
     * Set TaxCategoryID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $taxCategoryID
     * @return \App\API\SOAP\StructType\TaxCategory
     */
    public function setTaxCategoryID(\App\API\SOAP\StructType\StringValue $taxCategoryID = null)
    {
        if (is_null($taxCategoryID) || (is_array($taxCategoryID) && empty($taxCategoryID))) {
            unset($this->TaxCategoryID);
        } else {
            $this->TaxCategoryID = $taxCategoryID;
        }
        return $this;
    }
}
