<?php

namespace App\API\SOAP\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Tax StructType
 * @subpackage Structs
 */
class Tax extends Entity
{
    /**
     * The CalculateOn
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $CalculateOn;
    /**
     * The CashDiscount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $CashDiscount;
    /**
     * The CreatedDateTime
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\DateTimeValue
     */
    public $CreatedDateTime;
    /**
     * The DeductibleVAT
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\BooleanValue
     */
    public $DeductibleVAT;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $Description;
    /**
     * The EnterFromTaxBill
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\BooleanValue
     */
    public $EnterFromTaxBill;
    /**
     * The ExcludeFromTaxonTaxCalculation
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\BooleanValue
     */
    public $ExcludeFromTaxonTaxCalculation;
    /**
     * The IncludeInVATExemptTotal
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\BooleanValue
     */
    public $IncludeInVATExemptTotal;
    /**
     * The IncludeInVATTaxableTotal
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\BooleanValue
     */
    public $IncludeInVATTaxableTotal;
    /**
     * The LastModifiedDateTime
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\DateTimeValue
     */
    public $LastModifiedDateTime;
    /**
     * The NotValidAfter
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\DateTimeValue
     */
    public $NotValidAfter;
    /**
     * The PendingVAT
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\BooleanValue
     */
    public $PendingVAT;
    /**
     * The ReverseVAT
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\BooleanValue
     */
    public $ReverseVAT;
    /**
     * The StatisticalVAT
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\BooleanValue
     */
    public $StatisticalVAT;
    /**
     * The TaxAgency
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $TaxAgency;
    /**
     * The TaxClaimableAccount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $TaxClaimableAccount;
    /**
     * The TaxClaimableSubaccount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $TaxClaimableSubaccount;
    /**
     * The TaxExpenseAccount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $TaxExpenseAccount;
    /**
     * The TaxExpenseSubaccount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $TaxExpenseSubaccount;
    /**
     * The TaxID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $TaxID;
    /**
     * The TaxPayableAccount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $TaxPayableAccount;
    /**
     * The TaxPayableSubaccount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $TaxPayableSubaccount;
    /**
     * The TaxSchedule
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\TaxSchedule
     */
    public $TaxSchedule;
    /**
     * The TaxType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $TaxType;
    /**
     * The Zones
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\Zones
     */
    public $Zones;
    /**
     * Constructor method for Tax
     * @uses Tax::setCalculateOn()
     * @uses Tax::setCashDiscount()
     * @uses Tax::setCreatedDateTime()
     * @uses Tax::setDeductibleVAT()
     * @uses Tax::setDescription()
     * @uses Tax::setEnterFromTaxBill()
     * @uses Tax::setExcludeFromTaxonTaxCalculation()
     * @uses Tax::setIncludeInVATExemptTotal()
     * @uses Tax::setIncludeInVATTaxableTotal()
     * @uses Tax::setLastModifiedDateTime()
     * @uses Tax::setNotValidAfter()
     * @uses Tax::setPendingVAT()
     * @uses Tax::setReverseVAT()
     * @uses Tax::setStatisticalVAT()
     * @uses Tax::setTaxAgency()
     * @uses Tax::setTaxClaimableAccount()
     * @uses Tax::setTaxClaimableSubaccount()
     * @uses Tax::setTaxExpenseAccount()
     * @uses Tax::setTaxExpenseSubaccount()
     * @uses Tax::setTaxID()
     * @uses Tax::setTaxPayableAccount()
     * @uses Tax::setTaxPayableSubaccount()
     * @uses Tax::setTaxSchedule()
     * @uses Tax::setTaxType()
     * @uses Tax::setZones()
     * @param \App\API\SOAP\StructType\StringValue $calculateOn
     * @param \App\API\SOAP\StructType\StringValue $cashDiscount
     * @param \App\API\SOAP\StructType\DateTimeValue $createdDateTime
     * @param \App\API\SOAP\StructType\BooleanValue $deductibleVAT
     * @param \App\API\SOAP\StructType\StringValue $description
     * @param \App\API\SOAP\StructType\BooleanValue $enterFromTaxBill
     * @param \App\API\SOAP\StructType\BooleanValue $excludeFromTaxonTaxCalculation
     * @param \App\API\SOAP\StructType\BooleanValue $includeInVATExemptTotal
     * @param \App\API\SOAP\StructType\BooleanValue $includeInVATTaxableTotal
     * @param \App\API\SOAP\StructType\DateTimeValue $lastModifiedDateTime
     * @param \App\API\SOAP\StructType\DateTimeValue $notValidAfter
     * @param \App\API\SOAP\StructType\BooleanValue $pendingVAT
     * @param \App\API\SOAP\StructType\BooleanValue $reverseVAT
     * @param \App\API\SOAP\StructType\BooleanValue $statisticalVAT
     * @param \App\API\SOAP\StructType\StringValue $taxAgency
     * @param \App\API\SOAP\StructType\StringValue $taxClaimableAccount
     * @param \App\API\SOAP\StructType\StringValue $taxClaimableSubaccount
     * @param \App\API\SOAP\StructType\StringValue $taxExpenseAccount
     * @param \App\API\SOAP\StructType\StringValue $taxExpenseSubaccount
     * @param \App\API\SOAP\StructType\StringValue $taxID
     * @param \App\API\SOAP\StructType\StringValue $taxPayableAccount
     * @param \App\API\SOAP\StructType\StringValue $taxPayableSubaccount
     * @param \App\API\SOAP\StructType\TaxSchedule $taxSchedule
     * @param \App\API\SOAP\StructType\StringValue $taxType
     * @param \App\API\SOAP\StructType\Zones $zones
     */
    public function __construct(\App\API\SOAP\StructType\StringValue $calculateOn = null, \App\API\SOAP\StructType\StringValue $cashDiscount = null, \App\API\SOAP\StructType\DateTimeValue $createdDateTime = null, \App\API\SOAP\StructType\BooleanValue $deductibleVAT = null, \App\API\SOAP\StructType\StringValue $description = null, \App\API\SOAP\StructType\BooleanValue $enterFromTaxBill = null, \App\API\SOAP\StructType\BooleanValue $excludeFromTaxonTaxCalculation = null, \App\API\SOAP\StructType\BooleanValue $includeInVATExemptTotal = null, \App\API\SOAP\StructType\BooleanValue $includeInVATTaxableTotal = null, \App\API\SOAP\StructType\DateTimeValue $lastModifiedDateTime = null, \App\API\SOAP\StructType\DateTimeValue $notValidAfter = null, \App\API\SOAP\StructType\BooleanValue $pendingVAT = null, \App\API\SOAP\StructType\BooleanValue $reverseVAT = null, \App\API\SOAP\StructType\BooleanValue $statisticalVAT = null, \App\API\SOAP\StructType\StringValue $taxAgency = null, \App\API\SOAP\StructType\StringValue $taxClaimableAccount = null, \App\API\SOAP\StructType\StringValue $taxClaimableSubaccount = null, \App\API\SOAP\StructType\StringValue $taxExpenseAccount = null, \App\API\SOAP\StructType\StringValue $taxExpenseSubaccount = null, \App\API\SOAP\StructType\StringValue $taxID = null, \App\API\SOAP\StructType\StringValue $taxPayableAccount = null, \App\API\SOAP\StructType\StringValue $taxPayableSubaccount = null, \App\API\SOAP\StructType\TaxSchedule $taxSchedule = null, \App\API\SOAP\StructType\StringValue $taxType = null, \App\API\SOAP\StructType\Zones $zones = null)
    {
        $this
            ->setCalculateOn($calculateOn)
            ->setCashDiscount($cashDiscount)
            ->setCreatedDateTime($createdDateTime)
            ->setDeductibleVAT($deductibleVAT)
            ->setDescription($description)
            ->setEnterFromTaxBill($enterFromTaxBill)
            ->setExcludeFromTaxonTaxCalculation($excludeFromTaxonTaxCalculation)
            ->setIncludeInVATExemptTotal($includeInVATExemptTotal)
            ->setIncludeInVATTaxableTotal($includeInVATTaxableTotal)
            ->setLastModifiedDateTime($lastModifiedDateTime)
            ->setNotValidAfter($notValidAfter)
            ->setPendingVAT($pendingVAT)
            ->setReverseVAT($reverseVAT)
            ->setStatisticalVAT($statisticalVAT)
            ->setTaxAgency($taxAgency)
            ->setTaxClaimableAccount($taxClaimableAccount)
            ->setTaxClaimableSubaccount($taxClaimableSubaccount)
            ->setTaxExpenseAccount($taxExpenseAccount)
            ->setTaxExpenseSubaccount($taxExpenseSubaccount)
            ->setTaxID($taxID)
            ->setTaxPayableAccount($taxPayableAccount)
            ->setTaxPayableSubaccount($taxPayableSubaccount)
            ->setTaxSchedule($taxSchedule)
            ->setTaxType($taxType)
            ->setZones($zones);
    }
    /**
     * Get CalculateOn value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getCalculateOn()
    {
        return isset($this->CalculateOn) ? $this->CalculateOn : null;
    }
    /**
     * Set CalculateOn value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $calculateOn
     * @return \App\API\SOAP\StructType\Tax
     */
    public function setCalculateOn(\App\API\SOAP\StructType\StringValue $calculateOn = null)
    {
        if (is_null($calculateOn) || (is_array($calculateOn) && empty($calculateOn))) {
            unset($this->CalculateOn);
        } else {
            $this->CalculateOn = $calculateOn;
        }
        return $this;
    }
    /**
     * Get CashDiscount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getCashDiscount()
    {
        return isset($this->CashDiscount) ? $this->CashDiscount : null;
    }
    /**
     * Set CashDiscount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $cashDiscount
     * @return \App\API\SOAP\StructType\Tax
     */
    public function setCashDiscount(\App\API\SOAP\StructType\StringValue $cashDiscount = null)
    {
        if (is_null($cashDiscount) || (is_array($cashDiscount) && empty($cashDiscount))) {
            unset($this->CashDiscount);
        } else {
            $this->CashDiscount = $cashDiscount;
        }
        return $this;
    }
    /**
     * Get CreatedDateTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\DateTimeValue|null
     */
    public function getCreatedDateTime()
    {
        return isset($this->CreatedDateTime) ? $this->CreatedDateTime : null;
    }
    /**
     * Set CreatedDateTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\DateTimeValue $createdDateTime
     * @return \App\API\SOAP\StructType\Tax
     */
    public function setCreatedDateTime(\App\API\SOAP\StructType\DateTimeValue $createdDateTime = null)
    {
        if (is_null($createdDateTime) || (is_array($createdDateTime) && empty($createdDateTime))) {
            unset($this->CreatedDateTime);
        } else {
            $this->CreatedDateTime = $createdDateTime;
        }
        return $this;
    }
    /**
     * Get DeductibleVAT value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\BooleanValue|null
     */
    public function getDeductibleVAT()
    {
        return isset($this->DeductibleVAT) ? $this->DeductibleVAT : null;
    }
    /**
     * Set DeductibleVAT value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\BooleanValue $deductibleVAT
     * @return \App\API\SOAP\StructType\Tax
     */
    public function setDeductibleVAT(\App\API\SOAP\StructType\BooleanValue $deductibleVAT = null)
    {
        if (is_null($deductibleVAT) || (is_array($deductibleVAT) && empty($deductibleVAT))) {
            unset($this->DeductibleVAT);
        } else {
            $this->DeductibleVAT = $deductibleVAT;
        }
        return $this;
    }
    /**
     * Get Description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getDescription()
    {
        return isset($this->Description) ? $this->Description : null;
    }
    /**
     * Set Description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $description
     * @return \App\API\SOAP\StructType\Tax
     */
    public function setDescription(\App\API\SOAP\StructType\StringValue $description = null)
    {
        if (is_null($description) || (is_array($description) && empty($description))) {
            unset($this->Description);
        } else {
            $this->Description = $description;
        }
        return $this;
    }
    /**
     * Get EnterFromTaxBill value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\BooleanValue|null
     */
    public function getEnterFromTaxBill()
    {
        return isset($this->EnterFromTaxBill) ? $this->EnterFromTaxBill : null;
    }
    /**
     * Set EnterFromTaxBill value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\BooleanValue $enterFromTaxBill
     * @return \App\API\SOAP\StructType\Tax
     */
    public function setEnterFromTaxBill(\App\API\SOAP\StructType\BooleanValue $enterFromTaxBill = null)
    {
        if (is_null($enterFromTaxBill) || (is_array($enterFromTaxBill) && empty($enterFromTaxBill))) {
            unset($this->EnterFromTaxBill);
        } else {
            $this->EnterFromTaxBill = $enterFromTaxBill;
        }
        return $this;
    }
    /**
     * Get ExcludeFromTaxonTaxCalculation value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\BooleanValue|null
     */
    public function getExcludeFromTaxonTaxCalculation()
    {
        return isset($this->ExcludeFromTaxonTaxCalculation) ? $this->ExcludeFromTaxonTaxCalculation : null;
    }
    /**
     * Set ExcludeFromTaxonTaxCalculation value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\BooleanValue $excludeFromTaxonTaxCalculation
     * @return \App\API\SOAP\StructType\Tax
     */
    public function setExcludeFromTaxonTaxCalculation(\App\API\SOAP\StructType\BooleanValue $excludeFromTaxonTaxCalculation = null)
    {
        if (is_null($excludeFromTaxonTaxCalculation) || (is_array($excludeFromTaxonTaxCalculation) && empty($excludeFromTaxonTaxCalculation))) {
            unset($this->ExcludeFromTaxonTaxCalculation);
        } else {
            $this->ExcludeFromTaxonTaxCalculation = $excludeFromTaxonTaxCalculation;
        }
        return $this;
    }
    /**
     * Get IncludeInVATExemptTotal value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\BooleanValue|null
     */
    public function getIncludeInVATExemptTotal()
    {
        return isset($this->IncludeInVATExemptTotal) ? $this->IncludeInVATExemptTotal : null;
    }
    /**
     * Set IncludeInVATExemptTotal value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\BooleanValue $includeInVATExemptTotal
     * @return \App\API\SOAP\StructType\Tax
     */
    public function setIncludeInVATExemptTotal(\App\API\SOAP\StructType\BooleanValue $includeInVATExemptTotal = null)
    {
        if (is_null($includeInVATExemptTotal) || (is_array($includeInVATExemptTotal) && empty($includeInVATExemptTotal))) {
            unset($this->IncludeInVATExemptTotal);
        } else {
            $this->IncludeInVATExemptTotal = $includeInVATExemptTotal;
        }
        return $this;
    }
    /**
     * Get IncludeInVATTaxableTotal value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\BooleanValue|null
     */
    public function getIncludeInVATTaxableTotal()
    {
        return isset($this->IncludeInVATTaxableTotal) ? $this->IncludeInVATTaxableTotal : null;
    }
    /**
     * Set IncludeInVATTaxableTotal value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\BooleanValue $includeInVATTaxableTotal
     * @return \App\API\SOAP\StructType\Tax
     */
    public function setIncludeInVATTaxableTotal(\App\API\SOAP\StructType\BooleanValue $includeInVATTaxableTotal = null)
    {
        if (is_null($includeInVATTaxableTotal) || (is_array($includeInVATTaxableTotal) && empty($includeInVATTaxableTotal))) {
            unset($this->IncludeInVATTaxableTotal);
        } else {
            $this->IncludeInVATTaxableTotal = $includeInVATTaxableTotal;
        }
        return $this;
    }
    /**
     * Get LastModifiedDateTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\DateTimeValue|null
     */
    public function getLastModifiedDateTime()
    {
        return isset($this->LastModifiedDateTime) ? $this->LastModifiedDateTime : null;
    }
    /**
     * Set LastModifiedDateTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\DateTimeValue $lastModifiedDateTime
     * @return \App\API\SOAP\StructType\Tax
     */
    public function setLastModifiedDateTime(\App\API\SOAP\StructType\DateTimeValue $lastModifiedDateTime = null)
    {
        if (is_null($lastModifiedDateTime) || (is_array($lastModifiedDateTime) && empty($lastModifiedDateTime))) {
            unset($this->LastModifiedDateTime);
        } else {
            $this->LastModifiedDateTime = $lastModifiedDateTime;
        }
        return $this;
    }
    /**
     * Get NotValidAfter value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\DateTimeValue|null
     */
    public function getNotValidAfter()
    {
        return isset($this->NotValidAfter) ? $this->NotValidAfter : null;
    }
    /**
     * Set NotValidAfter value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\DateTimeValue $notValidAfter
     * @return \App\API\SOAP\StructType\Tax
     */
    public function setNotValidAfter(\App\API\SOAP\StructType\DateTimeValue $notValidAfter = null)
    {
        if (is_null($notValidAfter) || (is_array($notValidAfter) && empty($notValidAfter))) {
            unset($this->NotValidAfter);
        } else {
            $this->NotValidAfter = $notValidAfter;
        }
        return $this;
    }
    /**
     * Get PendingVAT value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\BooleanValue|null
     */
    public function getPendingVAT()
    {
        return isset($this->PendingVAT) ? $this->PendingVAT : null;
    }
    /**
     * Set PendingVAT value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\BooleanValue $pendingVAT
     * @return \App\API\SOAP\StructType\Tax
     */
    public function setPendingVAT(\App\API\SOAP\StructType\BooleanValue $pendingVAT = null)
    {
        if (is_null($pendingVAT) || (is_array($pendingVAT) && empty($pendingVAT))) {
            unset($this->PendingVAT);
        } else {
            $this->PendingVAT = $pendingVAT;
        }
        return $this;
    }
    /**
     * Get ReverseVAT value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\BooleanValue|null
     */
    public function getReverseVAT()
    {
        return isset($this->ReverseVAT) ? $this->ReverseVAT : null;
    }
    /**
     * Set ReverseVAT value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\BooleanValue $reverseVAT
     * @return \App\API\SOAP\StructType\Tax
     */
    public function setReverseVAT(\App\API\SOAP\StructType\BooleanValue $reverseVAT = null)
    {
        if (is_null($reverseVAT) || (is_array($reverseVAT) && empty($reverseVAT))) {
            unset($this->ReverseVAT);
        } else {
            $this->ReverseVAT = $reverseVAT;
        }
        return $this;
    }
    /**
     * Get StatisticalVAT value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\BooleanValue|null
     */
    public function getStatisticalVAT()
    {
        return isset($this->StatisticalVAT) ? $this->StatisticalVAT : null;
    }
    /**
     * Set StatisticalVAT value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\BooleanValue $statisticalVAT
     * @return \App\API\SOAP\StructType\Tax
     */
    public function setStatisticalVAT(\App\API\SOAP\StructType\BooleanValue $statisticalVAT = null)
    {
        if (is_null($statisticalVAT) || (is_array($statisticalVAT) && empty($statisticalVAT))) {
            unset($this->StatisticalVAT);
        } else {
            $this->StatisticalVAT = $statisticalVAT;
        }
        return $this;
    }
    /**
     * Get TaxAgency value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getTaxAgency()
    {
        return isset($this->TaxAgency) ? $this->TaxAgency : null;
    }
    /**
     * Set TaxAgency value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $taxAgency
     * @return \App\API\SOAP\StructType\Tax
     */
    public function setTaxAgency(\App\API\SOAP\StructType\StringValue $taxAgency = null)
    {
        if (is_null($taxAgency) || (is_array($taxAgency) && empty($taxAgency))) {
            unset($this->TaxAgency);
        } else {
            $this->TaxAgency = $taxAgency;
        }
        return $this;
    }
    /**
     * Get TaxClaimableAccount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getTaxClaimableAccount()
    {
        return isset($this->TaxClaimableAccount) ? $this->TaxClaimableAccount : null;
    }
    /**
     * Set TaxClaimableAccount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $taxClaimableAccount
     * @return \App\API\SOAP\StructType\Tax
     */
    public function setTaxClaimableAccount(\App\API\SOAP\StructType\StringValue $taxClaimableAccount = null)
    {
        if (is_null($taxClaimableAccount) || (is_array($taxClaimableAccount) && empty($taxClaimableAccount))) {
            unset($this->TaxClaimableAccount);
        } else {
            $this->TaxClaimableAccount = $taxClaimableAccount;
        }
        return $this;
    }
    /**
     * Get TaxClaimableSubaccount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getTaxClaimableSubaccount()
    {
        return isset($this->TaxClaimableSubaccount) ? $this->TaxClaimableSubaccount : null;
    }
    /**
     * Set TaxClaimableSubaccount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $taxClaimableSubaccount
     * @return \App\API\SOAP\StructType\Tax
     */
    public function setTaxClaimableSubaccount(\App\API\SOAP\StructType\StringValue $taxClaimableSubaccount = null)
    {
        if (is_null($taxClaimableSubaccount) || (is_array($taxClaimableSubaccount) && empty($taxClaimableSubaccount))) {
            unset($this->TaxClaimableSubaccount);
        } else {
            $this->TaxClaimableSubaccount = $taxClaimableSubaccount;
        }
        return $this;
    }
    /**
     * Get TaxExpenseAccount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getTaxExpenseAccount()
    {
        return isset($this->TaxExpenseAccount) ? $this->TaxExpenseAccount : null;
    }
    /**
     * Set TaxExpenseAccount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $taxExpenseAccount
     * @return \App\API\SOAP\StructType\Tax
     */
    public function setTaxExpenseAccount(\App\API\SOAP\StructType\StringValue $taxExpenseAccount = null)
    {
        if (is_null($taxExpenseAccount) || (is_array($taxExpenseAccount) && empty($taxExpenseAccount))) {
            unset($this->TaxExpenseAccount);
        } else {
            $this->TaxExpenseAccount = $taxExpenseAccount;
        }
        return $this;
    }
    /**
     * Get TaxExpenseSubaccount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getTaxExpenseSubaccount()
    {
        return isset($this->TaxExpenseSubaccount) ? $this->TaxExpenseSubaccount : null;
    }
    /**
     * Set TaxExpenseSubaccount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $taxExpenseSubaccount
     * @return \App\API\SOAP\StructType\Tax
     */
    public function setTaxExpenseSubaccount(\App\API\SOAP\StructType\StringValue $taxExpenseSubaccount = null)
    {
        if (is_null($taxExpenseSubaccount) || (is_array($taxExpenseSubaccount) && empty($taxExpenseSubaccount))) {
            unset($this->TaxExpenseSubaccount);
        } else {
            $this->TaxExpenseSubaccount = $taxExpenseSubaccount;
        }
        return $this;
    }
    /**
     * Get TaxID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getTaxID()
    {
        return isset($this->TaxID) ? $this->TaxID : null;
    }
    /**
     * Set TaxID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $taxID
     * @return \App\API\SOAP\StructType\Tax
     */
    public function setTaxID(\App\API\SOAP\StructType\StringValue $taxID = null)
    {
        if (is_null($taxID) || (is_array($taxID) && empty($taxID))) {
            unset($this->TaxID);
        } else {
            $this->TaxID = $taxID;
        }
        return $this;
    }
    /**
     * Get TaxPayableAccount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getTaxPayableAccount()
    {
        return isset($this->TaxPayableAccount) ? $this->TaxPayableAccount : null;
    }
    /**
     * Set TaxPayableAccount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $taxPayableAccount
     * @return \App\API\SOAP\StructType\Tax
     */
    public function setTaxPayableAccount(\App\API\SOAP\StructType\StringValue $taxPayableAccount = null)
    {
        if (is_null($taxPayableAccount) || (is_array($taxPayableAccount) && empty($taxPayableAccount))) {
            unset($this->TaxPayableAccount);
        } else {
            $this->TaxPayableAccount = $taxPayableAccount;
        }
        return $this;
    }
    /**
     * Get TaxPayableSubaccount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getTaxPayableSubaccount()
    {
        return isset($this->TaxPayableSubaccount) ? $this->TaxPayableSubaccount : null;
    }
    /**
     * Set TaxPayableSubaccount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $taxPayableSubaccount
     * @return \App\API\SOAP\StructType\Tax
     */
    public function setTaxPayableSubaccount(\App\API\SOAP\StructType\StringValue $taxPayableSubaccount = null)
    {
        if (is_null($taxPayableSubaccount) || (is_array($taxPayableSubaccount) && empty($taxPayableSubaccount))) {
            unset($this->TaxPayableSubaccount);
        } else {
            $this->TaxPayableSubaccount = $taxPayableSubaccount;
        }
        return $this;
    }
    /**
     * Get TaxSchedule value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\TaxSchedule|null
     */
    public function getTaxSchedule()
    {
        return isset($this->TaxSchedule) ? $this->TaxSchedule : null;
    }
    /**
     * Set TaxSchedule value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\TaxSchedule $taxSchedule
     * @return \App\API\SOAP\StructType\Tax
     */
    public function setTaxSchedule(\App\API\SOAP\StructType\TaxSchedule $taxSchedule = null)
    {
        if (is_null($taxSchedule) || (is_array($taxSchedule) && empty($taxSchedule))) {
            unset($this->TaxSchedule);
        } else {
            $this->TaxSchedule = $taxSchedule;
        }
        return $this;
    }
    /**
     * Get TaxType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getTaxType()
    {
        return isset($this->TaxType) ? $this->TaxType : null;
    }
    /**
     * Set TaxType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $taxType
     * @return \App\API\SOAP\StructType\Tax
     */
    public function setTaxType(\App\API\SOAP\StructType\StringValue $taxType = null)
    {
        if (is_null($taxType) || (is_array($taxType) && empty($taxType))) {
            unset($this->TaxType);
        } else {
            $this->TaxType = $taxType;
        }
        return $this;
    }
    /**
     * Get Zones value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\Zones|null
     */
    public function getZones()
    {
        return isset($this->Zones) ? $this->Zones : null;
    }
    /**
     * Set Zones value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\Zones $zones
     * @return \App\API\SOAP\StructType\Tax
     */
    public function setZones(\App\API\SOAP\StructType\Zones $zones = null)
    {
        if (is_null($zones) || (is_array($zones) && empty($zones))) {
            unset($this->Zones);
        } else {
            $this->Zones = $zones;
        }
        return $this;
    }
}
