<?php

namespace App\API\SOAP\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TaskTimeActivity StructType
 * @subpackage Structs
 */
class TaskTimeActivity extends Entity
{
    /**
     * The BillableOvertime
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $BillableOvertime;
    /**
     * The BillableTime
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $BillableTime;
    /**
     * The CostCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $CostCode;
    /**
     * The Overtime
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $Overtime;
    /**
     * The Project
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $Project;
    /**
     * The ProjectTask
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $ProjectTask;
    /**
     * The TimeSpent
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $TimeSpent;
    /**
     * Constructor method for TaskTimeActivity
     * @uses TaskTimeActivity::setBillableOvertime()
     * @uses TaskTimeActivity::setBillableTime()
     * @uses TaskTimeActivity::setCostCode()
     * @uses TaskTimeActivity::setOvertime()
     * @uses TaskTimeActivity::setProject()
     * @uses TaskTimeActivity::setProjectTask()
     * @uses TaskTimeActivity::setTimeSpent()
     * @param \App\API\SOAP\StructType\StringValue $billableOvertime
     * @param \App\API\SOAP\StructType\StringValue $billableTime
     * @param \App\API\SOAP\StructType\StringValue $costCode
     * @param \App\API\SOAP\StructType\StringValue $overtime
     * @param \App\API\SOAP\StructType\StringValue $project
     * @param \App\API\SOAP\StructType\StringValue $projectTask
     * @param \App\API\SOAP\StructType\StringValue $timeSpent
     */
    public function __construct(\App\API\SOAP\StructType\StringValue $billableOvertime = null, \App\API\SOAP\StructType\StringValue $billableTime = null, \App\API\SOAP\StructType\StringValue $costCode = null, \App\API\SOAP\StructType\StringValue $overtime = null, \App\API\SOAP\StructType\StringValue $project = null, \App\API\SOAP\StructType\StringValue $projectTask = null, \App\API\SOAP\StructType\StringValue $timeSpent = null)
    {
        $this
            ->setBillableOvertime($billableOvertime)
            ->setBillableTime($billableTime)
            ->setCostCode($costCode)
            ->setOvertime($overtime)
            ->setProject($project)
            ->setProjectTask($projectTask)
            ->setTimeSpent($timeSpent);
    }
    /**
     * Get BillableOvertime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getBillableOvertime()
    {
        return isset($this->BillableOvertime) ? $this->BillableOvertime : null;
    }
    /**
     * Set BillableOvertime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $billableOvertime
     * @return \App\API\SOAP\StructType\TaskTimeActivity
     */
    public function setBillableOvertime(\App\API\SOAP\StructType\StringValue $billableOvertime = null)
    {
        if (is_null($billableOvertime) || (is_array($billableOvertime) && empty($billableOvertime))) {
            unset($this->BillableOvertime);
        } else {
            $this->BillableOvertime = $billableOvertime;
        }
        return $this;
    }
    /**
     * Get BillableTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getBillableTime()
    {
        return isset($this->BillableTime) ? $this->BillableTime : null;
    }
    /**
     * Set BillableTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $billableTime
     * @return \App\API\SOAP\StructType\TaskTimeActivity
     */
    public function setBillableTime(\App\API\SOAP\StructType\StringValue $billableTime = null)
    {
        if (is_null($billableTime) || (is_array($billableTime) && empty($billableTime))) {
            unset($this->BillableTime);
        } else {
            $this->BillableTime = $billableTime;
        }
        return $this;
    }
    /**
     * Get CostCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getCostCode()
    {
        return isset($this->CostCode) ? $this->CostCode : null;
    }
    /**
     * Set CostCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $costCode
     * @return \App\API\SOAP\StructType\TaskTimeActivity
     */
    public function setCostCode(\App\API\SOAP\StructType\StringValue $costCode = null)
    {
        if (is_null($costCode) || (is_array($costCode) && empty($costCode))) {
            unset($this->CostCode);
        } else {
            $this->CostCode = $costCode;
        }
        return $this;
    }
    /**
     * Get Overtime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getOvertime()
    {
        return isset($this->Overtime) ? $this->Overtime : null;
    }
    /**
     * Set Overtime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $overtime
     * @return \App\API\SOAP\StructType\TaskTimeActivity
     */
    public function setOvertime(\App\API\SOAP\StructType\StringValue $overtime = null)
    {
        if (is_null($overtime) || (is_array($overtime) && empty($overtime))) {
            unset($this->Overtime);
        } else {
            $this->Overtime = $overtime;
        }
        return $this;
    }
    /**
     * Get Project value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getProject()
    {
        return isset($this->Project) ? $this->Project : null;
    }
    /**
     * Set Project value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $project
     * @return \App\API\SOAP\StructType\TaskTimeActivity
     */
    public function setProject(\App\API\SOAP\StructType\StringValue $project = null)
    {
        if (is_null($project) || (is_array($project) && empty($project))) {
            unset($this->Project);
        } else {
            $this->Project = $project;
        }
        return $this;
    }
    /**
     * Get ProjectTask value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getProjectTask()
    {
        return isset($this->ProjectTask) ? $this->ProjectTask : null;
    }
    /**
     * Set ProjectTask value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $projectTask
     * @return \App\API\SOAP\StructType\TaskTimeActivity
     */
    public function setProjectTask(\App\API\SOAP\StructType\StringValue $projectTask = null)
    {
        if (is_null($projectTask) || (is_array($projectTask) && empty($projectTask))) {
            unset($this->ProjectTask);
        } else {
            $this->ProjectTask = $projectTask;
        }
        return $this;
    }
    /**
     * Get TimeSpent value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getTimeSpent()
    {
        return isset($this->TimeSpent) ? $this->TimeSpent : null;
    }
    /**
     * Set TimeSpent value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $timeSpent
     * @return \App\API\SOAP\StructType\TaskTimeActivity
     */
    public function setTimeSpent(\App\API\SOAP\StructType\StringValue $timeSpent = null)
    {
        if (is_null($timeSpent) || (is_array($timeSpent) && empty($timeSpent))) {
            unset($this->TimeSpent);
        } else {
            $this->TimeSpent = $timeSpent;
        }
        return $this;
    }
}
